/*** analhead.h: header file for analog 3.1 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

/*** Change any of these according to your desires ***/

#ifndef ANALHEAD
#define ANALHEAD

/*** The first few options -- up to LOGO -- are ones that you may want to
     change before compiling the program for the first time. However, all of
     them except MANDATORYCONFIGFILE can be changed at run time as well. ***/

#define HOSTNAME "[my organisation]"
/* the name of your organisation or WWW host. This is used for printing
   at the top of the output */

#define HOSTURL "none"
/* the URL of your host's home page, for linking to at the top of the
   output; use "none" for no linking. */

#define HTTPDIR "/usr/local/etc/httpd/"
#define ANALOGDIR HTTPDIR"analog/"
/* The directories where your HTTP stuff lives and where your analog stuff
   lives. You don't really need these; they are just used in this file to
   build up other filenames. Note how you can stick together names by
   just putting them next to each other; e.g., ANALOGDIR is defined as
   HTTPDIR"analog/", which becomes "/usr/local/etc/httpd/analog/" */

#define DOMAINSFILE ANALOGDIR"domains.tab"
/* the file where the domain definitions live; see docs/domfile.html */

#define LOGFILE HTTPDIR"logs/access_log"
/* The name of the default logfile. Can be a list, separated by commas
   (but no spaces), and can include wild cards. */

#define IMAGEDIR "images/"
/* URL of the directory where the images for the graphical reports live.
   The URL can be absolute, or relative to the output page: e.g., just the
   empty string "" for the same directory as the output page. */

#define LANGDIR ANALOGDIR"lang/"
/* Directory where the language files live. */

#define DEFAULTCONFIGFILE ANALOGDIR"analog.cfg"
/* the name of the default configuration file; see README.html for a
   description of this file. Use "none" (NOT ANALOGDIR"none"!) for no
   configuration file. */

#define MANDATORYCONFIGFILE "none"
/* A mandatory configuration file; read after all other arguments so
   overrides everything. Program exits if it is not found. Use "none"
   for none. */

#define LOGO "analogo.gif"
/* the file within the IMAGEDIR where the analog logo lives. You can put
   another logo in here (your organisation's logo, for example). Use "none"
   for no logo. */

/*** The next few options are compiled into the program. They can't be
     changed without re-compiling the program. ***/

#define BLOCKSIZE (32768)
/* Analog allocates memory in blocks of this many bytes. Also any logfile
   lines longer than this will be rejected. */

#define MAX_CONFIGS (50)
/* The maximum number of configuration files that are allowed. */

#define MINPAGEWIDTH (25)
#define MAXPAGEWIDTH (240)
/* the min and max allowed values of the pagewidth variable */

#define ALIGNMENT (8)
/* All objects can align on boundaries that are multiples of this. This
   is system-dependent, but I expect 8 to be big enough for everyone. */

/*** The rest of the options can be overridden when the program is run. ***/

#define OUTFILE "stdout"
/* the default file for output. Use "stdout" for stdout. */

#define CACHEOUTFILE "none"
/* The default file for cache output. Use "none" for no cache file. */

#define CACHEFILE "none"
/* The file for cache input. Again, can be "none". */

#ifndef NODNS
#define DNSFILE ANALOGDIR"dnscache"
/* where to store resolved addresses so we don't have to look them up next
   time */

#define DNS (DNS_NONE)
/* level of DNS activity. Can be DNS_NONE, DNS_READ, DNS_LOOKUP or
   DNS_WRITE. */

#define DNSGOODHOURS (672)
/* How many hours lookups stay fresh for before we have to look them
   up again. */

#define DNSBADHOURS (168)
/* After how many hours to retry failed lookups. */
#endif

#define DIRSUFFIX "index.html"
/* the default filename tried if a directory is requested. The program
   combines statistics from /dir/ and /dir/DIRSUFFIX. If you don't wish
   this combining to occur, define DIRSUFFIX to be "". The usual value
   is "index.html". */

#define CASE_INSENSITIVE (TRUE)
#ifdef UNIX
#undef CASE_INSENSITIVE
#define CASE_INSENSITIVE (FALSE)
#endif
#ifdef BEOS
#undef CASE_INSENSITIVE
#define CASE_INSENSITIVE (FALSE)
#endif
/* Do you have a case sensitive or case insensitive file system? */

#define REPORTORDER "xmWDdHh45uJoSvitzcrEIfskKbB"
/* A string like "xmWDdHh45uJoSvitzcrEIfskKbB" giving the order in which the
   reports will be output. You should include each of the above letters exactly
   once. See docs/output.html for which report has which code letter. */

/* whether we want each of the reports by default */
#define GENERAL (TRUE)      /* General summary */
#define MONTHLY (TRUE)      /* Monthly report */
#define DAILY (TRUE)        /* Daily summary */
#define FULLDAILY (FALSE)   /* Daily report */
#define WEEKLY (FALSE)      /* Weekly report */
#define HOURLY (TRUE)       /* Hourly summary */
#define FULLHOURLY (FALSE)  /* Hourly report */
#define QUARTER (FALSE)     /* Quarter-hour report */
#define FIVE (FALSE)        /* Five-minute report */
#define DOMAINREP (TRUE)    /* Domain report */
/* Not called DOMAIN because would clash with math.h on some systems */
#define DIRECTORY (TRUE)    /* Directory report */
#define FILETYPE (TRUE)     /* File type report */
#define REQUEST (TRUE)      /* Request report */
#define REDIRREP (FALSE)    /* Redirection report */
#define FAILREP (FALSE)     /* Failure report */
#define SIZEREP (TRUE)      /* File size report */
#define HOST (FALSE)        /* Host report */
#define REFERRER (FALSE)    /* Referrer report */
#define REFSITE (FALSE)     /* Referring site report */
#define REDIRREF (FALSE)    /* Redirected referrer report */
#define FAILREF (FALSE)     /* Failed referrer report */
#define VHOST (FALSE)       /* Virtual host report */
#define USER (FALSE)        /* User report */
#define FAILUSER (FALSE)    /* Failed user report */
#define BROWSER (FALSE)     /* Browser summary */
#define FULLBROWSER (FALSE) /* Browser report */
#define STATUS (TRUE)       /* Status code report */

#define GOTOS (TRUE)        /* "Go To" lines */

#define DOMCOLS "Rb"
/* Which columns we want to appear in the domain report, and in which order.
   The string can contain any of the following letters:
   R   Number of requests from each domain
   r   Percentage of the requests from each domain
   P   Number of requests for pages from each domain
   p   Percentage of the requests for pages from each domain
   B   Total number of bytes transferred to each domain
   b   The percentage of traffic to each domain
   D   Date and time of last access from each domain */
/* And the same for the other reports */
#define HOSTCOLS "Rb"
#define DIRCOLS "Rb"
#define TYPECOLS "Rb"
#define REQCOLS "RbD"
#define REDIRCOLS "R"
#define FAILCOLS "R"
#define MONTHCOLS "RP"
#define DAYCOLS "RP"
#define FULLDAYCOLS "RP"
#define WEEKCOLS "RP"
#define HOURCOLS "RP"
#define FULLHOURCOLS "RP"
#define QUARTERCOLS "RP"
#define FIVECOLS "RP"
#define REFCOLS "R"
#define REFSITECOLS "R"
#define REDIRREFCOLS "R"
#define FAILREFCOLS "R"
#define BROWCOLS "R"
#define FULLBROWCOLS "R"
#define SIZECOLS "Rb"
#define VHOSTCOLS "Rb"
#define USERCOLS "Rb"
#define FAILUSERCOLS "R"
#define STATUSCOLS "R"

/* Should the time graphs be calculated by requests 'R', bytes 'B' or
   pages 'P': or use 'r', 'b', 'p' for gif-free barcharts. */
#define MONTHGRAPH 'P'
#define DAYGRAPH 'P'
#define FULLDAYGRAPH 'P'
#define HOURGRAPH 'P'
#define FULLHOURGRAPH 'P'
#define WEEKGRAPH 'P'
#define QUARTERGRAPH 'P'
#define FIVEGRAPH 'P'

/* Should they go forwards (oldest entries at top) or backwards? */
#define MONTHBACK (FALSE)
#define FULLDAYBACK (FALSE)
#define FULLHOURBACK (FALSE)
#define WEEKBACK (FALSE)
#define QUARTERBACK (FALSE)
#define FIVEBACK (FALSE)

/* The maximum number of rows in each (0 for "show all time") */
#define MONTHROWS (0)
#define WEEKROWS (0)
#define FULLDAYROWS (42)
#define FULLHOURROWS (72)
#define QUARTERROWS (96)
#define FIVEROWS (288)

/* The "floor" for each report. See docs/othreps.html for the possible formats
   for these strings. */
#define REQFLOOR "20r"
#define REQARGSFLOOR "10r"
#define REDIRFLOOR "-30r"
#define REDIRARGSFLOOR "10r"
#define FAILFLOOR "-30r"
#define FAILARGSFLOOR "10r"
#define DOMFLOOR "0b"
#define SUBDOMFLOOR "0.5%b"
#define DIRFLOOR "0.01%b"
#define SUBDIRFLOOR "0.01%b"
#define TYPEFLOOR "0.1%b"
#define SUBTYPEFLOOR "0.1%b"
#define HOSTFLOOR "100r"
#define REFFLOOR "20r"
#define REFARGSFLOOR "10r"
#define REFSITEFLOOR "-30r"
#define REFDIRFLOOR "50r"
#define REDIRREFFLOOR "-30r"
#define REDIRREFARGSFLOOR "10r"
#define FAILREFFLOOR "-30r"
#define FAILREFARGSFLOOR "10r"
#define BROWFLOOR "-20r"
#define FULLBROWFLOOR "-40r"
#define VHOSTFLOOR "-20b"
#define USERFLOOR "-100r"
#define FAILUSERFLOOR "-20r"
#define STATUSFLOOR "0r"

/* How to sort each report: REQUESTS, PAGES, BYTES, ALPHABETICAL, DATESORT or
   RANDOM */
#define REQSORTBY (REQUESTS)
#define REQARGSSORTBY (REQUESTS)
#define REDIRSORTBY (REQUESTS)
#define REDIRARGSSORTBY (REQUESTS)
#define FAILSORTBY (REQUESTS)
#define FAILARGSSORTBY (REQUESTS)
#define DOMSORTBY (BYTES)
#define SUBDOMSORTBY (BYTES)
#define DIRSORTBY (BYTES)
#define SUBDIRSORTBY (BYTES)
#define TYPESORTBY (BYTES)
#define SUBTYPESORTBY (BYTES)
#define HOSTSORTBY (ALPHABETICAL)
#define REFSORTBY (REQUESTS)
#define REFARGSSORTBY (REQUESTS)
#define REFSITESORTBY (REQUESTS)
#define REFDIRSORTBY (REQUESTS)
#define REDIRREFSORTBY (REQUESTS)
#define REDIRREFARGSSORTBY (REQUESTS)
#define FAILREFSORTBY (REQUESTS)
#define FAILREFARGSSORTBY (REQUESTS)
#define BROWSORTBY (REQUESTS)
#define FULLBROWSORTBY (REQUESTS)
#define VHOSTSORTBY (BYTES)
#define USERSORTBY (REQUESTS)
#define FAILUSERSORTBY (REQUESTS)
#define STATUSSORTBY (ALPHABETICAL)

#define WEEKBEGINSON (SUNDAY)
/* The 1st day of the week. I think it's SUNDAY, but you can choose any day. */

#define LASTSEVEN (TRUE)
/* Whether to include statistics for the last seven days */

#define SEPCHAR ','
/* The character to separate the thousands in a long number. I prefer ',',
   but some people prefer ' ' or '.'. Use '\0' for no separator. Use '9' if
   you really want to inflate your statistics! :) */

#define REPSEPCHAR '\0'
/* The same for long numbers within the detailed output */

#define DECPOINT '.'
/* Character to use as the decimal point. */

#define COMPSEP "\t"
/* A separator string between fields in "computer" output style */

#define RAWBYTES (FALSE)
/* whether bytes should be quoted in full (e.g., 1,021,453) as opposed to
   in kilobytes, megabytes etc. (e.g., 998k). */

#define HEADERFILE "none"
/* an extra file (with HTML markup if desired) placed between the page title
   and the start of the statistics. Use "none" for none. */

#define FOOTERFILE "none"
/* And one placed at the bottom of the page */

#define OUTPUT (HTML)
/* Default output type: ASCII, HTML, COMPUTER or CACHE */

#define LANGUAGE (ENGLISH)
/* Default language for the output page:
   CHINESE, CZECH, DANISH, DUTCH, ENGLISH, US_ENGLISH, FINNISH, FRENCH, GERMAN,
   GREEK, HUNGARIAN, ITALIAN, NORWEGIAN (Bokmal), NYNORSK, POLISH, PORTUGUESE,
   BR_PORTUGUESE, ROMANIAN, RUSSIAN, SLOVAK, SLOVENE, SPANISH, SWEDISH,
   TURKISH. */

#define MARKCHAR '+'
/* a character for the graphical displays */

#define PAGEWIDTH (65)
/* the width of the output. Standard text screens have 80 columns, but for
   WWW browsers something like 65 is probably better. */

#define MINGRAPHWIDTH (15)
/* bar charts must be at least this many characters wide */

#endif
