/*** analog 3.11      http://www.statslab.cam.ac.uk/~sret1/analog/  ***/

/*** analog.c; the main function ***/

#include "analhea2.h"

int main(int argc, char *argv[])
{
  extern char *pos, *record_start, *commandname;
  extern unsigned long progressfreq;
  extern Inputformatlist *logformat;
  extern logical vblesonly;

  Filelist *logfilep;
  Options *op;
  Inputformatlist *fmt;
  unsigned long linesread = 0, nextreport;
  FILE *lf;
  choice rc;

  op = (Options *)xmalloc(sizeof(Options));
  initialise(argc, argv, op);
  if (vblesonly) {
    report_vbles(op);
    my_exit(EXIT_SUCCESS);
  }
  nextreport = progressfreq;

  for (logfilep = op -> miscopts.cachefile; logfilep != NULL;
       TO_NEXT(logfilep)) {
    lf = my_lfopen(logfilep, "cache file");
    if (lf != NULL) {
      readcache(logfilep, lf, op -> hash, op -> wanthead, op -> ispagehead,
		op -> aliashead, &(op -> dman), op -> sizes,
		op -> outopts.tree, op -> outopts.alltrees,
		op -> miscopts.lowmem, op -> miscopts.dirsuffix,
		op -> miscopts.dirsufflength, op -> miscopts.granularity);
      (void)my_lfclose(lf, logfilep, op -> miscopts.cachefile, NULL,
		       "cache file", &(op -> dman), op -> miscopts.data,
		       &(op -> miscopts.bytes), &(op -> miscopts.bytes7),
		       op -> outopts.monthname, op -> outopts.plainmonthlen);
    }
  }

  for (logfilep = op -> miscopts.logfile; logfilep != NULL;
       TO_NEXT(logfilep)) {
    lf = logfile_init(logfilep);
    if (lf != NULL) {
      rc = FALSE;
      while (rc != EOF) {
	record_start = pos;
	for (fmt = logfilep -> format, rc = FALSE; rc == FALSE && fmt != NULL;
	     TO_NEXT(fmt)) {
	  rc = parsenextrecord(lf, fmt -> form);
	  if (rc == TRUE) {
	    process_data(logfilep, lf, op -> hash, fmt -> count,
			 op -> wanthead, op -> ispagehead, op -> aliashead,
			 op -> argshead, op -> refargshead, &(op -> dman),
			 op -> sizes, op -> outopts.tree,
			 op -> outopts.alltrees, op -> miscopts.lowmem,
			 op -> miscopts.case_insensitive,
			 op -> miscopts.dirsuffix,
			 op -> miscopts.dirsufflength,
			 op -> miscopts.granularity);
	  }
	  else if (rc == NEWLOGFMT) {
	    logfilep -> format = logformat;
	    if (correctlogfmt(logfilep, op -> wanthead,
			      &(op -> dman)) == NULL) {
	      debug('F', "Ignoring logfile %s, which contains no items "
		    "being analysed", logfilep -> name);
	      rc = EOF;
	    }
	  }
	  else if (rc == BADLOGFMT) {
	    warn('F', "Can't auto-detect format of logfile %s: ignoring it",
		 logfilep -> name);
	    rc = EOF;
	  }
	}
	if (rc == FALSE)
	  corrupt_line(lf, logfilep);
	if ((++linesread) == nextreport) {
	  (void)fprintf(stderr, "%s: %lu lines read\n", commandname,
			linesread);
	  nextreport += progressfreq;
	}
#ifdef MAC_EVENTS
	if ((linesread % MAC_IDLE_FREQ) == 0)
	  MacIdle();
#endif
      }
      (void)my_lfclose(lf, logfilep, op -> miscopts.cachefile,
		       op -> miscopts.logfile, "logfile", &(op -> dman),
		       op -> miscopts.data, &(op -> miscopts.bytes),
		       &(op -> miscopts.bytes7), op -> outopts.monthname,
		       op -> outopts.plainmonthlen);
    }
  }

  unhashall(op -> hash, &(op -> gooditems), &(op -> baditems));
  if (!STREQ(op -> outopts.cacheoutfile, "none"))
    outputcache(op -> outopts.cacheoutfile, op -> gooditems, &(op -> dman),
		op -> sizes, op -> miscopts.data, op -> miscopts.bytes);
  if (op -> outopts.outstyle != OUT_NONE)
    output(&(op -> outopts), op -> gooditems, op -> baditems, &(op -> dman),
	   op -> sizes, op -> miscopts.data, op -> miscopts.bytes,
	   op -> miscopts.bytes7, op -> miscopts.granularity);
  my_exit(EXIT_SUCCESS);
  return(EXIT_SUCCESS);  /* just to stop compiler complaining */
}
