/*** analog 3.11 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

/*** init2.c; subsiduary functions for parsing config files and command line */
/* See also init.c */

#include "analhea2.h"

choice strtoinfmt(Inputformat **ans, char *s, choice *count) {
  extern Memman *xmemman;
  extern Inputfns inpfns[], pnlinpfn, ccinpfn;

  Inputformat *ifp;
  logical done, count_this, typedone[INP_NUMBER];
  char tempchar;
  char *c;
  int i;

  if (strchr(s, '%') == NULL)
    return(FMT_NOPC);
  for (i = 0; i < ITEM_NUMBER; i++)
    count[i] = 0;
  for (i = 0; i < INP_NUMBER; i++)
    typedone[i] = 0;
  *ans = (Inputformat *)submalloc(xmemman, sizeof(Inputformat));
  ifp = *ans;
  for (c = s; *c != '\0'; c++) {
    if (*c == '%') {
      c++;
      if (*c == '%') {
	ifp -> inpfns = &ccinpfn;
	ifp -> sep = *c;
      }
      else {
	if (*c == '*') {
	  count_this = FALSE;
	  c++;
	}
	else
	  count_this = TRUE;
	done = FALSE;
	for (i = 0; !done && inpfns[i].code != '\0'; i++) {
	  if (*c == inpfns[i].code) {
	    if (inpfns[i].type != UNSET) {
	      if (typedone[inpfns[i].type])
		return(FMT_DUP);
	      typedone[inpfns[i].type] = TRUE;
	    }
	    ifp -> inpfns = &inpfns[i];
	    if (inpfns[i].fn == &parsestring || inpfns[i].fn == &parseref ||
		inpfns[i].fn == &parsemacfile || inpfns[i].fn == &parsemsbrow
		|| inpfns[i].fn == &parsejunk || inpfns[i].fn == &parsecode) {
	      c++;
	      if (*c == '\0') {
		ifp -> sep = '\n';
		c--;
	      }
	      else if (*c == '\\') {
		c++;
		if (*c == '\\')
		  ifp -> sep = *c;
		else if (*c == 'n' || *c == 'r')
		  ifp -> sep = '\n';
		else if (*c == 't')
		  ifp -> sep = '\t';
		else
		  return(FMT_BADCHAR);
	      }
	      else if (*c == '%') {
		c++;
		if (*c == '%')
		  ifp -> sep = *c;
		else if (*c == 'w') {
		  ifp -> sep = WHITESPACE;
		  c -= 2;  /* need to parsespace() too */
		}
		else
		  return(FMT_NOTERM);
	      }
	      else
		ifp -> sep = *c;
	    }
	    else if (inpfns[i].fn == &parselogfmt) {
	      c++;
	      if (*c < '0' || *c > '5')
		return(FMT_BADBUILTIN);
	      else
		ifp -> sep = *c;
	    }
	    else  /* fn != parse(string|ref|macfile|msbrow|junk|code|logfmt) */
	      ifp -> sep = '\0';
	    if (i < ITEMFNS_NUMBER)
	      count[inpfns[i].type] = count_this?2:1;
	    done = TRUE;
	  }     /* end if *c == inpfns[i].code */
	}       /* end for i */
	if (!done)
	  return(FMT_BADPC);
      }
    }    /* end if *c == '%' */
    else if (*c == '\\') {
      c++;
      if (*c == '\\') {
	ifp -> inpfns = &ccinpfn;
	ifp -> sep = *c;
      }
      else if (*c == 'n' || *c == 'r') {
	ifp -> inpfns = &pnlinpfn;
	ifp -> sep = '\n';
      }
      else if (*c == 't') {
	ifp -> inpfns = &ccinpfn;
	ifp -> sep = '\t';
      }
      else
	return(FMT_BADCHAR);
    }    /* end if *c == '\\' */
    else {
      ifp -> inpfns = &ccinpfn;
      ifp -> sep = *c;
    }
    ifp -> next = (Inputformat *)submalloc(xmemman, sizeof(Inputformat));
    tempchar = ifp -> sep;
    TO_NEXT(ifp);
  }
  if (tempchar != '\n') {
    ifp -> inpfns = &pnlinpfn;
    ifp -> next = (Inputformat *)submalloc(xmemman, sizeof(Inputformat));
    TO_NEXT(ifp);
  }
  ifp -> inpfns = NULL;
  if (typedone[INP_YEAR] || typedone[INP_MONTH] || typedone[INP_DATE] ||
      typedone[INP_HOUR] || typedone[INP_MIN] || typedone[INP_AM]) {
    if (!(typedone[INP_YEAR] && typedone[INP_MONTH] && typedone[INP_DATE] &&
	  typedone[INP_HOUR] && typedone[INP_MIN]))
      return(FMT_PARTTIME);  /* partial time info is corrupt */
    count[INP_DATE] = (count[ITEM_FILE] == 2)?2:1;
    count[INP_AM] = (choice)typedone[INP_AM];
  }
  else {
    count[INP_DATE] = 0;
    count[INP_AM] = 0;
  }
  if (typedone[INP_QUERY] && !typedone[ITEM_FILE])
    return(FMT_QBUTNOR);
  count[INP_BYTES] =
    2 * (choice)(typedone[INP_BYTES] && count[ITEM_FILE] == 2);
  count[INP_CODE] = 2 * (choice)(typedone[INP_CODE] && count[ITEM_FILE] == 2);
  return(FMT_OK);
}

/*** All config commands have the following structure:
  void config.....(void *opt, char *cmd, char *arg1, char *arg2, int rc)
  opt is the variable to be changed, "cmd arg1 arg2" is the config command
  issued, rc is the number of arguments retrieved from the config line (0..3),
  or -1 if the config command was issued by the program internally,
  or -2 if it was issued by the program in parsing command line (the last
  don't go throught confline(), so cmd is command line option). -3 is
  occasionally used for special cases. ***/

/* First some warnings of things that can go wrong in config commands */

void shortwarn(char *cmd, char *arg1, int rc) {
  char *s = "Configuration command too short: ignoring it";
  if (rc == -1)
    error("Default given for %s in analhead.h too short");
  else if (arg1 == NULL)
    warn('C', "%s:\n%s", s, cmd);
  else
    warn('C', "%s:\n%s %s", s, cmd, arg1);
}

void longwarn(char *cmd, char *arg1, char *arg2, int rc) {
  char *s = "Configuration command too long: ignoring end of line starting";
  if (rc == -1)
    warn('C', "Default given for %s in analhead.h too long: "
	 "ignoring end of it", cmd);
  else if (arg2 == NULL)
    warn('C', "%s:\n%s %s", s, cmd, arg1);
  else
    warn('C', "%s:\n%s %s %s", s, cmd, arg1, arg2);
}

void badwarn(char *cmd, char *arg1, char *arg2, int rc) {
  char *s = "Bad argument in configuration command: ignoring it";
  if (rc == -2)
    warn('C', "Bad argument in command line argument %s: ignoring it", cmd);
  else if (rc == -1)
    error("Incorrect default given for %s in analhead.h", cmd);
  else if (arg2 == NULL)
    warn('C', "%s:\n%s %s", s, cmd, arg1);
  else
    warn('C', "%s:\n%s %s %s", s, cmd, arg1, arg2);
}

void unknownwarn(char *cmd, char *arg1, char *arg2) {
  char *s = "Unknown configuration command: ignoring it";
  if (arg1 == NULL)
    warn('C', "%s:\n%s", s, cmd);  
  else if (arg2 == NULL)
    warn('C', "%s:\n%s %s", s, cmd, arg1);
  else
    warn('C', "%s:\n%s %s %s", s, cmd, arg1, arg2);
}

void configcall(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  if (rc == 0 || IS_EMPTY_STRING(arg1)) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  /* calling function will then call config() */
}

void configcols(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  choice *cols = (choice *)opt;  /* see also configallcols() */

  logical warn1 = FALSE, warn2 = FALSE, warn3;
  char *c;
  int i = 0, j;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  for (c = arg1; *c != '\0' && i < COL_NUMBER - 1; c++, i++) {
    if (*c == 'R')
      cols[i] = COL_REQS;
    else if (*c == 'P')
      cols[i] = COL_PAGES;
    else if (*c == 'B')
      cols[i] = COL_BYTES;
    else if (*c == 'r')
      cols[i] = COL_PREQS;
    else if (*c == 'p')
      cols[i] = COL_PPAGES;
    else if (*c == 'b')
      cols[i] = COL_PBYTES;
    else if (*c == 'D')
      cols[i] = COL_DATE;
    else {
      i--;
      if (!warn1) {
	warn('C', "Ignoring unknown columns in\n %s %s", cmd, arg1);
	warn1 = TRUE;
      }
    }
    for (j = 0, warn3 = FALSE; j < i && !warn3; j++) {
      if (cols[j] == cols[i]) {          /* shortest code, not least work */
	warn3 = TRUE;
	i--;   /* cancel i++ in for loop */
	if (!warn2) {
	  warn('C',
	       "Ignoring multiple equal cols in configuration command\n%s %s",
	       cmd, arg1);
	  warn2 = TRUE;
	}
      }
    }
  }
  if (*c != '\0' || rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  cols[i] = COL_NUMBER;
}

void configallcols(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  choice *cols = (choice *)opt;
  int j;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  for (j = 0; j < DATEREP_NUMBER; j++)    /* possibility of dup. warns */
    configcols((void *)&(cols[j * COL_NUMBER]), cmd, arg1, NULL, -3);
}

/* now a set of similar configs that use symbolic words */
void configsortby(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  choice *sortby = (choice *)opt;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  if (strcaseeq(arg1, "REQUESTS"))
    *sortby = REQUESTS;
  else if (strcaseeq(arg1, "PAGES"))
    *sortby = PAGES;
  else if (strcaseeq(arg1, "BYTES"))
    *sortby = BYTES;
  else if (strcaseeq(arg1, "DATE"))
    *sortby = DATESORT;
  else if (strcaseeq(arg1, "ALPHABETICAL"))
    *sortby = ALPHABETICAL;
  else if (strcaseeq(arg1, "RANDOM"))
    *sortby = RANDOM;
  else
    badwarn(cmd, arg1, arg2, rc);
}

void configdebug(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  char **args = (char **)opt;
  char *c;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  if (strcaseeq(arg1, "ON") || strcaseeq(arg1, "TRUE"))
    configstr(args, NULL, "CDFLMRSU", NULL, -1);
  /* kludge: include all of both sets: same string in settings.c */
  else if (strcaseeq(arg1, "OFF") || strcaseeq(arg1, "FALSE"))
    configstr(args, NULL, "", NULL, -1);
  else if (arg1[0] == '-') {
    while ((c = strpbrk(*args, arg1 + 1)) != NULL)
      (void)memmove((void *)c, (void *)(c + 1), strlen(c));
  }
  else if (arg1[0] == '+') {  /* c.f. configstr() */
    *args = (char *)xrealloc((void *)(*args), strlen(arg1) + strlen(*args));
    (void)memcpy((void *)strchr(*args, '\0'), (void *)arg1, strlen(arg1) + 1);
  }
  else {
    if (arg1[0] == '+')
      arg1++;
    configstr(args, NULL, arg1, NULL, -1);
  }
}

void configonoff(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  logical *q = (logical *)opt;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  if (strcaseeq(arg1, "ON") || strcaseeq(arg1, "TRUE"))
    *q = TRUE;
  else if (strcaseeq(arg1, "OFF") || strcaseeq(arg1, "FALSE"))
    *q = FALSE;
  else
    badwarn(cmd, arg1, arg2, rc);
}

void configall(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  logical *q = (logical *)opt;
  int i;
  logical result;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);

  if (strcaseeq(arg1, "ON") || strcaseeq(arg1, "TRUE"))
    result = TRUE;
  else if (strcaseeq(arg1, "OFF") || strcaseeq(arg1, "FALSE"))
    result = FALSE;
  else {
    badwarn(cmd, arg1, arg2, rc);
    return;
  }
  for (i = 0; i < REP_NUMBER; i++) {
    if (i != REP_GENSUM)
      q[i] = result;
  }
}

void configallback(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  logical *q = (logical *)opt;   /* same as configall(), but only DATEREPs */
  int i;
  logical result;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);

  if (strcaseeq(arg1, "ON") || strcaseeq(arg1, "TRUE"))
    result = TRUE;
  else if (strcaseeq(arg1, "OFF") || strcaseeq(arg1, "FALSE"))
    result = FALSE;
  else {
    badwarn(cmd, arg1, arg2, rc);
    return;
  }
  for (i = 0; i < DATEREP_NUMBER; i++)
    q[i] = result;
}

void configcase(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  logical *q = (logical *)opt;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  if (strcaseeq(arg1, "INSENSITIVE"))
    *q = TRUE;
  else if (strcaseeq(arg1, "SENSITIVE"))
    *q = FALSE;
  else
    badwarn(cmd, arg1, arg2, rc);
}

void configweekday(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  choice *d = (choice *)opt;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  if (strcaseeq(arg1, "SUNDAY"))
    *d = SUNDAY;
  else if (strcaseeq(arg1, "MONDAY"))
    *d = MONDAY;
  else if (strcaseeq(arg1, "TUESDAY"))
    *d = TUESDAY;
  else if (strcaseeq(arg1, "WEDNESDAY"))
    *d = WEDNESDAY;
  else if (strcaseeq(arg1, "THURSDAY"))
    *d = THURSDAY;
  else if (strcaseeq(arg1, "FRIDAY"))
    *d = FRIDAY;
  else if (strcaseeq(arg1, "SATURDAY"))
    *d = SATURDAY;
  else
    badwarn(cmd, arg1, arg2, rc);
}

void configoutstyle(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  choice *s = (choice *)opt;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  if (strcaseeq(arg1, "HTML"))
    *s = HTML;
  else if (strcaseeq(arg1, "ASCII"))
    *s = ASCII;
  else if (strcaseeq(arg1, "COMPUTER") || strcaseeq(arg1, "PREFORMATTED"))
    *s = COMPUTER;
  else if (strcaseeq(arg1, "CACHE") || strcaseeq(arg1, "NONE"))
    *s = OUT_NONE;
  else
    badwarn(cmd, arg1, arg2, rc);
}

#ifndef NODNS
void configdns(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  choice *s = (choice *)opt;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  if (strcaseeq(arg1, "NONE"))
    *s = DNS_NONE;
  else if (strcaseeq(arg1, "READ"))
    *s = DNS_READ;
  else if (strcaseeq(arg1, "LOOKUP"))
    *s = DNS_LOOKUP;
  else if (strcaseeq(arg1, "WRITE"))
    *s = DNS_WRITE;
  else
    badwarn(cmd, arg1, arg2, rc);
}
#endif

void configlang(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  Lang *lang = (Lang *)opt;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  if (strcaseeq(arg1, "ENGLISH"))
    lang -> code = ENGLISH;
  else if (strcaseeq(arg1, "US-ENGLISH"))
    lang -> code = US_ENGLISH;
  else if (strcaseeq(arg1, "FRENCH"))
    lang -> code = FRENCH;
  else if (strcaseeq(arg1, "GERMAN"))
    lang -> code = GERMAN;
  else if (strcaseeq(arg1, "ITALIAN"))
    lang -> code = ITALIAN;
  else if (strcaseeq(arg1, "PORTUGUESE") || strcaseeq(arg1, "PORTUGESE"))
    lang -> code = PORTUGUESE;
  else if (strcaseeq(arg1, "BR-PORTUGUESE") || strcaseeq(arg1, "BR-PORTUGESE"))
    lang -> code = BR_PORTUGUESE;
  else if (strcaseeq(arg1, "SWEDISH"))
    lang -> code = SWEDISH;
  else if (strcaseeq(arg1, "DANISH"))
    lang -> code = DANISH;
  else if (strcaseeq(arg1, "NORWEGIAN"))
    lang -> code = NORWEGIAN;
  else if (strcaseeq(arg1, "NYNORSK"))
    lang -> code = NYNORSK;
  else if (strcaseeq(arg1, "FLEMISH") || strcaseeq(arg1, "DUTCH"))
    lang -> code = FLEMISH;
  else if (strcaseeq(arg1, "HUNGARIAN"))
    lang -> code = HUNGARIAN;
  else if (strcaseeq(arg1, "CZECH"))
    lang -> code = CZECH;
  else if (strcaseeq(arg1, "SLOVENE"))
    lang -> code = SLOVENE;
  else if (strcaseeq(arg1, "SLOVAK"))
    lang -> code = SLOVAK;
  else if (strcaseeq(arg1, "ROMANIAN"))
    lang -> code = ROMANIAN;
  else if (strcaseeq(arg1, "TURKISH"))
    lang -> code = TURKISH;
  else if (strcaseeq(arg1, "GREEK"))
    lang -> code = GREEK;
  else if (strcaseeq(arg1, "CHINESE"))
    lang -> code = CHINESE;
  else if (strcaseeq(arg1, "SPANISH"))
    lang -> code = SPANISH;
  else if (strcaseeq(arg1, "FINNISH"))
    lang -> code = FINNISH;
  else if (strcaseeq(arg1, "POLISH"))
    lang -> code = POLISH;
  else if (strcaseeq(arg1, "RUSSIAN"))
    lang -> code = RUSSIAN;
  /* Not yet translated for version 3
  else if (strcaseeq(arg1, "CATALAN"))
    lang -> code = CATALAN;*/
  else {
    badwarn(cmd, arg1, arg2, rc);
    return;
  }
  lang -> file = NULL;   /* if successful */
}

void configlogfmt(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  extern Memman *xmemman;
  Inputformatlist **logfmt = (Inputformatlist **)opt;
  Inputformatlist *fp;
  Inputformat *form;
  choice count[INPUT_NUMBER];
  choice rc2;
  int i;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);

  if (strcaseeq(arg1, "DEFAULT")) {
    (*logfmt) -> used = TRUE;
    configlogfmt(opt, NULL, "%x0", NULL, -1);
    (*logfmt) -> used = TRUE;
  }
  else if (strcaseeq(arg1, "AUTO")) {
    (*logfmt) -> used = TRUE;
    configlogfmt(opt, NULL, "%x1", NULL, -1);
    (*logfmt) -> used = TRUE;
  }
  else if (strcaseeq(arg1, "COMMON")) {
    configlogfmt(opt, NULL, LOG_COMMON1, NULL, -1);
    configlogfmt(opt, NULL, LOG_COMMON2, NULL, -1);
    configlogfmt(opt, NULL, LOG_COMMON3, NULL, -1);
  }
  else if (strcaseeq(arg1, "MS-COMMON")) {
    configlogfmt(opt, NULL, LOG_MS_COMMON1, NULL, -1);
    configlogfmt(opt, NULL, LOG_COMMON2, NULL, -1);
    configlogfmt(opt, NULL, LOG_COMMON3, NULL, -1);
  }
  else if (strcaseeq(arg1, "COMBINED")) {
    configlogfmt(opt, NULL, LOG_COMBINED1, NULL, -1);
    configlogfmt(opt, NULL, LOG_COMBINED2, NULL, -1);
    configlogfmt(opt, NULL, LOG_COMBINED3, NULL, -1);
  }
  else if (strcaseeq(arg1, "MICROSOFT-NA")) {
    configlogfmt(opt, NULL, LOG_MS_NA1, NULL, -1);
    configlogfmt(opt, NULL, LOG_MS_NA2, NULL, -1);
  }
  else if (strcaseeq(arg1, "MICROSOFT-INT")) {
    configlogfmt(opt, NULL, LOG_MS_INT1, NULL, -1);
    configlogfmt(opt, NULL, LOG_MS_INT2, NULL, -1);
  }
  else if (strcaseeq(arg1, "WEBSTAR")) {
    configlogfmt(opt, NULL, LOG_WEBSTAR1, NULL, -1);
    configlogfmt(opt, NULL, LOG_WEBSTAR2, NULL, -1);
  }
  else if (strcaseeq(arg1, "EXTENDED")) {
    configlogfmt(opt, NULL, LOG_EXTENDED1, NULL, -1);
    configlogfmt(opt, NULL, LOG_EXTENDED2, NULL, -1);
  }
  else if (strcaseeq(arg1, "MS-EXTENDED")) {
    configlogfmt(opt, NULL, LOG_MS_EXTENDED1, NULL, -1);
    configlogfmt(opt, NULL, LOG_EXTENDED2, NULL, -1);
  }
  else if (strcaseeq(arg1, "NETPRESENZ-NA")) {
    configlogfmt(opt, NULL, LOG_NP_NA1, NULL, -1);
    configlogfmt(opt, NULL, LOG_NP_NA2, NULL, -1);
    configlogfmt(opt, NULL, LOG_NP_NA3, NULL, -1);
    configlogfmt(opt, NULL, LOG_NP_BOTH4, NULL, -1);
  }
  else if (strcaseeq(arg1, "NETPRESENZ-INT")) {
    configlogfmt(opt, NULL, LOG_NP_INT1, NULL, -1);
    configlogfmt(opt, NULL, LOG_NP_INT2, NULL, -1);
    configlogfmt(opt, NULL, LOG_NP_INT3, NULL, -1);
    configlogfmt(opt, NULL, LOG_NP_BOTH4, NULL, -1);
  }
  else if (strcaseeq(arg1, "NETSCAPE"))
    configlogfmt(opt, NULL, LOG_NETSCAPE, NULL, -1);
  else if (strcaseeq(arg1, "REFERRER") || strcaseeq(arg1, "REFERER")) {
    configlogfmt(opt, NULL, LOG_REFERRER1, NULL, -1);
    configlogfmt(opt, NULL, LOG_REFERRER2, NULL, -1);
  }
  else if (strcaseeq(arg1, "BROWSER")) {
    configlogfmt(opt, NULL, LOG_BROWSER1, NULL, -1);
    configlogfmt(opt, NULL, LOG_BROWSER2, NULL, -1);
  }
  else if ((rc2 = strtoinfmt(&form, arg1, count)) != FMT_OK) {
    if (rc == -3)
      warn('C', "Ignoring corrupt format line in logfile");
    else
      badwarn(cmd, arg1, arg2, rc);
    if (rc2 == FMT_DUP)
      warn('C', "  (reason: one item occurs twice in format)");
    else if (rc2 == FMT_PARTTIME)
      warn('C', "  (reason: time without date or vice versa)");
    else if (rc2 == FMT_BADPC)
      warn('C', "  (reason: an unknown item code is present)");
    /* other rc2's could have messages but are probably rare */
    return;
  }
  else {
    if ((*logfmt) -> used) {
      fp = (Inputformatlist *)submalloc(xmemman, sizeof(Inputformatlist));
      *logfmt = fp;
      (*logfmt) -> used = FALSE;
    }
    else {
      for (fp = *logfmt; fp -> next != NULL; TO_NEXT(fp))
	;
      fp -> next = (Inputformatlist *)submalloc(xmemman,
						sizeof(Inputformatlist));
      TO_NEXT(fp);
    }
    fp -> form = form;
    for (i = 0; i < INPUT_NUMBER; i++)
      fp -> count[i] = count[i];
    fp -> next = NULL;
  }
}

void configrepord(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  extern char repcodes[];
  char *s1 = "REPORTORDER";
  char *s2 = "REPORTORDER in analhead.h";
  char *s = (rc == -1)?s2:s1;
  choice *order = (choice *)opt;
  logical used[REP_NUMBER];
  int i, j, k;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }

  for (i = 0; i < REP_NUMBER; i++)
    used[i] = 0;
  for (i = 0, k = 0; k < REP_NUMBER && arg1[i] != '\0'; i++) {
    for (j = 0; repcodes[j] != arg1[i] && repcodes[j] != '\0'; j++)
      ;
    if (repcodes[j] == '\0')
      warn('C', "Spurious character %c in %s: ignoring it", arg1[i], s);
    else if (used[j] == 0) {
      order[k++] = j;
      used[j] = 1;
    }
    else if (used[j] == 1) {
      warn('C', "Character %c used more than once in %s: ignoring later occurrences",
	   arg1[i], s);
      used[j] = 2;
    }
  }

  if (rc > 1 || arg1[i] != '\0')
    longwarn(cmd, arg1, arg2, rc);

  if (k < REP_NUMBER) {
    for (i = 0; i < REP_NUMBER && k < REP_NUMBER; i++) {
      if (used[i] == 0) {     /* k should stay < R_N automatically, but... */
	warn('C', "Character %c not used in %s: adding it at end", repcodes[i], s);
	order[k++] = i;
      }
    }
  }
  order[k] = -1;
}

void configstr(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  char **s = (char **)opt;
  size_t len;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  len = strlen(arg1);
  *s = (char *)xrealloc((void *)(*s), len + 1);
  (void)strcpy(*s, arg1);
}

#ifndef NODIRENT
#ifndef VMSDIRENT
#ifndef WIN32DIRENT  /* i.e. if POSIX dirent */
void configwildlogs(void *opt, char *arg1, char *arg2, int rc) {
  struct dirent *filep;
  struct stat buf;
  DIR *dirp;
  char *dirname, *filename, *c;
  size_t dirlen, len = 0;
  logical matched = FALSE;

  if ((c = strrchr(arg1, DIRSEP)) == NULL) {
    filename = arg1;
    dirname = (char *)xmalloc(3);
#ifdef MAC
    dirname[0] = '\0';
#else
    (void)sprintf(dirname, ".%c", DIRSEP);
#endif
  }
  else {
    filename = c + 1;
    dirname = (char *)xmalloc((size_t)(c - arg1) + 2);
    (void)memcpy((void *)dirname, (void *)arg1, (size_t)(c - arg1) + 1);
    dirname[(c - arg1) + 1] = '\0';
  }

  if ((dirp = opendir(dirname)) == NULL) {
    if (strchr(dirname, '*') != NULL || strchr(dirname, '?') != NULL)
      warn('F', "Cannot open directory %s: ignoring logfiles %s\n"
	   "(wildcards not allowed in directory name)", dirname, arg1);
    else
      warn('F', "Cannot open directory %s: ignoring logfiles %s", dirname,
	   arg1);
    return;
  }

  dirlen = strlen(dirname);
  while ((filep = readdir(dirp)) != NULL) {
    if (wildmatch(filep -> d_name, filename)) {
      if (strlen(filep -> d_name) > len) {
	len = strlen(filep -> d_name);  /* d_namlen is not portable */
	dirname = (char *)xrealloc((void *)dirname, dirlen + len + 1);
      }
      (void)memcpy((void *)(dirname + dirlen), (void *)(filep -> d_name),
		   len + 1);
      (void)stat(dirname, &buf);  /* dirname now contains complete filename */
      if (S_ISREG(buf.st_mode)) {
	configlogfile(opt, "LOGFILE", dirname, arg2, rc);
	matched = TRUE;
      }
    }
  }
  (void)closedir(dirp);
  if (!matched)
    warn('F', "Cannot find logfile %s: ignoring it", arg1);
  free((void *)dirname);
}

#else    /* WIN32DIRENT */
void configwildlogs(void *opt, char *arg1, char *arg2, int rc) {
  struct _stat buf;
  char *dirname, *c;
  struct _finddata_t file;
  long code;
  int rc2;
  size_t dirlen, len = 0;
  logical matched = FALSE;

  if ((code = _findfirst(arg1, &file)) != (long)(-1)) {
    if ((c = strrchr(arg1, DIRSEP)) == NULL) {
      dirname = (char *)xmalloc(1);
      dirname[0] = '\0';
    }
    else {
      dirname = (char *)xmalloc((size_t)(c - arg1) + 2);
      (void)memcpy((void *)dirname, (void *)arg1, (size_t)(c - arg1) + 1);
      dirname[(c - arg1) + 1] = '\0';
    }
    dirlen = strlen(dirname);
    for (rc2 = 0; rc2 == 0; rc2 = _findnext(code, &file)) {
      if (strlen(file.name) > len) {
	len = strlen(file.name);
	dirname = (char *)xrealloc((void *)dirname, dirlen + len + 1);
      }
      (void)memcpy((void *)(dirname + dirlen), (void *)(file.name),
		   len + 1);
      (void)_stat(dirname, &buf);  /* dirname now contains complete filename */
      if (_S_IFREG & buf.st_mode) {  /* bitwise & */
	configlogfile(opt, "LOGFILE", dirname, arg2, rc);
	matched = TRUE;
      }
    }
    _findclose(code);
    free((void *)dirname);
  }
  if (!matched)
    warn('F', "Cannot find logfile %s: ignoring it", arg1);
}
#endif
#else    /* VMSDIRENT */
/* This function is due to Dave Jones */
void configwildlogs(void *opt, char *arg1, char *arg2, int rc) {
  static char fspec[VMS_FSPEC_MAX], related[VMS_FSPEC_MAX];
  static char result[VMS_FSPEC_MAX];
  static $DESCRIPTOR(fspec_dx,fspec);
  static $DESCRIPTOR(related_dx,"");
  static $DESCRIPTOR(default_dx,".log");
  static $DESCRIPTOR(result_dx,result);
  char *space, *ques;
  long int context;
  int status, stsval, length, LIB$FIND_FILE(), LIB$FIND_FILE_END();
  logical matched;
  
  length = strlen (arg1);
  if ( length >= VMS_FSPEC_MAX ) length = VMS_FSPEC_MAX - 1;
  strncpy ( fspec, arg1, length ); fspec[length] = '\0';
  while ( ques = strchr(fspec,'?') ) *ques = '%';
  fspec_dx.dsc$w_length = length;
  for ( matched = FALSE, context = 0; 
	1&(status=LIB$FIND_FILE ( &fspec_dx, &result_dx, &context, &default_dx,
				  &related_dx, &stsval, (long *) 0 )); 
	matched = TRUE) {
    space = strchr ( result, ' ' );
    if ( !space ) space = &result[VMS_FSPEC_MAX-1];
    *space = '\0';
    configlogfile ( opt, "LOGFILE", result, arg2, rc );
    /* Save last result to use as default for next lookup */
    (void)strcpy ( related, result );
    related_dx.dsc$w_length = strlen(result);
    related_dx.dsc$a_pointer = related;
  }
  if ( context ) LIB$FIND_FILE_END ( &context );
  if (!matched)
    warn('F', "Cannot find logfile %s: ignoring it", arg1);
}
#endif
#endif

void configlogfile(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  extern Inputformatlist *logformat;
  extern logical newloglist;
  extern int tz;

  Filelist **logfile = (Filelist **)opt;
  Filelist *lf;
  char *s, *t;
  int i;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 2)
    longwarn(cmd, arg1, arg2, rc);

  if (strchr(arg1, ',') != NULL) {
    s = (char *)xmalloc(strlen(arg1) + 1);
    (void)strcpy(s, arg1);  /* can't strtok arg1 directly in case it's const */
    if ((t = strtok(s, ",")) == NULL) {
      badwarn(cmd, arg1, arg2, rc);
      free((void *)s);
      return;
    }
    for ( ; t != NULL; t = strtok((char *)NULL, ","))
      configlogfile(opt, "LOGFILE", t, arg2, rc);
    free((void *)s);
    return;
  }
#ifndef NODIRENT
  else if (strchr(arg1, '*') || strchr(arg1, '?')) {
    configwildlogs(opt, arg1, arg2, rc);
    return;
  }
#endif
  else if (strcaseeq(arg1, "NONE")) {
    configlogfmt((void *)&logformat, "LOGFORMAT", "DEFAULT", NULL, -1);
    *logfile = NULL;
    return;
  }
  else if (*logfile == NULL || newloglist == TRUE) {
    *logfile = (Filelist *)xmalloc(sizeof(Filelist));
    lf = *logfile;
    newloglist = FALSE;
  }
  else {
    for (lf = *logfile; lf -> next != NULL; TO_NEXT(lf))
      ;
    lf -> next = (Filelist *)xmalloc(sizeof(Filelist));
    TO_NEXT(lf);
  }
  DEFAULTSTR(lf -> name, arg1);
  lf -> format = logformat;
  lf -> from = LAST_TIME;
  lf -> to = FIRST_TIME;
  for (i = 0; i < LOGDATA_NUMBER; i++)
    lf -> data[i] = 0;
  lf -> bytes = 0;
  lf -> bytes7 = 0;
  lf -> tz = tz;
  if (rc >= 2) {
    DEFAULTSTR(lf -> prefix, arg2);
    lf -> prefixlen = strlen(lf -> prefix);
    if (strstr(arg2, "%v") == NULL)
      lf -> pvpos = UNSET;
    else
      lf -> pvpos = strstr(arg2, "%v") - arg2;
  }
  else
    lf -> prefix = NULL;
  lf -> ispipe = FALSE;
  lf -> next = NULL;
  logformat -> used = TRUE;
}

void configcachefile(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  /* a wrapper to configlogfile(), but we have to catch a few cases first */
  Filelist **cachefile = (Filelist **)opt;
  extern Inputformatlist *logformat;
  extern logical newloglist;
  logical lfu, nll;

  if (rc > 1) {
    longwarn(cmd, arg1, arg2, rc);
    rc = 1;
  }
  if (strcaseeq(arg1, "NONE")) {
    *cachefile = NULL;
    return;
  }
  lfu = logformat -> used;
  nll = newloglist;
  newloglist = FALSE;
  configlogfile(opt, cmd, arg1, arg2, rc);
  logformat -> used = lfu;
  newloglist = nll;
}

void configchar(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  char *c = (char *)opt;

  if (rc == 0 || IS_EMPTY_STRING(arg1)) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  if (STREQ(arg1, "none"))
    *c = '\0';
  else {
    if (arg1[1] != '\0')
      longwarn(cmd, arg1, arg2, rc);
    *c = arg1[0];
  }
}

void configfrom(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  extern time_t starttime;
  timecode_t *x = (timecode_t *)opt;
  timecode_t d;

  if (rc == 0 || IS_EMPTY_STRING(arg1)) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);

  if (parsedate(starttime, arg1, &d, TRUE) == ERR)
    badwarn(cmd, arg1, arg2, rc);
  else
    *x = d;
}

void configto(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  extern time_t starttime;
  timecode_t *x = (timecode_t *)opt;
  timecode_t d;

  if (rc == 0 || IS_EMPTY_STRING(arg1)) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);

  if (parsedate(starttime, arg1, &d, FALSE) == ERR)
    badwarn(cmd, arg1, arg2, rc);
  else
    *x = d;
}

void configgraph(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  char *g = (char *)opt;  /* see also configallgraph() below */

  if (rc == 0 || IS_EMPTY_STRING(arg1)) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1 || arg1[1] != '\0')
    longwarn(cmd, arg1, arg2, rc);
  if (arg1[0] != 'R' && arg1[0] != 'P' && arg1[0] != 'B' && arg1[0] != 'r' &&
      arg1[0] != 'p' && arg1[0] != 'b')
    badwarn(cmd, arg1, arg2, rc);
  else
    *g = arg1[0];
}

void configallgraph(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  char *g = (char *)opt;   /* same as configgraph() */
  int i;

  if (rc == 0 || IS_EMPTY_STRING(arg1)) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1 || arg1[1] != '\0')
    longwarn(cmd, arg1, arg2, rc);
  if (arg1[0] != 'R' && arg1[0] != 'P' && arg1[0] != 'B' && arg1[0] != 'r' &&
      arg1[0] != 'p' && arg1[0] != 'b')
    badwarn(cmd, arg1, arg2, rc);
  else {
    for (i = 0; i < DATEREP_NUMBER; i++)
      g[i] = arg1[0];
  }
}

void configfloor(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  /* This function parses the following formats for floor
     -100(r|p|b|d)   // top 100
     1000(r|p|b)     // at least 1000
     9.5(k|M|G|T)b   // ditto
     0.5%(r|p|B)     // at least 0.5% of total
     0.5:(r|p|B)     // at least 0.5% of largest
     970701d         // last access since
     -00-0201d       // same with a relative date
     Upper case letters for r|p|b|d are also acceptable.       */
  extern time_t starttime;
  Floor *floor = (Floor *)opt;
  char **b, *c, d;
  choice floorby;
  char qual;
  double mn;
  timecode_t t;

  if (rc == 0 || IS_EMPTY_STRING(arg1)) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);
  c = arg1 + strlen(arg1) - 1;
  d = toupper(*c);
  if (d == 'R')
    floorby = REQUESTS;
  else if (d == 'P')
    floorby = PAGES;
  else if (d == 'B')
    floorby = BYTES;
  else if (d == 'D')
    floorby = DATESORT;
  else {
    badwarn(cmd, arg1, arg2, rc);
    return;
  }
  if (floorby != DATESORT) {
    b = (char **)xmalloc(sizeof(char *));
    mn = strtod(arg1, b);
    if (*b == arg1) {
      badwarn(cmd, arg1, arg2, rc);
      return;
    }
    else if (*b == c)
      qual = '\0';
    else if (*b == c - 1) {
      if (mn < 0) {
	badwarn(cmd, arg1, arg2, rc);
	return;
      }
      else if (**b == '%' || **b == ':' || (floorby == BYTES &&
               (**b == 'k' || **b == 'M' || **b == 'G' || **b == 'T')))
	qual = **b;
      else {
	badwarn(cmd, arg1, arg2, rc);
	return;
      }
    }
    free((void *)b);
  }
  else { /* floorby == DATESORT */
    qual = '\0';
    if (arg1[0] == '-' && arg1[1] != '0' && isdigit(arg1[1]))
      mn = atof(arg1);
    else if (parsedate(starttime, arg1, &t, TRUE) == ERR) {
      badwarn(cmd, arg1, arg2, rc);
      return;
    }
    else
      mn = (double)t;
  }
  floor -> min = mn;
  floor -> qual = qual;
  floor -> floorby = floorby;
}

void configtree(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  Tree **treex = (Tree **)opt;
  Hashindex item;
  Hashentry own;
  char *name, *nameend, *t;
  int i;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);

  if (strchr(arg1, ',') != NULL) {
    if ((t = strtok(arg1, ",")) == NULL) {
      badwarn(cmd, arg1, arg2, rc);
      return;
    }
    for ( ; t != NULL; t = strtok((char *)NULL, ","))
      configtree(opt, cmd, t, NULL, -1);
    return;
  }
  for (i = 0; i < DATA_NUMBER; i++)
    own.data[i] = 0;    /* set up dummy item */
  own.bytes = 0;
  item.own = &own;
  item.name = arg1;
  name = NULL;
  (*treex) -> cutfn(&name, &nameend, item.name, TRUE);
  (void)treefind(name, nameend, &((*treex) -> tree), &item, (*treex) -> cutfn,
		 TRUE, TRUE, (*treex) -> space);
}

void configulong(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  unsigned int *x = (unsigned int *)opt;
  char **c;

  if (rc == 0 || IS_EMPTY_STRING(arg1)) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (!isdigit(arg1[0])) {
    badwarn(cmd, arg1, arg2, rc);
    return;
  }
  c = (char **)xmalloc(sizeof(char *));
  *x = strtoul(arg1, c, 10);
  if (rc > 1 || **c != '\0')
    longwarn(cmd, arg1, arg2, rc);
  free((void *)c);
}

void configuint(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  unsigned int *x = (unsigned int *)opt;
  char **c;

  if (rc == 0 || IS_EMPTY_STRING(arg1)) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (!isdigit(arg1[0])) {
    badwarn(cmd, arg1, arg2, rc);
    return;
  }
  c = (char **)xmalloc(sizeof(char *));
  *x = (unsigned int)strtoul(arg1, c, 10);
  if (rc > 1 || **c != '\0')
    longwarn(cmd, arg1, arg2, rc);
  free((void *)c);
}

void configoffset(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  /* configint with extra checks */
  int *x = (int *)opt;
  char **c;
  int y;

  if (rc == 0 || IS_EMPTY_STRING(arg1)) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (arg1[0] == '+') {
    if (!isdigit(arg1[1])) {
      badwarn(cmd, arg1, arg2, rc);
      return;
    }
    arg1++;
  }
  else if (!isdigit(arg1[0]) && !(arg1[0] == '-' && isdigit(arg1[1]))) {
    badwarn(cmd, arg1, arg2, rc);
    return;
  }
  c = (char **)xmalloc(sizeof(char *));
  y = (int)strtol(arg1, c, 10);
  if (rc > 1 || **c != '\0')
    longwarn(cmd, arg1, arg2, rc);
  if (y > 40320 || y < -40320)
    warn('C', "Ignoring offset of more than 28 days in configuration command\n%s %s", cmd, arg1);
  else {
    *x = y;
    if (*x % 30 != 0)
      warn('D', "Offset not a multiple of 30 in configuration command\n%s %s",
	   cmd, arg1);
    else if (*x > 1500 || *x < -1500)
      warn('D', "Offset more than 25 hours in configuration command\n%s %s",
	   cmd, arg1);
  }
  free((void *)c);
}

void configlowmem(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  choice *x = (choice *)opt;

  if (rc == 0 || IS_EMPTY_STRING(arg1)) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (!(arg1[0] >= '0' && arg1[0] <= '3')) {
    badwarn(cmd, arg1, arg2, rc);
    return;
  }
  if (rc > 1 || arg1[1] != '\0')
    longwarn(cmd, arg1, arg2, rc);
  *x = (choice)(arg1[0] - '0');
}

void configalias(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  Alias **alias = (Alias **)opt;
  Alias *ap, *nextap;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc == 1) {
    if (strcaseeq(arg1, "none")) {
      for (ap = *alias; ap != NULL; ap = nextap) {
	nextap = ap -> next;
	free((void *)(ap -> from));
	free((void *)(ap -> to));
	free((void *)ap);  /* all have been mallocked here or in configstr() */
      }
      *alias = NULL;
    }
    else
      shortwarn(cmd, arg1, rc);
    return;
  }
  if (chrn(arg1, '*') >= 2 && strchr(arg2, '*') != NULL) {
    badwarn(cmd, arg1, arg2, rc);
    return;
  }
  if (rc > 2)
    longwarn(cmd, arg1, arg2, rc);

  if (*alias == NULL) {
    *alias = (Alias *)xmalloc(sizeof(Alias));
    DEFAULTSTR((*alias) -> from, arg1);
    DEFAULTSTR((*alias) -> to, arg2);
    (*alias) -> next = NULL;
  }
  else {
    for (ap = *alias; ap -> next != NULL; TO_NEXT(ap))
      ;  /* find end of list */
    ap -> next = (Alias *)xmalloc(sizeof(Alias));
    TO_NEXT(ap);
    DEFAULTSTR(ap -> from, arg1);
    DEFAULTSTR(ap -> to, arg2);
    ap -> next = NULL;
  }
}

void configaliaslist(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  char *t;

  if ((t = strtok(arg1, ",")) == NULL) {
    badwarn(cmd, arg1, arg2, rc);
    return;
  }
  for ( ; t != NULL; t = strtok((char *)NULL, ","))
    configalias(opt, cmd, t, arg2, rc);
  return;
}

void configinex(void *opt, char *cmd, char *arg1, char *arg2, int rc,
		logical in) {
  Include **include = (Include **)opt;
  Include *ip;
  char *t;

  if (rc == 0) {
    shortwarn(cmd, arg1, rc);
    return;
  }
  if (rc > 1)
    longwarn(cmd, arg1, arg2, rc);

  if (strchr(arg1, ',') != NULL) {
    if ((t = strtok(arg1, ",")) == NULL) {
      badwarn(cmd, arg1, arg2, rc);
      return;
    }
    for ( ; t != NULL; t = strtok((char *)NULL, ","))
      configinex(opt, cmd, t, NULL, -1, in);
    return;
  }
  else if (*include == NULL) {
    *include = (Include *)xmalloc(sizeof(Include));
    DEFAULTSTR((*include) -> name, arg1);
    if (strcaseeq((*include) -> name, "pages"))
      (void)strcpy((*include) -> name, "pages");
    (*include) -> in = in;
    (*include) -> next = NULL;
  }
  else {
    for (ip = *include; ip -> next != NULL; TO_NEXT(ip))
      ;  /* find end of list */
    ip -> next = (Include *)xmalloc(sizeof(Include));
    TO_NEXT(ip);
    DEFAULTSTR(ip -> name, arg1);
    if (strcaseeq(ip -> name, "pages"))
      (void)strcpy(ip -> name, "pages");
    ip -> in = in;
    ip -> next = NULL;
  }
}

void configinc(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  configinex(opt, cmd, arg1, arg2, rc, TRUE);
}

void configexc(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  configinex(opt, cmd, arg1, arg2, rc, FALSE);
}

/* same, omitting initial dot */
void configincd(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  if (arg1 != NULL && arg1[0] == '.')
    configinex(opt, cmd, arg1 + 1, arg2, rc, TRUE);
  else
    configinex(opt, cmd, arg1, arg2, rc, TRUE);
}

void configexcd(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  if (arg1 != NULL && arg1[0] == '.')
    configinex(opt, cmd, arg1 + 1, arg2, rc, FALSE);
  else
    configinex(opt, cmd, arg1, arg2, rc, FALSE);
}

/* same, omitting trailing slash */
void configincs(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  if (arg1 != NULL && !IS_EMPTY_STRING(arg1) && arg1[strlen(arg1) - 1] == '/')
    arg1[strlen(arg1) - 1] = '\0';
  configinex(opt, cmd, arg1, arg2, rc, TRUE);
}

void configexcs(void *opt, char *cmd, char *arg1, char *arg2, int rc) {
  if (arg1 != NULL && !IS_EMPTY_STRING(arg1) && arg1[strlen(arg1) - 1] == '/')
    arg1[strlen(arg1) - 1] = '\0';
  configinex(opt, cmd, arg1, arg2, rc, FALSE);
}

/*** Now we move on to the command line argument processing. ***/

void clconfline(Options *op, char *s) {
  char *cmd = NULL, *arg1 = NULL, *arg2 = NULL;
  int rc;

  if ((rc = parseconfline(s, &cmd, &arg1, &arg2)) != -1)
    confline(op, cmd, arg1, arg2, rc);
}

void clgenrep(Options *op, choice rep, char *arg) {
  size_t len;
  char c, *d;

  op -> outopts.repq[rep] = (arg[0] == '+')?TRUE:FALSE;
  if (arg[0] == '-') {
    if (arg[2] != '\0')
      CLLONGWARN(arg);
  }
  else if (arg[2] != '\0') {   /* parse sort method */
    rep = G(rep);   /* future args are genargs only */
    if (!isalpha(arg[2]))
      d = arg + 2;
    else {
      d = arg + 3;
      c = tolower(arg[2]);
      if (c == 'r')
	op -> outopts.sortby[rep] = REQUESTS;
      else if (c == 'p')
	op -> outopts.sortby[rep] = PAGES;
      else if (c == 'b')
	op -> outopts.sortby[rep] = BYTES;
      else if (c == 'a')
	op -> outopts.sortby[rep] = ALPHABETICAL;
      else if (c == 'd')
	op -> outopts.sortby[rep] = DATESORT;
      else if (c == 'x')
	op -> outopts.sortby[rep] = RANDOM;
      else {
	warn('C', "Unknown sort method in command line option %s", arg);
	return;
      }
    }
    if (*d != '\0') {   /* parse floor */
      len = strlen(d);
      c = tolower(*(d + len - 1));   /* final character */
      if (c != 'r' && c != 'p' && c != 'b' && c != 'd') {
	if (d == arg + 2) {
	  warn('C', "No sort method or floor given in command line option %s",
	       arg);
	  return;
	}     /* else deduce floor method */
	c = arg[2];
	(void)memmove((void *)(arg + 2), (void *)(arg + 3), len + 1);
	if (c == 'a' || c == 'x')
	  *(d + len - 1) = 'r';
	else
	  *(d + len - 1) = c;
	configfloor((void *)&(op -> outopts.floor[rep]), arg, arg + 2, NULL,
		    -2);
      }
      else
	configfloor((void *)&(op -> outopts.floor[rep]), arg, d, NULL, -2);
    }
  }
}

void cldebug(char **s, char *arg) {
  if (arg[0] == '-') {
    if (arg[2] != '\0')
      CLLONGWARN(arg);
    configdebug(s, arg, "FALSE", NULL, -2);
  }
  else if (arg[2] == '\0')
    configdebug(s, arg, "TRUE", NULL, -2);
  else
    configdebug(s, arg, arg + 2, NULL, -2);
}

void clargs(Options *op, int argc, char *argv[]) {
  extern char repcodes[];
  extern logical vblesonly;
  extern char *debug_args, *warn_args;
  choice i, j;

  for (i = 1; i < argc; i++) {
    if (strlen(argv[i]) > 255)
      warn('C', "Ignoring long command line argument\n%s", argv[i]);
    else if (!IS_EMPTY_STRING(argv[i])) {
      if (argv[i][0] != '+' && argv[i][0] != '-')
	configlogfile((void *)&(op -> miscopts.logfile), argv[i], argv[i],
		      NULL, -2);
      else switch (argv[i][1]) {
      case '\0':
	configlogfile((void *)&(op -> miscopts.logfile), argv[i], "stdin",
		      NULL, -2);
	break;
      case '4':
      case '5':
      case 'd':
      case 'D':
      case 'H':
      case 'm':
      case 'W':
      case 'x':
      case 'z':
	for (j = 0; repcodes[j] != argv[i][1]; j++)
	  ;
	CLREPTOGGLE(j);
	break;
      case 'h':
	if (STREQ(argv[i] + 2, "elp")) {
	  (void)fputs("For help see Readme.html, or http://", stderr);
	  (void)fputs("www.statslab.cam.ac.uk/~sret1/analog/\n", stderr);
	  my_exit(OK);
	}
	else
	  CLREPTOGGLE(REP_HOURSUM);
	break;
      case 'b':
      case 'B':
      case 'c':
      case 'E':
      case 'i':
      case 'I':
      case 'J':
      case 'k':
      case 'K':
      case 'o':
      case 'r':
      case 'S':
      case 't':
      case 'u':
      case 'v':
	for (j = 0; repcodes[j] != argv[i][1]; j++)
	  ;
	clgenrep(op, j, argv[i]);
	break;
      case 'f':
	if (STREQ(argv[i] + 2, "orm")) {
	  CLTOGGLE(op -> miscopts.form);
	}
	else
	  clgenrep(op, REP_REF, argv[i]);
	break;
      case 's':
	if (STREQ(argv[i] + 2, "ettings"))
	  vblesonly = TRUE;
	else
	  clgenrep(op, REP_REFSITE, argv[i]);
	break;
      case 'a':
	CLOUTSTYLE(op -> outopts.outstyle);
	break;
      case 'A':
	configall((void *)(op -> outopts.repq), argv[i],
		  (argv[i][0] == '+')?"ON":"OFF", NULL, -2);
	break;
      case 'C':
	CLSHORTCHECK(clconfline(op, argv[i] + 2));
	break;
      case 'F':
	if (argv[i][0] == '-') {
	  CLLONGCHECK(op -> dman.fromstr = NULL);
	}
	else
	  CLSHORTCHECK(confline(op, "FROM", argv[i] + 2, NULL, -2));
	break;
      case 'g':
	CLSHORTCHECK((void)config(argv[i] + 2, op));
	break;
      case 'G':  /* mandatory config file: already dealt with */
	break;
      case 'O':
	CLSHORTCHECK(configstr((void *)&(op -> outopts.outfile), NULL,
			       argv[i] + 2, NULL, -1));
	break;
      case 'q':
	cldebug(&warn_args, argv[i]);
	break;
      case 'T':
	if (argv[i][0] == '-') {
	  CLLONGCHECK(op -> dman.tostr = NULL);
	}
	else
	CLSHORTCHECK(confline(op, "TO", argv[i] + 2, NULL, -2));
	break;
      case 'U':
	CLSHORTCHECK(confline(op, "CACHEFILE", argv[i] + 2, NULL, -2));
	break;	
      case 'V':
	cldebug(&debug_args, argv[i]);
	break;
      case 'X':
	CLTOGGLE(op -> outopts.gotoq);
	break;
      default:
	warn('C', "Ignoring unknown command line argument %s", argv[i]);
	break;
      }
    }
  }
}
