/*** analog 3.11      http://www.statslab.cam.ac.uk/~sret1/analog/  ***/

/*** output.c; controls the output ***/

#include "analhea2.h"

void output(Outchoices *od, Hashindex **gooditems, Hashindex **baditems,
	    Dateman *dman, Sizedata *sizes, unsigned long *sumdata,
	    double totbytes, double totbytes7, unsigned int granularity) {
  extern choice *rep2type, *rep2reqs, *rep2date;
  extern unsigned int *rep2gran, *rep2lng, *rep2datefmt, *rep2colhead;
  extern unsigned int *rep2busystr;

  FILE *outf;
  Include *linkhead;
  char *baseurl;
  int ro;
  choice rep;

  /* first open output file */
  
  if (STREQ(od -> outfile, "stdout") || STREQ(od -> outfile, "-")) {
    outf = stdout;
    debug('F', "Opening stdout as output file");
  }
  else if ((outf = fopen(od -> outfile, "w")) == NULL)
    error("failed to open output file %s for writing", od -> outfile);
  else
    debug('F', "Opening %s as output file", od -> outfile);

  /* remove any reports not wanted */

  checkreps(od -> repq, dman, od -> alltrees, gooditems, sizes);

  /* page header */

  pagetop(outf, od, dman);
    
  /* Now the main reports */

  for (ro = 0; od -> reporder[ro] != -1; ro++) {
    rep = od -> reporder[ro];

    if (od -> repq[rep]) {
      report_title(outf, od -> lngstr[rep2lng[rep]], rep, od -> gotoq,
		   od -> repq, od -> lngstr, od -> reporder, od -> outstyle);
      switch(rep) {
      case (REP_GENSUM):
	gensum(outf, od -> outstyle, od -> last7, sumdata, totbytes, totbytes7,
	       gooditems, baditems, dman, od -> rawbytes, od -> sepchar,
	       od -> compsep, od -> monthname, od -> dayname,
	       od -> plainmonthlen, od -> plaindaylen, od -> lngstr);
	break;
      case (REP_DAYREP):
      case (REP_HOURREP):
      case (REP_QUARTER):
      case (REP_FIVE):
	subdayrep(outf, rep, dman -> firstdp, dman -> lastdp,
		  dman -> firstdate, dman -> lastdate, od -> outstyle,
		  granularity, rep2gran[rep], od -> pagewidth,
		  od -> mingraphwidth, od -> back[rep], od -> rawbytes,
		  od -> cols[rep], od -> rows[rep], od -> graph[rep],
		  od -> markchar, od -> sepchar, od -> repsepchar, od -> decpt,
		  od -> compsep, od -> weekbeginson, od -> imagedir,
		  od -> html, od -> monthname, od -> dayname, od -> monthlen,
		  od -> daylen, od -> plainmonthlen, od -> plaindaylen,
		  od -> lngstr, od -> lngstr[rep2datefmt[rep]],
		  od -> lngstr[rep2colhead[rep]],
		  od -> lngstr[rep2busystr[rep]]);
	break;
      case (REP_WEEK):
      case (REP_MONTH):
	superdayrep(outf, rep, dman -> firstdp, dman -> lastdp,
		    dman -> firstdate, dman -> lastdate, od -> outstyle,
		    granularity, od -> pagewidth, od -> mingraphwidth,
		    od -> back[rep], od -> rawbytes, od -> cols[rep],
		    od -> rows[rep], od -> graph[rep], od -> markchar,
		    od -> sepchar, od -> repsepchar, od -> decpt,
		    od -> compsep, od -> weekbeginson, od -> imagedir,
		    od -> html, od -> monthname, od -> monthlen,
		    od -> plainmonthlen, od -> lngstr,
		    od -> lngstr[rep2datefmt[rep]],
		    od -> lngstr[rep2colhead[rep]],
		    od -> lngstr[rep2busystr[rep]]);
	break;
      case (REP_DAYSUM):
	daysum(outf, dman -> firstdp, dman -> firstdate, dman -> lastdate,
	       od -> outstyle, granularity, od -> weekbeginson,
	       od -> pagewidth, od -> mingraphwidth, od -> rawbytes,
	       od -> cols[rep], od -> graph[rep], od -> markchar,
	       od -> sepchar, od -> repsepchar, od -> decpt, od -> compsep,
	       od -> imagedir, od -> html, od -> lngstr[rep2colhead[rep]],
	       od -> dayname, od -> daylen, od -> lngstr);
	break;
      case (REP_HOURSUM):
	hoursum(outf, dman -> firstdp, dman -> lastdp, od -> outstyle,
		granularity, od -> pagewidth, od -> mingraphwidth,
		od -> rawbytes, od -> cols[rep], od -> graph[rep],
		od -> markchar, od -> sepchar, od -> repsepchar, od -> decpt,
		od -> compsep, od -> imagedir, od -> html,
		od -> lngstr[rep2colhead[rep]], od -> lngstr);
	break;
      case (REP_HOST):
      case (REP_BROWREP):
      case (REP_VHOST):
      case (REP_USER):
      case (REP_FAILUSER):
	genrep(outf, rep, od -> outstyle, &(gooditems[rep2type[rep]]),
	       &(baditems[rep2type[rep]]), od -> aliashead[G(rep)],
	       od -> wanthead[G(rep)], rep2reqs[G(rep)], rep2date[G(rep)],
	       &(od -> floor[G(rep)]), od -> sortby[G(rep)],
	       (logical)(rep == REP_HOST || rep == REP_VHOST), od -> pagewidth,
	       od -> sepchar, od -> repsepchar, od -> decpt, od -> compsep,
	       od -> rawbytes, od -> cols[rep], od -> lngstr[rep2colhead[rep]],
	       od -> lngstr[rep2colhead[rep] + 1],
	       od -> lngstr[rep2lng[rep] + 1], od -> lngstr[rep2lng[rep] + 2],
	       od -> lngstr[rep2lng[rep] + 3][0], od -> html,
	       dman -> firsttime, od -> monthname, od -> dayname,
	       od -> monthlen, od -> daylen, od -> plainmonthlen,
	       od -> plaindaylen, od -> lngstr);
	break;
      case (REP_REQ):
      case (REP_REDIR):
      case (REP_FAIL):
      case (REP_REF):
      case (REP_REDIRREF):
      case (REP_FAILREF):
      case (REP_TYPE):
      case (REP_DIR):
      case (REP_DOM):
      case (REP_REFSITE):
      case (REP_BROWSUM):
	baseurl = NULL;
	if (rep == REP_REQ) {
	  linkhead = od -> link;
	  baseurl = od -> baseurl;
	}
	else if (rep == REP_REF || rep == REP_REDIRREF || rep == REP_FAILREF)
	  linkhead = od -> reflink;
	else
	  linkhead = NULL;
	treerep(outf, rep, od -> outstyle, od -> tree[G(rep)],
		gooditems[rep2type[rep]], baditems[rep2type[rep]],
		od -> aliashead[G(rep)], od -> wanthead[G(rep)], linkhead,
		baseurl, od -> alltrees, rep2reqs[G(rep)], rep2date[G(rep)],
		&(od -> floor[G(rep)]), od -> sortby[G(rep)],
		&(od -> subfloor[G(rep)]), od -> subsortby[G(rep)],
		od -> pagewidth, od -> sepchar,	od -> repsepchar, od -> decpt,
		od -> compsep, od -> rawbytes, od -> cols[rep],
		od -> lngstr[rep2colhead[rep]],
		od -> lngstr[rep2colhead[rep] + 1],
		od -> lngstr[rep2lng[rep] + 1], od -> lngstr[rep2lng[rep] + 2],
		od -> lngstr[rep2lng[rep] + 3][0], od -> html,
		dman -> firsttime, od -> monthname, od -> dayname,
		od -> monthlen, od -> daylen, od -> plainmonthlen,
		od -> plaindaylen, od -> lngstr);
	break;
      case (REP_SIZE):
	sizerep(outf, od -> outstyle, sizes, od -> repsepchar, od -> decpt,
		od -> compsep, od -> rawbytes, od -> cols[rep],
		od -> lngstr[rep2colhead[rep]], od -> html, od -> monthname,
		od -> dayname, od -> monthlen, od -> daylen,
		od -> plainmonthlen, od -> plaindaylen, od -> lngstr);
	break;
      case (REP_CODE):
	coderep(outf, od -> outstyle, &(od -> floor[G(rep)]),
		od -> sortby[G(rep)], od -> pagewidth, od -> sepchar,
		od -> repsepchar, od -> decpt, od -> compsep, od -> cols[rep],
		od -> lngstr[rep2colhead[rep]],
		od -> lngstr[rep2colhead[rep] + 1],
		od -> lngstr[rep2lng[rep] + 1], od -> lngstr[rep2lng[rep] + 2],
		od -> lngstr[rep2lng[rep] + 3][0], od -> html,
		dman -> firsttime, od -> monthname, od -> dayname,
		od -> monthlen, od -> daylen, od -> plainmonthlen,
		od -> plaindaylen, od -> lngstr);
	break;
      }  /* end switch rep */
      hrule(outf, od -> outstyle, od -> pagewidth);
    }    /* end if rep wanted */
  }      /* end for ro */

  /*** Bit at the bottom of the page ***/

  pagebot(outf, od);
  if (STREQ(od -> outfile, "-"))
    debug('F', "Closing stdout");
  else
    debug('F', "Closing %s", od -> outfile);
  (void)fclose(outf);
}
