/*** analog 3.11 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

/*** settings.c; report variable settings */

#include "analhea2.h"

void report_vbles(Options *op) {
  extern char *item_type[];
  extern int stz;
  extern char *debug_args, *warn_args;
  extern unsigned long progressfreq;
  int i;

  (void)printf("This is analog version %s\n", VERSION);
  (void)printf("For more information on analog see docs/Readme.html or\n");
  (void)printf("http://www.statslab.cam.ac.uk/~sret1/analog/\n\n");

  report_compile();
  report_debug("Warning", warn_args);
  report_debug("Debugging", debug_args);
  if (progressfreq == 1)
    (void)printf("Reporting progress every line\n");
  else if (progressfreq > 0)
    (void)printf("Reporting progress every %lu lines\n", progressfreq);
  report_logfiles(op -> miscopts.cachefile, TRUE);
  report_logfiles(op -> miscopts.logfile, FALSE);
  report_fromto(&(op -> dman));
  if (stz != 0)
    (void)printf("Local computer time offset by %s%d minutes\n",
		 (stz > 0)?"+":"", stz);
  for (i = 0; i < ITEM_NUMBER; i++)
    report_want(op -> wanthead[i], item_type[i], "");
  report_want(op -> ispagehead, "as pages", "");
  report_want(op -> argshead, "search arguments", "");
  report_want(op -> refargshead, "referrer search arguments", "");
  for (i = 0; i < ITEM_NUMBER; i++)
    report_alias(op -> aliashead[i], item_type[i], "");
  report_lowmem(op -> miscopts.lowmem);
#ifndef NODNS
  report_dns();
#endif
  (void)printf("Filenames are case %s\n",
	 (op -> miscopts.case_insensitive)?"insensitive":"sensitive");
  if (op -> miscopts.dirsuffix[0] == '\0')
    (void)printf("No DIRSUFFIX\n");
  else
    (void)printf("DIRSUFFIX %s\n", op -> miscopts.dirsuffix);
  report_outopts(&(op -> outopts));
}

void report_compile(void) {
  (void)printf("Compile-time optional code:\n");
#ifdef NOPIPES
  (void)printf("  No pipes\n");
#else
  (void)printf("  Pipes included\n");
#endif
#ifdef NODNS
  (void)printf("  No DNS lookups\n");
#else
  (void)printf("  DNS lookups included\n");
#endif
#ifdef NODIRENT
  (void)printf("  No dirent\n");
#else
#ifdef MACDIRENT
  (void)printf("  Mac dirent included\n");
#else
#ifdef VMSDIRENT
  (void)printf("  VMS dirent included\n");
#else
#ifdef WIN32DIRENT
  (void)printf("  Win32 dirent included\n");
#else
  (void)printf("  POSIX dirent included\n");
#endif
#endif
#endif
#endif
  (void)printf("Compile-time variables:\n");
  (void)printf("  Default configuration file: %s\n", DEFAULTCONFIGFILE);
  if (!strcaseeq(DEFAULTCONFIGFILE, "none"))
    check_file(DEFAULTCONFIGFILE);
  (void)printf("  Mandatory configuration file: %s\n", MANDATORYCONFIGFILE);
  if (!strcaseeq(MANDATORYCONFIGFILE, "none"))
    check_file(MANDATORYCONFIGFILE);
}

void report_debug(char *type, char *arg) {
  (void)printf("%s types on: ", type);
  if (IS_EMPTY_STRING(arg))
    (void)printf("none\n");
  else if (STREQ(arg, "CDFLMRSU"))  /* see configdebug() in init2.c */
    (void)printf("all\n");
  else
    (void)printf("%s\n", arg);  /* could still have spurious ones, but... */
}

void report_logfiles(Filelist *logfile, logical cache) {
  Filelist *lf;

  (void)printf("Reading %sfiles:\n", cache?"cache ":"log");
  if (logfile == NULL)
    (void)printf("  none\n");
  for (lf = logfile; lf != NULL; TO_NEXT(lf)) {
    (void)printf("  %s\n", lf -> name);
    check_file(lf -> name);
    if (!cache) {
      report_logformat(stdout, lf -> format, FALSE);
      if (lf -> tz != 0)
	(void)printf("    Times in logfile offset by %s%d minutes\n",
		     (lf -> tz > 0)?"+":"", lf -> tz);
    }
  }
}

void report_logformat(FILE *outf, Inputformatlist *format, logical inwarn) {
  Inputformatlist *fp;
  Inputformat *p;

  if (inwarn)
    (void)fprintf(outf, "    Current logfile format:\n");
  else
    (void)fprintf(outf, "    Logfile format:\n");
  for (fp = format; fp != NULL; TO_NEXT(fp)) {
    (void)fprintf(outf, "      ");
    for (p = fp -> form; p -> inpfns != NULL; TO_NEXT(p)) {
      if (p -> inpfns -> code == 'x') {
	if (p -> sep == '0' || p -> sep == '1')
	  (void)fprintf(outf, "<Automatic detection>");
	else if (p -> sep == '2')
	  (void)fprintf(outf, "<WebSTAR format string>");
	else if (p -> sep == '3')
	  (void)fprintf(outf, "<W3 extended format string>");
	else if (p -> sep == '4')
	  (void)fprintf(outf, "<Netscape format string>");
      }
      else if (p -> inpfns -> code == '\n')
	(void)fprintf(outf, "\\n");
      else if (p -> inpfns -> code != '\0')
	(void)fprintf(outf, "%%%c", p -> inpfns -> code);
      if (p -> inpfns -> code == 'r' || p -> inpfns -> code == 'R' ||
	  p -> inpfns -> code == 'u' || p -> inpfns -> code == 'f' ||
	  p -> inpfns -> code == 'B' || p -> inpfns -> code == 'S' ||
	  p -> inpfns -> code == 'F' || p -> inpfns -> code == 'q' ||
	  p -> inpfns -> code == 'C' || p -> inpfns -> code == 'j' ||
	  p -> inpfns -> code == 'v' || p -> inpfns -> code == '\0') {
	if (p -> sep == '\t')
	  (void)fprintf(outf, "\\t");
	else if (p -> sep == '\n')
	  (void)fprintf(outf, "\\n");
	else if (p -> sep == '\\')
	  (void)fprintf(outf, "\\\\");
	else
	  (void)putc(p -> sep, outf);
      }
    }
    (void)putc('\n', outf);
  }
}

void report_fromto(Dateman *dman) {
  extern char *engmonths[];

  unsigned int date, month, year;
  if (dman -> from == FIRST_TIME && dman -> to == LAST_TIME)
    (void)printf("Analysing all dates\n");
  else {
    (void)printf("Analysing dates");
    if (dman -> from != FIRST_TIME) {
      code2date(dman -> from / 1440, &date, &month, &year);
      (void)printf(" from %02d/%s/%d at %02d:%02d", date, engmonths[month],
		   year, (int)((dman -> from % 1440) / 60),
		   (int)(dman -> from % 60));
    }
    if (dman -> to != LAST_TIME) {
      code2date(dman -> to / 1440, &date, &month, &year);
      (void)printf(" to %02d/%s/%d at %02d:%02d", date, engmonths[month], year,
	     (int)((dman -> to % 1440) / 60), (int)(dman -> to % 60));
    }
    (void)putchar('\n');
  }
}

void report_want(Include *wanthead, char *type, char *indent) {
  Include *wp;

  if (wanthead != NULL) {
    (void)printf("%sIncluding (+) and excluding (-) the following %s:\n",
		 indent, type);
    (void)printf("%s  All %scluded, then\n", indent,
		 (wanthead -> in)?"ex":"in");
    for (wp = wanthead; wp != NULL; TO_NEXT(wp))
      (void)printf("%s  %c %s\n", indent, (wp -> in)?'+':'-', wp -> name);
  }
}

void report_alias(Alias *aliashead, char *type, char *indent) {
  Alias *ap;

  if (aliashead != NULL) {
    (void)printf("%sAliasing %s as follows:\n", indent, type);
    for (ap = aliashead; ap != NULL; TO_NEXT(ap))
      (void)printf("%s  %s -> %s\n", indent, ap -> from, ap -> to);
  }
}

void report_lowmem(choice lowmem[ITEM_NUMBER]) {
  extern char *item_type[];
  int i, j = 0;

  for (i = 0; i < ITEM_NUMBER; i++)
    j += (int)(lowmem[i]);
  if (j == 0)
    (void)printf("No LOWMEM commands in operation\n");
  else {
    (void)printf("LOWMEM settings are:\n");
    for (i = 0; i < ITEM_NUMBER; i++)
      (void)printf("  %s: %d\n", item_type[i], lowmem[i]);
  }
}

#ifndef NODNS
void report_dns(void) {
  extern choice dnslevel;
  extern char *dnsfile;

  (void)printf("DNS level is ");
  if (dnslevel == DNS_NONE)
    (void)printf("NONE\n");
  else if (dnslevel == DNS_READ)
    (void)printf("READ\n");
  else if (dnslevel == DNS_LOOKUP)
    (void)printf("LOOKUP\n");
  else
    (void)printf("WRITE\n");
  if (dnslevel != DNS_NONE)
    (void)printf("DNS file is %s\n", dnsfile);
}
#endif

void report_outopts(Outchoices *od) {
  extern char *repname[];
  extern char *engdays[];

  int i;
  choice j;

  (void)printf("Report order is as follows:\n");
  for (i = 0; od -> reporder[i] != -1; i++) {
    j = od -> reporder[i];
    (void)printf("  %s [%s]\n", repname[j], (od -> repq[j])?"ON":"OFF");
    if (od -> repq[j]) {
      if (j < DATEREP_NUMBER)
	report_daterep(od, j);
      else if (j == REP_GENSUM)
	;   /* do nothing */
      else if (j <= LAST_NORMALREP)
	report_genrep(od, j);
      /* nothing for REP_SIZE or REP_CODE either */
    }
  }

  if (od -> outstyle <= COMPUTER)
    (void)printf("Output file is %s\n",
		 STREQ(od -> outfile, "-")?"stdout":(od -> outfile));
  if (STREQ(od -> cacheoutfile, "none"))
    (void)printf("No cache output file\n");
  else
    (void)printf("Cache output file is %s\n",
		 STREQ(od -> cacheoutfile, "-")?"stdout":(od -> cacheoutfile));
  /* Don't check writeability because would overwrite */
  (void)printf("Language file is %s\n", od -> lang.file);
  check_file(od -> lang.file);
  (void)printf("Output style is ");
  if (od -> outstyle == HTML)
    (void)printf("HTML");
  else if (od -> outstyle == ASCII)
    (void)printf("ASCII");
  else if (od -> outstyle == COMPUTER) {
    (void)printf("COMPUTER\n");
    (void)printf("The field separator is \"%s\"", od -> compsep);
  }
  else
    (void)printf("NONE");
  (void)putchar('\n');
  (void)printf("Domains file is %s\n", od -> domainsfile);
  check_file(od -> domainsfile);
  if (STREQ(od -> headerfile, "none"))
    (void)printf("No header file\n");
  else {
    (void)printf("Header file is %s\n", od -> headerfile);
    check_file(od -> headerfile);
  }
  if (STREQ(od -> footerfile, "none"))
    (void)printf("No footer file\n");
  else {
    (void)printf("Footer file is %s\n", od -> footerfile);
    check_file(od -> footerfile);
  }
  (void)printf("Host name for title is %s\n", od -> hostname);
  if (od -> outstyle == HTML) {
    if (STREQ(od -> hosturl, "none"))
      (void)printf("Host name unlinked\n");
    else
      (void)printf("Host name linked to %s\n", od -> hosturl);
    if (STREQ(od -> logo, "none"))
      (void)printf("No logo for title line\n");
    else
      (void)printf("Logo for title line is %s\n", od -> logo);
    (void)printf("Image directory is %s\n", od -> imagedir);
  }
  else if (od -> outstyle == COMPUTER) {
    if (STREQ(od -> hosturl, "none"))
      (void)printf("No host URL\n");
    else
      (void)printf("Host URL is %s\n", od -> hosturl);
  }
  (void)printf("Displaying %s bytes\n",
	       (od -> rawbytes)?"exact":"abbreviated");
  if (od -> outstyle != COMPUTER) {
    (void)printf("The character for graph plotting is: %c\n", od -> markchar);
    report_sep(od -> sepchar, "thousands separator");
    report_sep(od -> repsepchar, "thousands separator in tables");
    report_sep(od -> decpt, "decimal point");
  (void)printf("The pagewidth is %d\n", od -> pagewidth);
  (void)printf("The minimum graph width is %d\n", od -> mingraphwidth);
  }
  (void)printf("Weeks begin on %s\n", engdays[od -> weekbeginson]);
}

void report_sep(char c, char *type) {
  if (c == ' ')
    (void)printf("The %s is: [space]\n", type);
  else if (c == '\0')
    (void)printf("The %s is: [none]\n", type);
  else
    (void)printf("The %s is: %c\n", type, c);
}

void report_daterep(Outchoices *od, choice j) {
  report_cols(od -> cols[j]);
  (void)printf("    Maximum number of rows: %u\n", od -> rows[j]);
  (void)printf("    Graphing by ");
  if (od -> graph[j] == 'R' || od -> graph[j] == 'r')
    (void)printf("requests\n");
  else if (od -> graph[j] == 'P' || od -> graph[j] == 'p')
    (void)printf("requests for pages\n");
  else
    (void)printf("bytes\n");
  (void)printf("    Displaying %s dates at top\n",
	 (od -> back[j])?"latest":"earliest");
}

void report_genrep(Outchoices *od, choice j) {
  static refdone = FALSE;

  report_cols(od -> cols[j]);
  report_sortby(od -> sortby[G(j)], FALSE);
  report_floor(&(od -> floor[G(j)]), FALSE);
  if (j == REP_REQ || j == REP_REDIR || j == REP_FAIL || j == REP_REF ||
      j == REP_REDIRREF || j == REP_FAILREF || j == REP_TYPE || j == REP_DIR ||
      j == REP_DOM || j == REP_REFSITE || j == REP_BROWSUM) {
    report_sortby(od -> subsortby[G(j)], TRUE);
    report_floor(&(od -> subfloor[G(j)]), TRUE);
  }
  report_want(od -> wanthead[G(j)], "in the report", "    ");
  report_alias(od -> aliashead[G(j)], "in the report", "    ");
  if (j == REP_REQ)
    report_want(od -> link, "links in the Request Report", "    ");
  else if (!refdone && (j == REP_REF || j == REP_REDIRREF ||
			j == REP_FAILREF)) {
    report_want(od -> reflink, "links in the referrer reports", "    ");
    refdone = TRUE;
  }
}

void report_cols(choice *cols) {
  choice c;

  (void)printf("    Columns:");
  if (cols[0] == COL_NUMBER)
    (void)printf(" <none>\n");
  else for (c = 0; cols[c] != COL_NUMBER; c++) {
    switch (cols[c]) {
    case COL_REQS:
      (void)printf(" #requests");
      break;
    case COL_PREQS:
      (void)printf(" %%requests");
      break;
    case COL_PAGES:
      (void)printf(" #pages");
      break;
    case COL_PPAGES:
      (void)printf(" %%pages");
      break;
    case COL_BYTES:
      (void)printf(" #bytes");
      break;
    case COL_PBYTES:
      (void)printf(" %%bytes");
      break;
    case COL_DATE:
      (void)printf(" date");
      break;
    }
  }
  (void)putchar('\n');
}

void report_sortby(choice sortby, logical sub) {
  if (sub)
    (void)printf("    Sorting sub-items ");
  else
    (void)printf("    Sorting ");
  if (sortby == ALPHABETICAL)
    (void)printf("alphabetically\n");
  else if (sortby == RANDOM)
    (void)printf("randomly\n");
  else if (sortby == REQUESTS)
    (void)printf("by number of requests\n");
  else if (sortby == PAGES)
    (void)printf("by number of requests for pages\n");
  else if (sortby == DATESORT)
    (void)printf("by date\n");
  else
    (void)printf("by number of bytes\n");
}

void report_floor(Floor *floor, logical sub) {
  /* this is copied (simplified) from whatincluded() in output2.c */
  extern char *engmonths[];
  unsigned long temp;
  timecode_t tempd;
  char *datestr;
  char *datefmt = "%d/%m/%y at %H:%n";

  if (sub)
    (void)printf("    Floor for sub-items is: ");
  else
    (void)printf("    Floor is: ");

  if (floor -> min < 0) {
    temp = (unsigned long)(-floor -> min + EPSILON);
    (void)printf("Top %lu item%s by ", temp, (temp == 1)?"":"s");
    if (floor -> floorby == REQUESTS)
      (void)printf("number of requests\n");
    else if (floor -> floorby == DATESORT)
      (void)printf("date of last request\n");
    else if (floor -> floorby == PAGES)
      (void)printf("number of requests for pages\n");
    else
      (void)printf("number of bytes\n");
  }
  else {   /* floor -> min >= 0 */
    if (floor -> floorby == DATESORT) {
      tempd = (timecode_t)(floor -> min + EPSILON);
      (void)printf("items with requests since ");
      datestr = (char *)xmalloc((size_t)datefmtlen(datefmt, 3, 0, NULL) + 1);
      (void)printf(datesprintf(datestr, datefmt, tempd / 1440,
			       (tempd % 1440) / 60, tempd % 60, 0, 0,
			       engmonths, NULL, 0, 0, NULL));
      free((void *)datestr);
    }
    else if (floor -> min > EPSILON) {
      if (floor -> qual == '\0') {
	temp = (unsigned long)(floor -> min + EPSILON);
	(void)printf("%lu ", temp);
	if (floor -> floorby == REQUESTS)
	  (void)printf((temp == 1)?"request\n":"requests\n");
	else if (floor -> floorby == PAGES)
	  (void)printf((temp == 1)?"request for a page\n":
		       "requests for pages\n");
	else
	  (void)printf((temp == 1)?"byte":"bytes");
      }
      else {  /* floor -> qual != '\0' */
	doublemprintf(stdout, 9999, floor -> min, '.');
	if (floor -> qual == '%') {
	  if (floor -> floorby == REQUESTS)
	    (void)printf("%% of the requests\n");
	  else if (floor -> floorby == PAGES)
	    (void)printf("%% of the requests for pages\n");
	  else
	    (void)printf("%% of the bytes\n");
	}
	else if (floor -> qual == ':') {
	  if (floor -> floorby == REQUESTS)
	    (void)printf("%% of the maximum number of requests\n");
	  else if (floor -> floorby == PAGES)
	    (void)printf("%% of the maximum number of requests for pages\n");
	  else
	    (void)printf("%% of the maximum number of bytes\n");
	}
	else /* if qual is anything else, must be (k|M|G|T)bytes */
	  (void)printf(" %cbytes\n", floor -> qual);
      }   /* end floor -> qual != '\0' */
    }     /* end floor -> min > EPSILON */
    else
      (void)printf("[all items]\n");
  }       /* end floor -> min > 0 */
}

/* put this function last so as not to break Emacs automatic indenting! */
void check_file(char *name) {
  FILE *f = NULL;

  if (!IS_STDIN(name) &&
#ifdef VMS
      (f = fopen(name, "r", "shr=upd")) == NULL)
#else
      (f = fopen(name, "r")) == NULL)
#endif
    (void)printf("    Warning: cannot open that file\n");
  if (f != NULL)
    (void)fclose(f);
}
