/*** analog 3.11 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

#include "analhea2.h"

/*** tree.c; functions for tree construction and processing. ***/

/* first, treefind(), analogous to hashfind() */
/* NB Don't really need as much data as Hashindex *, but allows us to use
   previous sort routines etc. */
Hashindex *treefind(char *name, char *nameend, Hashtable **tree,
		    Hashindex *item, cutfnp cutfn, logical build,
		    logical transient, Memman *space) {
  Hashindex *lp, *lastlp, *newone;   /* not called new because of C++ */
  unsigned long magic;

  if (*tree == NULL && !build)
    return(NULL);
  else if (*tree == NULL)
    *tree = rehash(NULL, TREEHASHSIZE, space);
  else if (TOO_FULL_TREE((*tree) -> n, (*tree) -> size))
    *tree = rehash(*tree, NEW_SIZE_TREE((*tree) -> size), space);
  if (build && (strchr(name, '*') != NULL || strchr(name, '?') != NULL))
    magic = 0;
  else
    MAGICNOTREE(magic, name, nameend, (*tree) -> size);

  lp = (*tree) -> head[magic];
  lastlp = NULL;

  while (TRUE) {
    if (lp == NULL) { /* not found */
      if (build) {
	newone = newtreeentry(name, nameend, item, transient, space);
	if (lastlp == NULL)
	  (*tree) -> head[magic] = newone;
	else
	  lastlp -> next = newone;
	((*tree) -> n)++;
	if (cutfn != NULL) {
	  cutfn(&name, &nameend, item -> name, build);
	  if (name != NULL)
	    (void)treefind(name, nameend, (Hashtable **)&(newone -> other),
			   item, cutfn, build, transient, space);
	}
      }
      else {  /* !build */
	for (newone = NULL, lp = (*tree) -> head[0]; lp != NULL; TO_NEXT(lp)) {
	  if (genwildmatch(name, nameend, lp -> name)) {
	    if (newone == NULL) {
	      newone = newtreeentry(name, nameend, item, transient, space);
	      if (lastlp == NULL)
		(*tree) -> head[magic] = newone;
	      else
		lastlp -> next = newone;
	      ((*tree) -> n)++;
	    }
	    graft((Hashtable **)&(newone -> other), (Hashtable *)(lp -> other),
		  space);
	  }
	}
	if (newone != NULL) {
	  if (cutfn != NULL) {
	    cutfn(&name, &nameend, item -> name, build);
	    if (name != NULL)
	      (void)treefind(name, nameend, (Hashtable **)&(newone -> other),
			     item, cutfn, build, transient, space);
	  }
	}
      }
      return(newone);
    }
    else if (genstreq(name, nameend, lp -> name)) {  /* found it */
      if (!IS_REUSED(lp -> own))
	lp -> own = newtreedata(lp -> own, space);
      treescore(lp -> own, item -> own);
      if (cutfn != NULL) {
	cutfn(&name, &nameend, item -> name, build);
	if (name != NULL)
	  (void)treefind(name, nameend, (Hashtable **)&(lp -> other),
			 item, cutfn, build, transient, space);
      }
      return(lp);
    }
    else {
      lastlp = lp;
      TO_NEXT(lp);
    }
  }
}

void graft(Hashtable **newone, Hashtable *old, Memman *space) {
  Hashindex *lp, *found;
  unsigned long magic;
  if (old != NULL) {
    for (magic = 0; magic < old -> size; magic++) {
      for (lp = old -> head[magic]; lp != NULL; TO_NEXT(lp)) {
	found = treefind(lp -> name, strchr(lp -> name, '\0'), newone, lp,
			 NULL, TRUE, FALSE, space);
	graft((Hashtable **)&(found -> other), (Hashtable *)(lp -> other),
	      space);
      }
    }
  }
}

void allgraft(Hashtable *t, Memman *space) {
  Hashindex *lp, *lp0;
  unsigned long magic;

  if (t != NULL) {
    for (magic = 1; magic < t -> size; magic++) {
      for (lp = t -> head[magic]; lp != NULL; TO_NEXT(lp)) {
	for (lp0 = t -> head[0]; lp0 != NULL; TO_NEXT(lp0)) {
	  if (wildmatch(lp -> name, lp0 -> name)) {
	    graft((Hashtable **)&(lp -> other), (Hashtable *)(lp0 -> other),
		  space);
	  }
	}
	allgraft((Hashtable *)(lp -> other), space);
      }
    }
  }
}

Hashindex *newtreeentry(char *name, char *nameend, Hashindex *item,
			logical transient, Memman *space) {
  Hashindex *ans = (Hashindex *)submalloc(space, sizeof(Hashindex));

  if (*nameend == '\0' && !transient)
    ans -> name = name;
  else {
    ans -> name = (char *)submalloc(space, (size_t)(nameend - name + 1));
    (void)memcpy((void *)(ans -> name), (void *)name,
		 (size_t)(nameend - name));
    ans -> name[(size_t)(nameend - name)] = '\0';
  }
  if (transient)
    ans -> own = newtreedata(item -> own, space);
  else
    ans -> own = item -> own;
  ans -> other = NULL;
  ans -> next = NULL;
  return(ans);
}

Hashentry *newtreedata(Hashentry *from, Memman *space) {
  Hashentry *ans = (Hashentry *)submalloc(space, sizeof(Hashentry));
  int i;

  for (i = 0; i < DATA_NUMBER; i++)
    ans -> data[i] = 0;
  ans -> bytes = 0.0;
  ans -> ispage = from -> ispage;  /* this is good enough */
  ans -> ispage += 16;             /* to indicate not reused */
  treescore(ans, from);
  return(ans);
}

void treescore(Hashentry *to, Hashentry *from) {
  int i;

  for (i = 0; i < COUNT_NUMBER; i++)
    to -> data[i] += from -> data[i];
  for ( ; i < DATA_NUMBER; i++)
    to -> data[i] = MAX(to -> data[i], from -> data[i]);
  to -> bytes += from -> bytes;
}

Hashindex *sorttree(Hashtable *tree, Floor *floor, choice sortby,
		    Floor *subfloor, choice subsortby, Include *wanthead,
		    Alias *notcorrupt, choice requests, choice date,
		    unsigned long totr, unsigned long totp, double totb,
		    unsigned long maxr, unsigned long maxp, double maxb,
		    Hashentry **badp, unsigned long *badn, Memman *space) {
  Hashindex *gooditems, *baditems, *p, *np;
  Alias *ap;
  unsigned long i;
  logical ok;

  unhash(tree, &gooditems, &baditems);
  if (notcorrupt != NULL) {
    baditems = (Hashindex *)submalloc(space, sizeof(Hashindex));
    baditems -> name = "[unknown domains]"; /* notcorrupt only used for doms */
    baditems -> own = (Hashentry *)submalloc(space, sizeof(Hashentry));
    for (i = 0; i < DATA_NUMBER; i++)
      baditems -> own -> data[i] = 0;
    baditems -> own -> bytes = 0.0;
    baditems -> own -> ispage = FALSE;
    baditems -> other = NULL;
    baditems -> next = NULL;
    for (p = gooditems, np = NULL; p != NULL; TO_NEXT(p)) {
      for (ok = FALSE, ap = notcorrupt; !ok && ap != NULL; TO_NEXT(ap)) {
	if (STREQ(p -> name, ap -> from))
	  ok = TRUE;
      }
      if (ok)
	np = p;
      else {   /* erase p from list */
	if (strchr(p -> name, '*') == NULL && strchr(p -> name, '?') == NULL)
	  debug('U', "%s", p -> name);
	treescore(baditems -> own, p -> own);
	if (np == NULL)
	  gooditems = p -> next;
	else
	  np -> next = p -> next;
      }
    }
  }
  for (i = 0; i < tree -> size; i++)
    tree -> head[i] = NULL;
  my_sort(&gooditems, &baditems, floor, sortby, FALSE, wanthead, requests,
	  date, totr, totp, totb, maxr, maxp, maxb);
  if (badp != NULL) {
    *badp = newhashentry(FALSE);
    *badn = 0;
    for (p = baditems; p != NULL; TO_NEXT(p)) {
      if (p -> own != NULL && p -> own -> data[requests] > 0) {
	(*badp) -> data[requests] += p -> own -> data[requests];
	(*badp) -> data[PAGES] += p -> own -> data[PAGES];
	(*badp) -> bytes += p -> own -> bytes;
	(*badp) -> data[date] = MAX((*badp) -> data[date],
				    p -> own -> data[date]);
	(*badn)++;
      }
    }
  }
  for (p = gooditems; p != NULL; TO_NEXT(p)) {
    if (p -> other != NULL) {
      ((Hashtable *)(p -> other)) -> head[0] =
	sorttree((Hashtable *)(p -> other), subfloor, subsortby,
		 subfloor, subsortby, NULL, NULL, requests, date, totr,
		 totp, totb, maxr, maxp, maxb, NULL, NULL, space);
    }
  }
  return(gooditems);
}

void maketree(Tree *treex, Hashindex *gooditems, Hashindex *baditems) {
  Hashindex *p;
  char *name, *nameend;

  for (p = gooditems; p != NULL; TO_NEXT(p)) {
    if (p -> own != NULL) {
      name = NULL;
      treex -> cutfn(&name, &nameend, p -> name, FALSE);
      (void)treefind(name, nameend, &(treex -> tree), p, treex -> cutfn,
		     FALSE, FALSE, treex -> space);
    }
  }
  for (p = baditems; p != NULL; TO_NEXT(p)) {
    if (p -> own != NULL) {
      name = NULL;
      treex -> cutfn(&name, &nameend, p -> name, FALSE);
      (void)treefind(name, nameend, &(treex -> tree), p, treex -> cutfn,
		     FALSE, FALSE, treex -> space);
    }
  }
}

void maketreename(char *n, Strlist *s, char *c, logical start, logical end) {
  /* Compile name from strlist. Caller must check sufficient space in n. */
  Strlist *p;

  if (start)
    (void)strcpy(n, c);
  else
    n[0] = '\0';
  for (p = s; p != NULL; TO_NEXT(p)) {
    (void)strcat(n, p -> name);
    if (end || p -> next != NULL)
      (void)strcat(n, c);
  }
}

logical sublevels(Hashtable *tree) {
  /* check if a tree has anything below the top level */
  Hashindex *p;
  unsigned long i;

  if (tree != NULL) {
    for (i = 0; i < tree -> size; i++) {
      for (p = tree -> head[i]; p != NULL; TO_NEXT(p)) {
	if (p -> other != NULL)
	  return(TRUE);
      }
    }
  }
  return(FALSE);
}

/* genstreq is like streq but takes double-pointer strings */
logical genstreq(char *a, char *b, char *t) {
  for ( ; *a == *t && a < b; a++)
    t++;
  if (a == b && *t == '\0')
    return(TRUE);
  else
    return(FALSE);
}

/* Now the various nextname functions, which vary by type of item. Pattern is
   void ?nextname(char **name, char **nameend, char *whole, logical build).
   whole is whole name; [name, nameend) is last chunk (name == NULL if none);
   build is because behaviour of leading/trailing delimiters may be different
   if building tree; return new [name, nameend), or name = NULL if no more;
   never return NULL if given NULL. */

void rnextname(char **name, char **nameend, char *whole, logical build) {
  if (*name == NULL) {
    *name = whole;
    if ((*nameend = strchr(whole, '?')) == NULL)
      *nameend = strchr(whole, '\0');
  }
  else if (IS_EMPTY_STRING(*nameend))
    *name = NULL;
  else {
    *name = *nameend + 1;
    *nameend = strchr(*name, '\0');
  }
}

void inextname(char **name, char **nameend, char *whole, logical build) {
  static char *s = "/";
  logical first = FALSE;

  if (*name == NULL) {
    *name = whole;
    first = TRUE;
  }
  else if (IS_EMPTY_STRING(*nameend) || IS_EMPTY_STRING((*nameend) + 1) ||
	   **nameend == '?' || *((*nameend) + 1) == '?') {
    *name = NULL;
    return;
  }
  else
    *name = *nameend + 1;

  for (*nameend = *name + (ptrdiff_t)(first && **name != '\0');
       **nameend != '/' && **nameend != '\0' && **nameend != '?'; (*nameend)++)
    ;  /* run nameend to next '/', '\0' or '?' */
  if (**nameend == '/') {
    for ( ; *((*nameend) + 1) == '/'; (*nameend)++)
      ;  /* run to last consecutive '/' */
  }
  if ((**nameend == '\0' || **nameend == '?') && !build) {
    if (first && **name != '/') {
      *name = s;
      *nameend = s + 1;
    }
    else if (first)
      *name = *nameend;
    else
      *name = NULL;
  }
}

void onextname(char **name, char **nameend, char *whole, logical build) {
  static char *s0 = "0";
  static char *s1 = "1";
  static logical isnum = FALSE;

  if (*name == NULL) {
    isnum = FALSE;
    *nameend = strchr(whole, '\0');
    if (!build) {
      if (strchr(whole, '.') == NULL) {
	*name = s1;
	*nameend = s1 + 1;
	return;
      }
      if (isdigit(*(*nameend - 1))) {
	*name = s0;
	*nameend = s0 + 1;
	isnum = TRUE;
	return;
      }
    }
    else if (isdigit(*whole) &&  /* test for num. more subtle while building */
	     (isdigit(*(*nameend - 1)) || *(*nameend - 1) == '*')) {
      *name = s0;
      *nameend = s0 + 1;
      isnum = TRUE;
      return;
    }
    for (*name = *nameend - 1; **name != '.' && *name != whole; (*name)--)
      ;
    if (**name == '.')
      (*name)++;
  }
  else if (isnum) {
    if (*name == s0)
      *name = whole;
    else if (IS_EMPTY_STRING(*nameend) || IS_EMPTY_STRING((*nameend) + 1)) {
      *name = NULL;
      return;
    }
    else
      *name = *nameend + 1;
    for (*nameend = *name; **nameend != '.' && **nameend != '\0'; (*nameend)++)
      ;   /* run to first '.' or '\0' */
  }
  else if (*name == s1 || *name - whole < 2)
    *name = NULL;
  else {
    *nameend = *name - 1;
    for (*name -= 2; **name != '.' && *name != whole; (*name)--)
      ;
    if (**name == '.')
      (*name)++;
  }
}

void tnextname(char **name, char **nameend, char *whole, logical build) {
  logical first = FALSE;

  if (*name == NULL) {
    if ((*nameend = strchr(whole, '?')) == NULL)
      *nameend = strchr(whole, '\0');
    first = TRUE;
  }
  else if (*name == whole || *name == whole + 1 || **name == '/') {
    *name = NULL;
    return;
  }
  else
    *nameend = *name - 1;
  *name = *nameend - 1;
  if (**name == '/' && first)
    return;
  for ( ; **name != '.' && **name != '/' && *name != whole; (*name)--)
    ;
  if (**name == '.')
    (*name)++;
  else if (build)
    return;
  else if (first) {
    *name = whole;
    *nameend = whole;
  }
  else
    *name = NULL;
}

void fnextname(char **name, char **nameend, char *whole, logical build) {
  if (*name == NULL) {
    *name = whole;
    for (*nameend = *name; **nameend != ':' && **nameend != '\0'; (*nameend)++)
      ;
    if (*nameend == '\0') {
      *nameend = *name;
      return;
    }
    (*nameend)++;
    if (**nameend == '/')
      (*nameend)++;
    if (**nameend == '/')
      (*nameend)++;
    for ( ; **nameend != '/' && **nameend != '\0'; (*nameend)++)
      ;
  }
  else
    inextname(name, nameend, whole, build);
}

void bnextname(char **name, char **nameend, char *whole, logical build) {
  char *s1 = "Mozilla (compatible)";
  char *s2 = "Mosaic";

  if (*name == NULL) {
    if (genwildmatch(whole, whole + 7, "Mozilla") &&
	strstr(whole + 9, "ompatible")) {
      *name = s1;
      *nameend = s1 + 20;
    }
    else if (strstr(whole, "osaic")) {
      *name = s2;
      *nameend = s2 + 6;
    }
    else {
      *name = whole;
      for (*nameend = *name; **nameend != '/' && **nameend != '\0';
	   (*nameend)++)
	;
    }
  }
  else if (**nameend == '/') {
    *name = *nameend + 1;
    for (*nameend = *name; **nameend != ' ' && **nameend != '\0'; (*nameend)++)
      ;
  }
  else
    *name = NULL;
}
