/* $Id: BlowfishKeyGenerator.java,v 1.2 1999/08/13 19:07:58 gelderen Exp $
 *
 * Copyright (C) 1995-1999 Systemics Ltd. 
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce12.provider.cipher;



/**
 * A key generator for Blowfish.
 * See {@link cryptix.jce12.provider.cipher.Blowfish Blowfish} for details.
 * <p>
 * Blowfish key length is between 40 and 448 bits inclusive, (8-bit increments).
 *
 * @version $Revision: 1.2 $
 * @author  Jeroen C. van Gelderen <gelderen@cryptix.org>
 */
public class BlowfishKeyGenerator extends RawKeyGenerator
{
    public BlowfishKeyGenerator() {
        // 128 bit keys by default
        super("Blowfish", 128);
    }


    protected boolean isWeak( byte[] key ) {
        // Blowfish does not really have weak keys
        return false;
    }
    
    
    protected boolean isValidSize( int size ) {
        // 40 bits to 448 bits in 8-bit increments    
        return ((size&0x7)==0) && (size>=40) && (size<=448) ? true : false;

    }
}
