/* $Id: CAST5KeyGenerator.java,v 1.2 1999/08/13 19:34:12 gelderen Exp $
 *
 * Copyright (C) 1995-1999 Systemics Ltd. 
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce12.provider.cipher;



/**
 * A key generator for CAST5.
 * <p>
 * The CAST5 encryption algorithm has been designed to allow a key size
 * that can vary from 40 bits to 128 bits, in 8-bit increments (that is, 
 * the allowable key sizes are 40, 48, 56, 64, ..., 112, 120, and 128 
 * bits.
 *
 * @version $Revision: 1.2 $
 * @author  Jeroen C. van Gelderen <gelderen@cryptix.org>
 */
public class CAST5KeyGenerator extends RawKeyGenerator
{
    public CAST5KeyGenerator() {
        super("CAST5", 128);
    }


    protected boolean isWeak( byte[] key ) {
        return false;
    }
    

    protected boolean isValidSize( int size ) {
        // 40 bits to 128 bits in 8-bit increments    
        return ((size&0x7)==0) && (size>=40) && (size<=128) ? true : false;
    }
}
