/* $Id: Mode.java,v 1.2 1999/08/22 02:53:20 gelderen Exp $
 *
 * Copyright (C) 1995-1999 Systemics Ltd.
 * on behalf of the Cryptix Development Team. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce12.provider.cipher;


import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher; // FIXME: remove? (see below)
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;


// FIXME: make explicit
import java.security.*;
import java.security.spec.*;
import javax.crypto.*;


abstract class Mode
{
    /** Underlying block cipher */
    protected final BlockCipher cipher;


    /** Block size of underlying cipher */
    protected final int CIPHER_BLOCK_SIZE;


    /** Decrypting? */
    protected boolean decrypt;


    Mode(BlockCipher cipher) {
        this.cipher       = cipher;
        CIPHER_BLOCK_SIZE = cipher.coreGetBlockSize();
    }


    static Mode getInstance(String mode, BlockCipher cipher)
    throws NoSuchAlgorithmException
    {
        if( mode.equalsIgnoreCase("CBC") )
            return new ModeCBC(cipher);
        else if( mode.equalsIgnoreCase("ECB") )
            return new ModeECB(cipher);
        else if( mode.equalsIgnoreCase("OFB") )
            return new ModeOFB(cipher);
        else
            throw new NoSuchAlgorithmException();
    }


    void init(boolean decrypt, Key key, AlgorithmParameterSpec params,
                    SecureRandom random)
    throws InvalidKeyException, InvalidAlgorithmParameterException
    {
        this.decrypt = decrypt;
        coreInit(decrypt, key, params, random);
    }


    final int getOutputSize(int inputLen) {
        return coreGetOutputSize(inputLen);
    }


    final int getBlockSize() {
        return CIPHER_BLOCK_SIZE;
    }


    final int update(byte[] input, int inputOffset, int inputLen,
                     byte[] output, int outputOffset)
    throws ShortBufferException {
        return coreUpdate(input, inputOffset, inputLen, output, outputOffset);
    }


// Abstract methods
//............................................................................

    abstract int coreGetOutputSize(int inputLen);

    abstract void coreInit(boolean decrypt, Key key, 
                           AlgorithmParameterSpec params, SecureRandom random)
    throws InvalidKeyException, InvalidAlgorithmParameterException;


    abstract int coreUpdate(byte[] input, int inputOffset, int inputLen,
                           byte[] output, int outputOffset)
    throws ShortBufferException;

}