/* $Id: ModeOFB.java,v 1.2 1999/08/22 02:53:21 gelderen Exp $
 *
 * Copyright (C) 1995-1999 Systemics Ltd.
 * on behalf of the Cryptix Development Team. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce12.provider.cipher;


import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher; // FIXME: remove? (see below)
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;


// FIXME: make explicit
import java.security.*;
import java.security.spec.*;
import javax.crypto.*;


final class ModeOFB extends Mode
{
    private final byte[] keyStreamBuf;


    private int keyStreamBufOffset;


    ModeOFB(BlockCipher cipher) {
        super(cipher);
        keyStreamBuf = new byte[CIPHER_BLOCK_SIZE];
    }


// Implementation
//............................................................................

    final int coreGetOutputSize(int inputLen) {
        // we are a stream cipher, we don't buffer anything
        return inputLen;
    }
    
    
    void coreInit(boolean decrypt, Key key, AlgorithmParameterSpec params,
                    SecureRandom random)
    throws InvalidKeyException, InvalidAlgorithmParameterException
    {
        // always use block cipher in encrypt mode
        cipher.coreInit(key, false);
        
        // set IV and crypt once to generate initial key stream bytes
        IvParameterSpec iv = (IvParameterSpec)params;
        System.arraycopy(iv.getIV(), 0, keyStreamBuf, 0, CIPHER_BLOCK_SIZE);
        cipher.coreCrypt(keyStreamBuf, 0, keyStreamBuf, 0);
        keyStreamBufOffset = 0;
    }


    final int coreUpdate(byte[] input, int inputOffset, int inputLen,
               byte[] output, int outputOffset)
    throws ShortBufferException
    {
        int todo = inputLen;
        while( todo-- > 0 ) {
            if( keyStreamBufOffset >= CIPHER_BLOCK_SIZE ) {
                cipher.coreCrypt(keyStreamBuf, 0, keyStreamBuf, 0);
                keyStreamBufOffset = 0;
            }
            output[outputOffset++] = (byte)
                (input[inputOffset++] ^ keyStreamBuf[keyStreamBufOffset++]);
        }
        return inputLen;
    }
}