/* $Id: Padding.java,v 1.1 1999/08/21 02:58:52 gelderen Exp $
 *
 * Copyright (C) 1995-1999 Systemics Ltd.
 * on behalf of the Cryptix Development Team. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce12.provider.cipher;


// FIXME: make explicit
import java.security.*;
import java.security.spec.*;
import javax.crypto.*;


abstract class Padding
{
    private final Mode mode;


    private byte[] scratchBuf;


    Padding(Mode mode) {
        this.mode = mode;
    }


    static Padding getInstance(String padding, Mode mode)
    throws NoSuchPaddingException
    {
        if( padding.equalsIgnoreCase("None") )
            return new PaddingNone(mode);
        else
            throw new NoSuchPaddingException();
    }


    final int getBlockSize() {
        return mode.getBlockSize();
    }


    final int getOutputSize(int inputLen) {
        return mode.getOutputSize(inputLen); // FIXME
    }


    final byte[] getIV() {
        throw new RuntimeException();
    }


    final void init(boolean decrypt, Key key, AlgorithmParameterSpec params,
                    SecureRandom random)
    throws InvalidKeyException, InvalidAlgorithmParameterException
    {
        mode.init(decrypt, key, params, random);
    }


    final int update(byte[] input, int inputOffset, int inputLen,
                     byte[] output, int outputOffset)
    throws ShortBufferException
    {
        return mode.update(input, inputOffset, inputLen, output, outputOffset);
    }


    final int doFinal(byte[] input, int inputOffset, int inputLen,
                      byte[] output, int outputOffset)
    throws ShortBufferException, IllegalBlockSizeException, BadPaddingException
    {
        return mode.update(input, inputOffset, inputLen, output, outputOffset);
    }
}