/* $Id: SHA1.java,v 1.1 1999/08/16 22:49:04 gelderen Exp $
 *
 * Copyright (C) 1995-1999 Systemics Ltd.
 * on behalf of the Cryptix Development Team. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */

package cryptix.jce12.provider.md;


/**
 * SHA-1 message digest algorithm.
 *
 * @version $Revision: 1.1 $
 * @author  Jeroen C. van Gelderen
 */
public final class SHA1
extends SHA
{
// Constructors
//...........................................................................

    public SHA1() {
        super();
    }



// Concreteness
//...........................................................................

    protected void expand(int[] W) {
        // expand the block to 80 words, according to the SHA1 spec
        for( int i=16; i<80; i++ ) {
            int j = W[i-16] ^ W[i-14] ^ W[i-8] ^ W[i-3];
            W[i] = (j << 1) | (j >>> -1);
        }
    }
}