/* $Id: BaseRSAPublicKey.java,v 1.1 1999/08/13 17:39:31 gelderen Exp $
 *
 * Copyright (C) 1995-1999 Systemics Ltd.
 * on behalf of the Cryptix Development Team. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce12.provider.rsa;


import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;


/**
 * An abstract class representing an RSA public key.
 *
 * @version $Revision: 1.1 $
 * @author  Raif S. Naffah
 * @author  David Hopwood
 * @author  Jeroen C. van Gelderen
 * @since   Cryptix 2.2.2
 */
public abstract class BaseRSAPublicKey
implements RSAPublicKey
{

// Variables
//...........................................................................

    /**
     * Public modulus. It is the product of the two <i>p</i> and <i>q</i>
     * factors but for a public key we do not have access to them.
     */
    private BigInteger n;

    /** Public exponent. */
    private BigInteger e;


// Constructor and Object methods
//...........................................................................

    /**
     * Constructs an RSA private key, without setting the parameters.
     * Subclasses should call one of the setRsaParams methods in each of
     * their constructors.
     */
    protected BaseRSAPublicKey(BigInteger n, BigInteger e)
    {
        if (n == null) throw new NullPointerException("n == null");
        if (e == null) throw new NullPointerException("e == null");

        this.n = n;
        this.e = e;
    }


    /**
     * Returns a string representation of this key.
     *
     * @return a string representation of this key.
     */
    public String toString () {
        return "BaseRSAPublicKey";
    }


// RSAKey interface methods implementation
//...........................................................................

    /**
     * Returns the public modulus <i>n</i>.
     *
     * @return the public modulus <i>n</i>.
     */
    public BigInteger getModulus() { return n; }

    /**
     * Returns the public exponent <i>e</i>.
     *
     * @return the public exponent <i>e</i>.
     */
    public BigInteger getPublicExponent() { return e; }


// Key interface methods implementation
//...........................................................................

    /**
     * Returns the name of the algorithm, for this class always "RSA".
     *
     * @return the name of the algorithm, "RSA".
     */
    public String getAlgorithm() { return "RSA"; }
}
