/* $Id: RIPEMD160_RSA_PKCS1Signature.java,v 1.1 1999/08/13 17:39:31 gelderen Exp $
 *
 * Copyright (C) 1995-1999 Systemics Ltd.
 * on behalf of the Cryptix Development Team. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce12.provider.rsa;


/**
 * A class to digest a message with RIPEMD160, and sign/verify the
 * resulting hash using the RSA digital signature scheme, with PKCS#1
 * block padding.
 *
 * @version $Revision: 1.1 $
 * @author  Raif S. Naffah
 * @author  David Hopwood
 * @author  Jeroen C. van Gelderen
 * @since   Cryptix 2.2.2
 */
public class RIPEMD160_RSA_PKCS1Signature
extends Any_RSA_PKCS1Signature
{
// Constants and variables
//...........................................................................

    private static final byte[] RIPEMD160_ASN_DATA = {
        0x30, 0x21,                                    // SEQUENCE 33
          0x30, 0x09,                                    // SEQUENCE 9
            0x06, 0x05, 0x2B, 0x24, 0x03, 0x02, 0x01,      // OID {1.3.36.3.2.1}
            0x05, 0x00,                                    // NULL
          0x04, 0x14                                     // OCTET STRING 20
    };


// Constructor
//...........................................................................

    public RIPEMD160_RSA_PKCS1Signature() { super("RIPEMD160"); }


// Any_RSA_PKCS1Signature abstract method implementation
//...........................................................................

    protected byte[] getAlgorithmEncoding() { return RIPEMD160_ASN_DATA; }
}
