/* $Id: Cryptix.java,v 1.3 1999/08/17 04:02:32 gelderen Exp $
 *
 * Copyright (C) 1995-1999 Systemics Ltd.
 * on behalf of the Cryptix Development Team. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce12.provider;


import java.security.Provider;


// FIXME: Use doPrivilegedAction. See JDK 1.2 doco/tutorial.. ??
// TODO:  Report list of algorithms in INFO string?
// TODO:  Create automatic version number, based on CVS Revision.
//        How does one map 1.1.2.96 to a double in a sensible way?


/**
 * The Cryptix JCE 1.2 Strong Crypto Provider.
 *
 * @version $Revision: 1.3 $
 * @author  Jeroen C. van Gelderen (gelderen@cryptix.org)
 */
public final class Cryptix extends Provider
{

// Static variables and onstants
//...........................................................................

    private static final String
        NAME    = "Cryptix",
        INFO    = "Cryptix JCE 1.2 Strong Crypto Provider";
    private static final double
        VERSION = 1.2;


// Constructor
//...........................................................................

    public Cryptix() {

        super(NAME, VERSION, INFO);

        //
        // Ciphers + KeyGenerators
        //

        // Blowfish
        put("Cipher.Blowfish", "cryptix.jce12.provider.cipher.Blowfish");
        put("KeyGenerator.Blowfish", "cryptix.jce12.provider.cipher.BlowfishKeyGenerator");

        // CAST5
        put("Cipher.CAST5", "cryptix.jce12.provider.cipher.CAST5");
        put("KeyGenerator.CAST5", "cryptix.jce12.provider.cipher.CAST5KeyGenerator");

        // DES
        put("Cipher.DES", "cryptix.jce12.provider.cipher.DES");
        put("KeyGenerator.DES", "cryptix.jce12.provider.cipher.DESKeyGenerator");

        // IDEA
        put("Cipher.IDEA", "cryptix.jce12.provider.cipher.IDEA");
        put("KeyGenerator.IDEA", "cryptix.jce12.provider.cipher.IDEAKeyGenerator");

        // RC2
        put("Cipher.RC2", "cryptix.jce12.provider.cipher.RC2");
        put("KeyGenerator.RC2", "cryptix.jce12.provider.cipher.RC2KeyGenerator");

        // Rijndael
        put("Cipher.Rijndael", "cryptix.jce12.provider.cipher.Rijndael");
        put("KeyGenerator.Rijndael", "cryptix.jce12.provider.cipher.RijndaelKeyGenerator");

        // SKIPJACK
        put("Cipher.SKIPJACK", "cryptix.jce12.provider.cipher.SKIPJACK");
        put("KeyGenerator.SKIPJACK", "cryptix.jce12.provider.cipher.SKIPJACKKeyGenerator");

        // Square
        put("Cipher.Square", "cryptix.jce12.provider.cipher.Square");
        put("KeyGenerator.Square", "cryptix.jce12.provider.cipher.SquareKeyGenerator");

        // TripleDES
        put("Cipher.TripleDES", "cryptix.jce12.provider.cipher.TripleDES");
        put("Alg.Alias.Cipher.DESede", "TripleDES");
        put("KeyGenerator.TripleDES", "cryptix.jce12.provider.cipher.TripleDESKeyGenerator");
        put("Alg.Alias.KeyGenerator.DESede", "TripleDES");


        //
        // Macs
        //
        put("Mac.HMAC-MD5", "cryptix.jce12.provider.mac.HMAC_MD5");
        put("Mac.HMAC-RIPEMD128", "cryptix.jce12.provider.mac.HMAC_RIPEMD128");
        put("Mac.HMAC-RIPEMD160", "cryptix.jce12.provider.mac.HMAC_RIPEMD160");
        put("Mac.HMAC-SHA", "cryptix.jce12.provider.mac.HMAC_SHA");


        //
        // MessageDigests
        //

        // MD2
        put("MessageDigest.MD2", "cryptix.jce12.provider.md.MD2");

        // MD4
        put("MessageDigest.MD4", "cryptix.jce12.provider.md.MD4");

        // RIPEMD-128
        put("MessageDigest.RIPEMD128", "cryptix.jce12.provider.md.RIPEMD128");
        put("Alg.Alias.MessageDigest.RIPEMD-128", "RIPEMD128");

        // RIPEMD-160
        put("MessageDigest.RIPEMD160", "cryptix.jce12.provider.md.RIPEMD160");
        put("Alg.Alias.MessageDigest.RIPEMD-160", "RIPEMD160");

        // SHA (SHA-1)
        put("MessageDigest.SHA", "cryptix.jce12.provider.md.SHA1");

        // SHA-0
        put("MessageDigest.SHA0", "cryptix.jce12.provider.md.SHA0");

        //
        // Signatures
        //

        // MD2/RSA/PKCS#1
        put("Signature.MD2withRSA", "cryptix.jce12.provider.rsa.MD2_RSA_PKCS1Signature");
        put("Alg.Alias.Signature.MD2/RSA/PKCS#1", "MD2withRSA");

        // MD4/RSA/PKCS#1
        put("Signature.MD4withRSA", "cryptix.jce12.provider.rsa.MD4_RSA_PKCS1Signature");
        put("Alg.Alias.Signature.MD4/RSA/PKCS#1", "MD5withRSA");

        // MD5/RSA/PKCS#1
        put("Signature.MD5withRSA", "cryptix.jce12.provider.rsa.MD5_RSA_PKCS1Signature");
        put("Alg.Alias.Signature.MD5/RSA/PKCS#1", "MD5withRSA");

        // SHA-1/RSA/PKCS#1
        put("Signature.SHA1withRSA", "cryptix.jce12.provider.rsa.SHA1_RSA_PKCS1Signature");
        put("Alg.Alias.Signature.SHA/RSA/PKCS#1"  , "SHA1withRSA");
        put("Alg.Alias.Signature.SHA1/RSA/PKCS#1" , "SHA1withRSA");
        put("Alg.Alias.Signature.SHA-1/RSA/PKCS#1", "SHA1withRSA");

        // DSA
        put("Signature.RawDSA", "cryptix.jce12.provider.dsa.RawDSASignature");
    }
}
