/* $Id: MessageDigestSpi.java,v 1.2 1999/08/14 18:48:18 gelderen Exp $
 *
 * Copyright (C) 1995-1998 Systemics Ltd.
 * on behalf of the Cryptix Development Team. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package java.security;


/**
 * JDK 1.1 compatibility layer. Our hashes derive from the MessageDigestSpi
 * class which is not present in JDK 1.1.
 *
 * In JDK 1.2, MessageDigest extends MessageDigestSpi but in JDK 1.1, 
 * MessageDigestSpi extends MessageDigest. This is transparent, except 
 * for the fact that the 1.1 MessageDigest constructor needs a String 
 * representing the algorithm name. 
 *
 * For now we simply set the empty string (""). Should this become a 
 * problem,we can revert to 'compatibility mode' and derive our hashes 
 * from MessageDigest instead of from MessageDigestSpi.
 */
public abstract class MessageDigestSpi
extends MessageDigest
{
    public MessageDigestSpi() {
        super(""); // empty string (see above)
    }
}
