/* $Id: DESedeKeySpec.java,v 1.1.1.1 1999/07/13 23:15:32 gelderen Exp $
 *
 * Copyright (C) 1995-1998 Systemics Ltd. 
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto.spec;


import java.security.InvalidKeyException;
import java.security.spec.KeySpec;


public class DESedeKeySpec
implements KeySpec {

    public static final int DES_EDE_KEY_LEN = 24;


    private final byte[] key_;


    public DESedeKeySpec(byte[] key)
    throws InvalidKeyException {
        this(key, 0);
    }


    public DESedeKeySpec(byte[] key, int offset)
    throws InvalidKeyException {

        if( (key.length-offset) < DES_EDE_KEY_LEN )
            throw new InvalidKeyException("Wrong size");

        key_ = new byte[DES_EDE_KEY_LEN];
        System.arraycopy(key, offset, key_, 0, DES_EDE_KEY_LEN);
    }


    public byte[] getKey() {
        return (byte[])key_.clone();
    }


    public static boolean isParityAdjusted(byte[] key, int offset)
    throws InvalidKeyException {
        throw new RuntimeException("Method not yet implemented");
    }

}





    