/* $Id: DHParameterSpec.java,v 1.1.1.1 1999/07/13 23:15:32 gelderen Exp $
 *
 * Copyright (C) 1995-1998 Systemics Ltd. 
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto.spec;


import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;


public class DHParameterSpec
implements AlgorithmParameterSpec {

    private final BigInteger p_;
    private final BigInteger g_;
    private final int        l_;
    
    
    // assumes l=0
    public DHParameterSpec(BigInteger p, BigInteger g) {
        this(p, g, 0);
    }
    
    
    public DHParameterSpec(BigInteger p, BigInteger g, int l) {
        p_ = p;
        g_ = g;
        l_ = l;
    }


    public BigInteger getP() {
        return p_;
    }
    
    
    public BigInteger getG() {
        return g_;
    }
    
    
    // returns 0 if l not set
    public int getL() {
        return l_;
    }
}
