/* $Id: DHPrivateKeySpec.java,v 1.1.1.1 1999/07/13 23:15:32 gelderen Exp $
 *
 * Copyright (C) 1995-1998 Systemics Ltd. 
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto.spec;


import java.math.BigInteger;
import java.security.spec.KeySpec;


public class DHPrivateKeySpec
implements KeySpec {
    
    private final BigInteger x_;
    private final BigInteger p_;
    private final BigInteger g_;
    
    
    public DHPrivateKeySpec(BigInteger x, BigInteger p, BigInteger g) {
        x_ = x;
        p_ = p;
        g_ = g;
    }
    
    
    public BigInteger getX() {
        return x_;
    }
    
    
    public BigInteger getP() {
        return p_;
    }
    
    
    public BigInteger getG() {
        return g_;
    }
}
