/* $Id: IvParameterSpec.java,v 1.1.1.1 1999/07/13 23:15:32 gelderen Exp $
 *
 * Copyright (C) 1995-1998 Systemics Ltd. 
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto.spec;


import java.security.spec.AlgorithmParameterSpec;


public class IvParameterSpec
implements AlgorithmParameterSpec {


    private final byte[] iv_;

    
    public IvParameterSpec(byte[] iv) {
        iv_ = (byte[])iv.clone();
    }
    
    
    public IvParameterSpec(byte[] iv, int offset, int len) {
        iv_ = new byte[len];
        System.arraycopy(iv, offset, iv_, 0, len);
    }
    
    
    public byte[] getIV() {
        return (byte[])iv_.clone();
    }
}
