/* $Id: RC2ParameterSpec.java,v 1.1.1.1 1999/07/13 23:15:32 gelderen Exp $
 *
 * Copyright (C) 1995-1998 Systemics Ltd. 
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto.spec;


import java.security.spec.AlgorithmParameterSpec;


public class RC2ParameterSpec
implements AlgorithmParameterSpec {
    
    private final int    bits_;
    private final byte[] iv_;
    
    public RC2ParameterSpec(int effectiveKeyBits) {
        bits_ = effectiveKeyBits;
        iv_   = null;
    }
    
    
    public RC2ParameterSpec(int effectiveKeyBits, byte[] iv) {
        bits_ = effectiveKeyBits;
        iv_   = iv;
    }
    
    
    public RC2ParameterSpec(int effectiveKeyBits, byte[] iv, int offset) {
        bits_ = effectiveKeyBits;
        iv_ = new byte[8];
        System.arraycopy(iv, offset, iv_, 0, iv_.length);
    }
    
    
    public int getEffectiveKeyBits() {
        return bits_;
    }
    
    
    public byte[] getIV() {
        return (byte[])iv_.clone();
    }
}
