/* $Id: RC5ParameterSpec.java,v 1.1.1.1 1999/07/13 23:15:32 gelderen Exp $
 *
 * Copyright (C) 1995-1998 Systemics Ltd. 
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto.spec;


import java.security.spec.AlgorithmParameterSpec;


public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    
    private final int version_;
    private final int rounds_;
    private final int wordSize_;
    private final byte[] iv_;
    
    
    public RC5ParameterSpec(int version, int rounds, int wordSize) {
        version_  = version;
        rounds_   = rounds;
        wordSize_ = wordSize;
        iv_       = null;
    }
    
    
    public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] iv) {
        version_  = version;
        rounds_   = rounds;
        wordSize_ = wordSize;
        iv_       = (byte[])iv.clone();
    }
    
    
    public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] iv, int offset) {
        version_  = version;
        rounds_   = rounds;
        wordSize_ = wordSize;
        
        iv_ = new byte[2*(wordSize/8)];
        System.arraycopy(iv, offset, iv_, 0, iv_.length);
    }
    
    
    public int getVersion() {
        return version_;
    }
    
    
    public int getRounds() {
        return rounds_;
    }
    
    
    public int getWordSize() {
        return wordSize_;
    }
    
    
    public byte[] getIV() {
        return (byte[])iv_.clone();
    }
}
