/* $Id: SecretKeySpec.java,v 1.1.1.1 1999/07/13 23:15:32 gelderen Exp $
 *
 * Copyright (C) 1995-1998 Systemics Ltd. 
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto.spec;


import java.security.spec.KeySpec;


public class SecretKeySpec
implements KeySpec, javax.crypto.SecretKey {
    
    private final byte[] key_;
    private final String alg_;
    
    
    public SecretKeySpec(byte[] key, String algorithm) {
        key_ = (byte[])key.clone();
        alg_ = algorithm;
    }
    
    
    public SecretKeySpec(byte[] key, int offset, int len, String algorithm) {
        key_ = new byte[len];
        System.arraycopy(key, offset, key_, 0, len);
        alg_ = algorithm;
    }
    
    
    public String getAlgorithm() {
        return alg_;
    }
    
    
    public String getFormat() {
        return "RAW";
    }
    
    
    public byte[] getEncoded() {
        return (byte[])key_.clone();
    }


    public int hashCode() {
        // XXX todo...
        throw new RuntimeException("Method not yet implemented.");
    }
    
    
    public boolean equals(Object obj) {
        // XXX todo
        throw new RuntimeException("Method not yet implemented.");
    }
}
