/* $Id: KeyAgreement.java,v 1.1.1.1 1999/07/13 23:15:32 gelderen Exp $
 *
 * Copyright (C) 1995-1998 Systemics Ltd. 
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto;


import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;


public class KeyAgreement {
    
    private final KeyAgreementSpi spi_;
    private final Provider        provider_;
    private final String          algorithm_;
    
    
    protected KeyAgreement(KeyAgreementSpi keyAgreeSpi, Provider provider, String algorithm) {
        spi_       = keyAgreeSpi;
        provider_  = provider;
        algorithm_ = algorithm;
    }
    
    
    public final String getAlgorithm() {
        return algorithm_;
    }
    
    
    public static final KeyAgreement getInstance(String algorithm) 
    throws NoSuchAlgorithmException {
        
        Object[] o = Support.getImplementation("KeyAgreement", algorithm);
        return new KeyAgreement((KeyAgreementSpi)o[0], (Provider)o[1], algorithm);
    }
    
    
    public static final KeyAgreement getInstance(String algorithm, String provider)
    throws NoSuchAlgorithmException, NoSuchProviderException {

        Object[] o = Support.getImplementation("KeyAgreement", algorithm, provider);
        return new KeyAgreement((KeyAgreementSpi)o[0], (Provider)o[1], algorithm);
    }
    

    public final Provider getProvider() {
        return provider_;
    }
    
    
    public final void init(Key key)
    throws InvalidKeyException {
        spi_.engineInit(key, new SecureRandom());
    }
    
    
    public final void init(Key key, SecureRandom random)
    throws InvalidKeyException {
        spi_.engineInit(key, random);
    }
    
    
    public final void init(Key key, AlgorithmParameterSpec params)
    throws InvalidKeyException, InvalidAlgorithmParameterException {
        spi_.engineInit(key, params, new SecureRandom());
    }
    
    
    public final void init(Key key, AlgorithmParameterSpec params, SecureRandom random)
    throws InvalidKeyException, InvalidAlgorithmParameterException {
        spi_.engineInit(key, params, random);
    }
    
    
    public final Key doPhase(Key key, boolean lastPhase)
    throws InvalidKeyException, IllegalStateException {
        return spi_.engineDoPhase(key, lastPhase);
    }
    
    
    public final byte[] generateSecret() 
    throws IllegalStateException {
        return spi_.engineGenerateSecret();
    }
    
    
    public final int generateSecret(byte[] sharedSecret, int offset)
    throws IllegalStateException, ShortBufferException {
        return spi_.engineGenerateSecret(sharedSecret, offset);
    }
    
    
    public final SecretKey generateSecret(String algorithm)
    throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        return spi_.engineGenerateSecret(algorithm);
    }
}






