/* $Id: KeyAgreementSpi.java,v 1.1.1.1 1999/07/13 23:15:32 gelderen Exp $
 *
 * Copyright (C) 1995-1998 Systemics Ltd. 
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto;


import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;


public abstract class KeyAgreementSpi {
    
    protected abstract void engineInit(Key key, SecureRandom random)
    throws InvalidKeyException;
    
    
    protected abstract void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random)
    throws InvalidKeyException, InvalidAlgorithmParameterException;
    
    
    protected abstract Key engineDoPhase(Key key, boolean lastPhase)
    throws InvalidKeyException, IllegalStateException;
    
    
    protected abstract byte[] engineGenerateSecret() 
    throws IllegalStateException;
    
    
    protected abstract int engineGenerateSecret(byte[] sharedSecret, int offset)
    throws IllegalStateException, ShortBufferException;
    
    
    protected abstract SecretKey engineGenerateSecret(java.lang.String algorithm)
    throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException;
}






