/* $Id: KeyGenerator.java,v 1.1.1.1 1999/07/13 23:15:32 gelderen Exp $
 *
 * Copyright (C) 1995-1998 Systemics Ltd. 
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto;


import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;


public class KeyGenerator {
    
    private final KeyGeneratorSpi spi_;
    private final Provider        provider_;
    private final String          algorithm_;

    
    protected KeyGenerator(KeyGeneratorSpi keyGenSpi, Provider provider, String algorithm) {
        spi_       = keyGenSpi;
        provider_  = provider;
        algorithm_ = algorithm;
    }
    
    
    public final String getAlgorithm() {
        return algorithm_;
    }


    public static final KeyGenerator getInstance(String algorithm) 
    throws NoSuchAlgorithmException {

        Object[] o = Support.getImplementation("KeyGenerator", algorithm);
        return new KeyGenerator((KeyGeneratorSpi)o[0], (Provider)o[1], algorithm);
    }
    
    
    public static final KeyGenerator getInstance(String algorithm, String provider)
    throws NoSuchAlgorithmException, NoSuchProviderException {

        Object[] o = Support.getImplementation("KeyGenerator", algorithm, provider);
        return new KeyGenerator((KeyGeneratorSpi)o[0], (Provider)o[1], algorithm);
    }
    
    
    public final Provider getProvider() {
        return provider_;
    }
    
    
    public final void init(SecureRandom random) {
        spi_.engineInit(random);
    }
    
    
    public final void init(AlgorithmParameterSpec params)
    throws InvalidAlgorithmParameterException {
        spi_.engineInit(params, new SecureRandom());
    }
    
    
    public final void init(AlgorithmParameterSpec params, SecureRandom random)
    throws InvalidAlgorithmParameterException {
        spi_.engineInit(params, random);
    }
    
    
    public final void init(int strength) {
        spi_.engineInit(strength, new SecureRandom());
    }
    
    
    public final void init(int strength, SecureRandom random) {
        spi_.engineInit(strength, random);
    }
    
    
    public final SecretKey generateKey() {
        return spi_.engineGenerateKey();
    }
}    