/* $Id: SecretKeyFactory.java,v 1.1.1.1 1999/07/13 23:15:32 gelderen Exp $
 *
 * Copyright (C) 1995-1998 Systemics Ltd. 
 * on behalf of the Cryptix Development Team. All rights reserved.
 * 
 * Use, modification, copying and distribution of this software is subject 
 * the terms and conditions of the Cryptix General Licence. You should have 
 * received a copy of the Cryptix General License along with this library; 
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package javax.crypto;


import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;


public class SecretKeyFactory {
    
    private final SecretKeyFactorySpi spi_;
    private final Provider            provider_;
    private final String              algorithm_;
    
    
    protected SecretKeyFactory(SecretKeyFactorySpi keyFacSpi, Provider provider, String algorithm) {
        spi_       = keyFacSpi;
        provider_  = provider;
        algorithm_ = algorithm;
    }
    
    
    public static final SecretKeyFactory getInstance(String algorithm)
    throws NoSuchAlgorithmException {

        Object[] o = Support.getImplementation("SecretKeyFactory", algorithm);
        return new SecretKeyFactory((SecretKeyFactorySpi)o[0], (Provider)o[1], algorithm);
    }
    
    
    public static final SecretKeyFactory getInstance(java.lang.String algorithm, String provider)
    throws NoSuchAlgorithmException, NoSuchProviderException {

        Object[] o = Support.getImplementation("SecretKeyFactory", algorithm, provider);
        return new SecretKeyFactory((SecretKeyFactorySpi)o[0], (Provider)o[1], algorithm);
    }
    
    
    public final Provider getProvider() {
        return provider_;
    }


    public final String getAlgorithm() {
        return algorithm_;
    }
    
    
    public final SecretKey generateSecret(KeySpec keySpec)
    throws InvalidKeySpecException {
        return spi_.engineGenerateSecret(keySpec);
    }
    
    
    public final KeySpec getKeySpec(SecretKey key, Class keySpec) 
    throws InvalidKeySpecException {
        return spi_.engineGetKeySpec(key, keySpec);
    }
    
    
    public final SecretKey translateKey(SecretKey key)
    throws InvalidKeyException {
        return spi_.engineTranslateKey(key);
    }
    
    
}
