$CLUSHUT:
$	VER = F$VERIFY (0)
$	SET NOON
$	ON CONTROL_Y THEN $ GOTO EXIT
$!*****************************************************************************
$!***
$!***	CLUSHUT.COM	Version 1.2
$!***
$!***	This command procedure helps you shut down one or more nodes in
$!***	your cluster. You can specify a single node, a list of nodes, or
$!***	a class of nodes where a class is one of the following :
$!***
$!***	AXP_NODES, VAX_NODES, SATELITE_NODES, BOOT_NODES, ALL_NODES
$!***	VAX_SATELITES, AXP_SATELITES
$!***
$!***	The command procedure builds a list of node names based on the current
$!***	nodes in the cluster. The one problem with this command procedure is
$!***	that there is no good, completely transportable way to determine if a
$!***	cluster member is a boot server. So this is UP TO YOU!
$!***
$!***	WARNING !!!
$!***	___________
$!***
$!***	You must edit this file and change the first executable line to include
$!***	all of the BOOT SERVER nodes in your cluster. The node names must be
$!***	separated by commas. In this file the boot nodes are set to the nodes
$!***	KIRK, SPOCK, and MCCOY. YOU MUST CHANGE IT TO REFLECT YOUR CLUSTER. If
$!***	you only have one boot server in your cluster, just put it's name 
$!***	between the two double quotes.
$!***
$!***	Author :	Jeff Cameron
$!***			jcam90502@jcameron.com
$!***			http://www.jcameron.com/vms/
$!***
$!***	Modification History
$!***
$!***	Programmer	Date		Description
$!*** ----------------------------------------------------------------------
$!***	Jeff Cameron	02-SEP-1999	Initially written (1.0)
$!***	Jeff Cameron	28-SEP-1999	Fixed bug when specifying nodes 
$!***					 explicitly. (1.1)
$!***	Jeff Cameron	25-OCT-1999	Fixed problem when Reboot option is
$!***					 selected (1.2)
$!*** ----------------------------------------------------------------------
$!***
$!*****************************************************************************
$
$	BOOT_NODES = "KIRK,SPOCK,MCCOY"
$	ESCAPE[0,7] = 27
$	BON = ESCAPE + "[1m"
$	BOF = ESCAPE + "[m"
$
$	CONTEXT = ""
$	ALL_NODES = ""
$	AXP_NODES = ""
$	VAX_NODES = ""
$	SATELITE_NODES = ""
$	AXP_SATELITES = ""
$	VAX_SATELITES = ""
$
$NEXT_MEMBER:
$	CSID = F$CSID (CONTEXT)
$	IF (CSID .EQS. "") THEN $ GOTO END_LIST
$	CNAME = F$GETSYI("NODENAME",,CSID)
$	IF (.NOT. F$GETSYI("CLUSTER_MEMBER",CNAME)) THEN $ GOTO NEXT_MEMBER
$	ARCHNUM  = F$GETSYI("HW_MODEL",CNAME)
$	IF (ARCHNUM .GT. 1023)
$	THEN
$	    ARCH = "AXP"
$	ELSE
$	    ARCH = "VAX"
$	ENDIF
$
$	IF (ALL_NODES .EQS. "") 
$	THEN
$	    ALL_NODES = CNAME
$	ELSE
$	    ALL_NODES = ALL_NODES + "," + CNAME
$	ENDIF
$
$	IF (ARCH .EQS. "VAX")
$	THEN
$	    IF (VAX_NODES .EQS. "") 
$	    THEN
$		VAX_NODES = CNAME
$	    ELSE
$		VAX_NODES = VAX_NODES + "," + CNAME
$	    ENDIF
$	ELSE
$	    IF (AXP_NODES .EQS. "") 
$	    THEN
$		AXP_NODES = CNAME
$	    ELSE
$		AXP_NODES = AXP_NODES + "," + CNAME
$	    ENDIF
$	ENDIF
$
$	IF (F$LOCATE(CNAME,BOOT_NODES) .EQ. F$LENGTH(BOOT_NODES))
$	THEN
$	    IF (SATELITE_NODES .EQS. "") 
$	    THEN
$		SATELITE_NODES = CNAME
$	    ELSE
$		SATELITE_NODES = SATELITE_NODES + "," + CNAME
$	    ENDIF
$	    IF (ARCH .EQS. "VAX")
$	    THEN
$		IF (VAX_SATELITES .EQS. "") 
$		THEN
$		    VAX_SATELITES = CNAME
$		ELSE
$		    VAX_SATELITES = VAX_SATELITES + "," + CNAME
$		ENDIF
$	    ELSE
$		IF (AXP_SATELITES .EQS. "") 
$		THEN
$		    AXP_SATELITES = CNAME
$		ELSE
$		    AXP_SATELITES = AXP_SATELITES + "," + CNAME
$		ENDIF
$	    ENDIF
$	ELSE
$	ENDIF
$
$	GOTO NEXT_MEMBER
$
$END_LIST:
$
$	WRITE SYS$OUTPUT ">>> Cluster SHUTDOWN/REBOOT Utility <<<"
$ASK_MODE:
$	READ SYS$COMMAND/END=EXIT/PROMPT="Choose mode. [S]hutdown or [R]eboot [Default=S]" MODE 
$	IF (MODE .EQS. "") THEN $ MODE = "S"
$	MODE = F$EDIT (F$EXTRACT(0,1,MODE),"UPCASE")
$	IF (MODE .EQS. "S") THEN $ GOTO SHUTDOWN
$	IF (MODE .EQS. "R") THEN $ GOTO REBOOT
$	WRITE SYS$OUTPUT "Please choose ""S"" or ""R""."
$	GOTO ASK_MODE
$
$SHUTDOWN:
$	ACTION = "SHUTDOWN"
$	GOTO ASK_OPTS
$
$REBOOT:
$	ACTION = "REBOOT"
$	QUALS = ""
$	GOTO ASK_NODES
$
$ASK_OPTS:
$	READ SYS$COMMAND/END=EXIT/PROMPT="How many minutes until final shutdown [0]:" MIN
$	READ SYS$COMMAND/END=EXIT/PROMPT="Reason for shutdown [Standalone]:" REASON
$	READ SYS$COMMAND/END=EXIT/PROMPT="Do you want to spin down the disk volumes [NO]?" SPINDOWN
$	READ SYS$COMMAND/END=EXIT/PROMPT="Do you want to invoke the site-specific shutdown procedure [YES]?" INVOKE
$	READ SYS$COMMAND/END=EXIT/PROMPT="Should an automatic system reboot be performed [NO]?" REBOOT
$	READ SYS$COMMAND/END=EXIT/PROMPT="When will the system be rebooted [later]:" REBOOT_TIME
$	WRITE SYS$OUTPUT "Shutdown options (enter as a comma-separated list):"
$	WRITE SYS$OUTPUT " REMOVE_NODE         Remaining nodes in the cluster should adjust quorum"
$	WRITE SYS$OUTPUT " CLUSTER_SHUTDOWN    Entire cluster is shutting down"
$	WRITE SYS$OUTPUT " REBOOT_CHECK        Check existence of basic system files"
$	WRITE SYS$OUTPUT " SAVE_FEEDBACK       Save AUTOGEN feedback information from this boot"
$	WRITE SYS$OUTPUT " DISABLE_AUTOSTART   Disable autostart queues"
$!	WRITE SYS$OUTPUT " POWER_OFF           Request console to power-off the system"		! Not implemwnted yet
$	WRITE SYS$OUTPUT " "
$	READ SYS$COMMAND/END=EXIT/PROMPT="Shutdown options [NONE]:" OPTS
$	OPTS = F$EDIT (OPTS,"UPCASE")
$
$	IF (F$TYPE(MIN) .EQS. "STRING") THEN $ MIN = 0
$	QUALS = "/MINUTES=" + F$STRING(MIN)
$	IF (REASON .NES. "") THEN $ QUALS = QUALS + "/REASON=""" + REASON + """"
$	IF (F$EDIT(F$EXTRACT(0,1,SPINDOWN),"UPCASE") .EQS. "Y") THEN $ QUALS = QUALS + "/SPIN"
$	IF (F$EDIT(F$EXTRACT(0,1,INVOKE),"UPCASE") .EQS. "N") THEN $ QUALS = QUALS + "/NOINVOKE"
$	IF (F$EDIT(F$EXTRACT(0,1,REBOOT),"UPCASE") .EQS. "Y") THEN $ QUALS = QUALS + "/AUTO"
$	IF (F$TYPE(REBOOT_TIME) .EQS. "INTEGER") THEN $ REBOOT_TIME = F$STRING (REBOOT_TIME)
$	IF (REBOOT_TIME .NES. "") THEN $ QUALS = QUALS + "/REBOOT_TIME=""" + REBOOT_TIME + """"
$	IF (F$LOCATE("REM",OPTS) .NE. F$LENGTH(OPTS)) THEN $ QUALS = QUALS + "/REMOVE"
$	IF (F$LOCATE("CLU",OPTS) .NE. F$LENGTH(OPTS)) THEN $ QUALS = QUALS + "/CLUSTER"
$	IF (F$LOCATE("REB",OPTS) .NE. F$LENGTH(OPTS)) THEN $ QUALS = QUALS + "/REBOOT_CHECK"
$	IF (F$LOCATE("SAV",OPTS) .NE. F$LENGTH(OPTS)) THEN $ QUALS = QUALS + "/SAVE"
$	IF (F$LOCATE("DIS",OPTS) .NE. F$LENGTH(OPTS)) THEN $ QUALS = QUALS + "/DISABLE"
$!	IF (F$LOCATE("POW",OPTS) .NE. F$LENGTH(OPTS)) THEN $ QUALS = QUALS + "/POWER"		! Not implemented yest
$
$ASK_NODES:
$	WRITE SYS$OUTPUT "Please enter a list of nodes to ",ACTION," or use one of the"
$	WRITE SYS$OUTPUT "following node classes :"
$	WRITE SYS$OUTPUT "Node Class    |  Equivalent nodes"
$	WRITE SYS$OUTPUT "--------------+--------------------------------------------------------------"
$	WRITE SYS$OUTPUT BON,"ALL_NODES",BOF,"     | ",ALL_NODES
$	WRITE SYS$OUTPUT BON,"VAX_NODES",BOF,"     | ",VAX_NODES
$	WRITE SYS$OUTPUT BON,"AXP_NODES",BOF,"     | ",AXP_NODES
$	WRITE SYS$OUTPUT BON,"BOOT_NODES",BOF,"    | ",BOOT_NODES
$	WRITE SYS$OUTPUT BON,"SATELITE_NODES",BOF,"| ",SATELITE_NODES
$	WRITE SYS$OUTPUT BON,"AXP_SATELITES",BOF," | ",AXP_SATELITES
$	WRITE SYS$OUTPUT BON,"VAX_SATELITES",BOF," | ",VAX_SATELITES
$	WRITE SYS$OUTPUT "--------------+--------------------------------------------------------------"
$	WRITE SYS$OUTPUT "Entering just a Return or the word ""EXIT"" will terminate this procedure."
$	READ SYS$COMMAND/END=EXIT/PROMPT="Nodes:" LIST
$
$	IF (LIST .EQS. "") THEN $ GOTO EXIT
$	LIST = F$EDIT (LIST,"UPCASE")
$	IF (LIST .EQS. "EXIT") THEN $ GOTO EXIT
$
$	IF (LIST .EQS. "ALL_NODES") THEN       $ GOTO ALL_NODES
$	IF (LIST .EQS. "VAX_NODES") THEN       $ GOTO VAX_NODES
$	IF (LIST .EQS. "AXP_NODES") THEN       $ GOTO AXP_NODES
$	IF (LIST .EQS. "BOOT_NODES") THEN      $ GOTO BOOT_NODES
$	IF (LIST .EQS. "SATELITE_NODES") THEN $ GOTO SATELITE_NODES
$	IF (LIST .EQS. "AXP_SATELITES") THEN  $ GOTO AXP_SATELITES
$	IF (LIST .EQS. "VAX_SATELITES") THEN  $ GOTO VAX_SATELITES
$
$!***	Entered string must be a single node or a list separated by commas
$	IF (F$LOCATE (",",LIST) .NE. F$LENGTH (LIST)) THEN $ GOTO NODE_LIST
$
$!***	We have a single node specified. Is it in our list of all nodes
$	IF (F$LOCATE(LIST,ALL_NODES) .NE. F$LENGTH(ALL_NODES)) 
$	THEN 
$	    NODE_LIST = LIST
$	    GOTO LIST_DONE
$	ELSE
$	ENDIF
$
$	WRITE SYS$OUTPUT "Specified node (",LIST,") is not a current active node."
$	WRITE SYS$OUTPUT "Current active nodes are :"
$	WRITE SYS$OUTPUT ALL_NODES
$	WAIT 00:00:04
$	WRITE SYS$OUTPUT ""
$	GOTO ASK_NODES
$
$NODE_LIST:
$	INDEX = 0
$	ERRORS = 0
$NEXT_NODE_ELEMENT:
$	TEST_NODE = F$ELEMENT (INDEX,",",LIST)
$	IF (TEST_NODE .EQS. ",") THEN $ GOTO LIST_CHECKED
$	IF (F$LOCATE(TEST_NODE,ALL_NODES) .EQ. F$LENGTH(ALL_NODES))
$	THEN
$	    ERRORS = ERRORS + 1
$	    WRITE SYS$OUTPUT ERRORS,":Specified node (",TEST_NODE,") is not a current active node."
$	ELSE
$	ENDIF
$	INDEX = INDEX + 1
$	GOTO NEXT_NODE_ELEMENT
$
$LIST_CHECKED:
$	IF (ERRORS .GT. 0)
$	THEN
$	    WRITE SYS$OUTPUT "Current active nodes are :"
$	    WRITE SYS$OUTPUT ALL_NODES
$	    WAIT 00:00:04
$	    WRITE SYS$OUTPUT ""
$	    GOTO ASK_NODES
$	ELSE
$	ENDIF
$	NODE_LIST = LIST
$	GOTO LIST_DONE
$
$ALL_NODES:
$	NODE_LIST = ALL_NODES
$	GOTO LIST_DONE
$
$VAX_NODES:
$	NODE_LIST = VAX_NODES
$	GOTO LIST_DONE
$
$AXP_NODES:
$	NODE_LIST = AXP_NODES
$	GOTO LIST_DONE
$
$BOOT_NODES:
$	NODE_LIST = BOOT_NODES
$	GOTO LIST_DONE
$
$SATELITE_NODES:
$	NODE_LIST = SATELITE_NODES
$	GOTO LIST_DONE
$
$AXP_SATELITES:
$	NODE_LIST = AXP_SATELITES
$	GOTO LIST_DONE
$
$VAX_SATELITES:
$	NODE_LIST = VAX_SATELITES
$	GOTO LIST_DONE
$
$LIST_DONE:
$
$	WRITE SYS$OUTPUT "SYSMAN COMMANDS :"
$	WRITE SYS$OUTPUT "SYSMAN>SET ENVIRONMENT/NODE=(",NODE_LIST,")"
$	WRITE SYS$OUTPUT "SYSMAN>",ACTION," NODE",QUALS
$	WRITE SYS$OUTPUT "SYSMAN>EXIT"
$
$	WRITE SYS$OUTPUT ""
$YORN:
$	INQUIRE YORN "Do you want to execute these commands (Y or N) [Y]"
$	IF (YORN .EQS. "") THEN $ GOTO DOIT
$	YORN = F$EXTRACT(0,1,F$EDIT(YORN,"UPCASE"))
$	IF (YORN .EQS. "Y") THEN $ GOTO DOIT
$	IF (YORN .EQS. "N") THEN $ GOTO EXIT
$	WRITE SYS$OUTPUT "Please enter ""Y"" or ""N""."
$	GOTO YORN
$
$DOIT:
$	OPEN/WRITE CLUSHUT_SYSMAN_FILE SYS$DISK:[]CLUSHUT_SYSMAN_COMMANDS.TMP
$	WRITE CLUSHUT_SYSMAN_FILE "SET ENVIRONMENT/NODE=(",NODE_LIST,")"
$	WRITE CLUSHUT_SYSMAN_FILE  ACTION," NODE",QUALS
$	WRITE CLUSHUT_SYSMAN_FILE "EXIT"
$	CLOSE CLUSHUT_SYSMAN_FILE
$
$	DEFINE/USER SYS$INPUT SYS$DISK:[]CLUSHUT_SYSMAN_COMMANDS.TMP
$	MCR SYSMAN
$
$	DELETE SYS$DISK:[]CLUSHUT_SYSMAN_COMMANDS.TMP;*
$
$EXIT:
$	VER = F$VERIFY (VER)
$	EXIT
