CLast Modified:  16-JUN-1988 09:33:55.48 by WILTSC****************************************************************************      INTEGER*4  FUNCTION  f$parse (file_spec, default_spec,     +                              related_spec, field, parse_type,     +                              result)C****************************************************************************CC      Function F$PARSE emulates the DCL lexical function, "F$PARSE",C      using the RMS SYS$PARSE service.  Given a file specification,C      F$PARSE will expand the file specification, translating logicalC      names and filling in defaults for missing fields.  The fully-C      expanded file specification, or parts of it if specified, areC      returned to the calling routine.  See the section on lexicalC      functions in the VAX/VMS DCL Dictionary for more informationC      about "F$PARSE".CC      NOTE that although the input arguments are declared as recordsC      of type descriptor, you should pass them in as CHARACTER strings.C      This was necessary to allow F$PARSE to detect null arguments.C      The descriptor type chosen, "DSCDEF1", was as close as I couldC      get to a character string descriptor type.CC      Because old implementations of FORTRAN-stored characters stringC      as byte arrays instead of as descriptors, there is an ambiguityC      in passing literal strings (quoted strings) to FORTRANC      subroutines. The string may be passed either by descriptor or byC      reference, depending on the format expected by the CALLED program.C      This unusual circumstance means that subroutines such as thisC      one will be treated specially by the VAX linker; it actuallyC      checks the type of the argument in the called program and linksC      the program dependent upon that type. In the case of F$PARSE, theC      called program is expecting records that normally are passed byC      reference, so the VAX linker generates code to pass your literalC      strings by reference. This would yield an incorrect result. ToC      avoid this difficulty, which occurs only with literalsC      (descriptors, or CHARACTER variables, are passed correctly), youC      should use the %DESCR directive in your FORTRAN programs. If youC      must call F$PARSE using a string literal, use the followingC      format:cc         CALL f$parse(%DESCR('my_file'),,,,result)cC      NOTE that you better appreciate the work that went into thisC      routine, aside from debugging the literal string bug above.C      There is no clear information about how to use SYS$PARSE inC      the VAX/VMS RMS Reference Manual.  I had the routine partiallyC      working when I finally found some information in the Guide toC      VAX/VMS File Applications, Chapter 5, "Advanced Use of FileC      Specifications".CC      Arguments (see the NOTE above about arguments of type CHARACTER):CC            FILE_SPEC  (Character)CC                  The primary file specification being parsed.  ThisC                  argument may be null (unlike the DCL function whereC                  it is required); if not specified, the default andC                  related file specifications are applied as usual toC                  a blank, primary file name.CC            DEFAULT_SPEC  (Character)CC                  The default file specification.  If the default fileC                  specification is specified (this argument may beC                  null), it is "applied" to the expanded, primary fileC                  specification (see the PURPOSE section above).CC            RELATED_SPEC  (Character)CC                  The related file specification.  If the related fileC                  specification is specified (this argument may beC                  null), it is "applied" to the expanded, primary/defaultC                  file specification (see the PURPOSE section above).CC            FIELD  (Character)CC                  Designates the field in the expanded fileC                  specification that you want returned to you:CC                        "NODE"C                        "DEVICE"C                        "DIRECTORY"C                        "NAME"C                        "TYPE"C                        "VERSION"CC                  If this argument is null (or is an invalid fieldC                  name), the entire, fully-expanded file specificationC                  is returned to the calling routine.CC            PARSE_TYPE  (Character)CC                  Specifies the type of parse to perform.  There areC                  two options:CC                        "NO_CONCEAL" reveals concealed logical names.CC                        "SYNTAX_ONLY" does not verify that the deviceC                              and directory in the fully-expanded fileC                              specification actually exist.C            RESULT  (Character)CC                  Returns the parsed file specification.  If a desiredC                  field is not specified (null FIELD argument), theC                  entire, fully-expanded file specification is returnedC                  to the calling routine.  Otherwise, only the specifiedC                  field is returned to the calling routine:CC                        "NODE"		returns "<node>::" (usually null)C                        "DEVICE"	returns "<disk>:"C                        "DIRECTORY"	returns "[<directory>]"C                        "NAME"		returns "<file name>"C                        "TYPE"		returns ".<extension>"C                        "VERSION"	returns ";<number>" (";" if noC                                                            version number)C            F$PARSE  (Function Value)CC                  Returns the VAX/VMS status code returned by SYS$PARSE.C                  There are actually two calls to SYS$PARSE, one toC                  parse the related file specification and a second toC                  parse the primary file specification.  An error inC                  either parse operation is immediately returned toC                  the calling routine.  A disk or directory not foundC                  error could be returned if you didn't specifyC                  "SYNTAX_ONLY".  RMS$_NORMAL is returned if thereC                  are no errors.CC****************************************************************************      IMPLICIT  NONEC...      Parameters and external definitions.      INCLUDE '($DSCDEF)'		! Descriptor type definitions.      INCLUDE '($FABDEF)'		! RMS File Access Block (FAB) and      INCLUDE '($NAMDEF)'		!  name block field definitions.      INCLUDE '($SYSSRVNAM)'		! VMS system service entry points.C...      Subroutine arguments.      RECORD /DSCDEF1/  file_spec	! Character string.      RECORD /DSCDEF1/  default_spec	! Character string.      RECORD /DSCDEF1/  related_spec	! Character string.      RECORD /DSCDEF1/  field		! Character string.      RECORD /DSCDEF1/  parse_type	! Character string.      CHARACTER*(*)  resultC...      Local variables.      CHARACTER*16  field_name, type_of_parse      CHARACTER*(NAM$C_MAXRSS)  expanded_string, rlf_expanded_string      INTEGER*4  length, nop, status      RECORD  /FABDEF/  fab		! RMS file access block.      RECORD  /NAMDEF/  nam		! RMS name block.      RECORD  /NAMDEF/  rlf		! RMS related file name block.      result = ' '		! Return blank result in case of error.C...      Copy the field name and parse type strings into localC      character strings.      IF (%LOC (field) .EQ. 0) THEN          field_name = ' '      ELSE          CALL LIB$MOVC5 (field.DSC$W_MAXSTRLEN,     +                    %VAL(field.DSC$A_POINTER), %REF(' '),     +                    LEN(field_name), %REF(field_name))      ENDIF      IF (%LOC (parse_type) .EQ. 0) THEN          type_of_parse = ' '      ELSE          CALL LIB$MOVC5 (parse_type.DSC$W_MAXSTRLEN,     +                    %VAL(parse_type.DSC$A_POINTER), %REF(' '),     +                    LEN(type_of_parse), %REF(type_of_parse))      ENDIFC...      Parse the related file specification.  Do not expand concealedC      logical names and don't verify that its directory exists.      IF (%LOC (related_spec) .NE. 0) THEN          CALL LIB$MOVC5 (0, 0, 0, FAB$C_BLN, fab)	! Zero all fields.          fab.FAB$B_BID = FAB$C_BID			! Block identifier.          fab.FAB$B_BLN = FAB$C_BLN			! Block length.          fab.FAB$L_FOP = FAB$M_NAM			! File-proc. options.          fab.FAB$L_NAM = %LOC (rlf)			! Name block address.          fab.FAB$L_FNA = related_spec.DSC$A_POINTER	! File name.          CALL LIB$MOVC3 (1, related_spec.DSC$W_MAXSTRLEN,     +                    fab.FAB$B_FNS)          CALL LIB$MOVC5 (0, 0, 0, NAM$C_BLN, rlf)	! Zero all fields.          rlf.NAM$B_BID = NAM$C_BID			! Block identifier.          rlf.NAM$B_BLN = NAM$C_BLN			! Block length.          rlf.NAM$B_NOP = NAM$M_SYNCHK			! Name block options.          rlf.NAM$L_ESA = %LOC (rlf_expanded_string)	! Expanded string.          rlf.NAM$B_ESS = NAM$C_MAXRSS          status = SYS$PARSE (fab)          IF (.NOT. status) THEN              f$parse = status              RETURN          ENDIF          rlf.NAM$L_RSA = rlf.NAM$L_ESA			! Resultant string.          rlf.NAM$B_RSL = rlf.NAM$B_ESL      ENDIFC...      Parse the main file specification, applying the default andC      related file specifications.      CALL LIB$MOVC5 (0, 0, 0, FAB$C_BLN, fab)		! Zero all fields.      fab.FAB$B_BID = FAB$C_BID				! Block identifier.      fab.FAB$B_BLN = FAB$C_BLN				! Block length.      fab.FAB$L_FOP = FAB$M_NAM				! File-proc. options.      fab.FAB$L_NAM = %LOC (nam)			! Name block address.      IF (%LOC (file_spec) .NE. 0) THEN          fab.FAB$L_FNA = file_spec.DSC$A_POINTER	! File name.          CALL LIB$MOVC3 (1, file_spec.DSC$W_MAXSTRLEN, fab.FAB$B_FNS)      ENDIF      IF (%LOC (default_spec) .NE. 0) THEN          fab.FAB$L_DNA = default_spec.DSC$A_POINTER	! Default file spec.          CALL LIB$MOVC3 (1, default_spec.DSC$W_MAXSTRLEN,     +                    fab.FAB$B_DNS)      ENDIF      CALL LIB$MOVC5 (0, 0, 0, NAM$C_BLN, nam)		! Zero all fields.      nam.NAM$B_BID = NAM$C_BID				! Block identifier.      nam.NAM$B_BLN = NAM$C_BLN				! Block length.      IF (type_of_parse .EQ. 'NO_CONCEAL') THEN		! Expand concealed          nam.NAM$B_NOP = NAM$M_NOCONCEAL		!  logical names.      ELSEIF (type_of_parse .EQ. 'SYNTAX_ONLY') THEN	! Don't verify that          nam.NAM$B_NOP = NAM$M_SYNCHK			!  directory exists.      ENDIF      IF (%LOC (related_spec) .NE. 0)			! Related file name     +    nam.NAM$L_RLF = %LOC (rlf)			!  block address.      nam.NAM$L_ESA = %LOC (expanded_string)		! Expanded string.      nam.NAM$B_ESS = NAM$C_MAXRSS      status = SYS$PARSE (fab)      IF (.NOT. status) THEN          f$parse = status          RETURN      ENDIFC...      Return the desired field.  The completely expanded fileC      specification is stored by RMS in EXPANDED_STRING; the lengthsC      and addresses of the individual fields are available in the nameC      block.      IF (field_name .EQ. 'NODE') THEN          length = ZEXT (nam.NAM$B_NODE)          CALL LIB$MOVC5 (length, %VAL(nam.NAM$L_NODE), %REF(' '),     +                    LEN(result), %REF(result))      ELSEIF (field_name .EQ. 'DEVICE') THEN          length = ZEXT (nam.NAM$B_DEV)          CALL LIB$MOVC5 (length, %VAL(nam.NAM$L_DEV), %REF(' '),     +                    LEN(result), %REF(result))      ELSEIF (field_name .EQ. 'DIRECTORY') THEN          length = ZEXT (nam.NAM$B_DIR)          CALL LIB$MOVC5 (length, %VAL(nam.NAM$L_DIR), %REF(' '),     +                    LEN(result), %REF(result))      ELSEIF (field_name .EQ. 'NAME') THEN          length = ZEXT (nam.NAM$B_NAME)          CALL LIB$MOVC5 (length, %VAL(nam.NAM$L_NAME), %REF(' '),     +                    LEN(result), %REF(result))      ELSEIF (field_name .EQ. 'TYPE') THEN          length = ZEXT (nam.NAM$B_TYPE)          CALL LIB$MOVC5 (length, %VAL(nam.NAM$L_TYPE), %REF(' '),     +                    LEN(result), %REF(result))      ELSEIF (field_name .EQ. 'VERSION') THEN          length = ZEXT (nam.NAM$B_VER)          CALL LIB$MOVC5 (length, %VAL(nam.NAM$L_VER), %REF(' '),     +                    LEN(result), %REF(result))      ELSE	! Return the complete file specification.          length = ZEXT (nam.NAM$B_ESL)          result = EXPANDED_STRING(1:length)      ENDIF      f$parse = status      RETURN      END