/**
*	Jason Rohrer
*	7-5-99
*	Key generation piece of HardEncrypt package
*
*	mods:
*		7-15-99:  Jason Rohrer
*					added failed allocation detection
*
*
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>


#if __dest_os == __mac_os		// include the macOS metrowerks SIOUX library to control the console window
	#include <SIOUX.h>			// not needed on OS's that have a built-in console
#endif



// prototypes
inline long XOR( long A, long B);
void setupConsole(void);


#if __dest_os == __mac_os
	void setupConsole() {
		// Don't ask to save output on quit
		SIOUXSettings.asktosaveonclose = FALSE;
		}
#else
	void setupConsole() {
		}
#endif



int main() {
//void main () {

	setupConsole();		// setup the console as needed per platform (especially needed for mac...)
	
	printf(".oO()   HardenedCriminal Software (TM)   ()Oo.\n\n");
	printf("HardEncrypt Package   (c)1999 Little  (open source, end to tyranny)\n");
	printf("GenKeyFile:  hardcore seeded keyfile generator\n");
	
	
	srand((unsigned)time( NULL ));		// seed the pseudo-random number generator

	int quit = 0;
	
	unsigned char *keyFileName = new unsigned char[99];
	unsigned char *seedFileName = new unsigned char[99];
	unsigned char *badInputBuffer = new unsigned char[99];
	
	FILE *keyFile = NULL;
	FILE *seedFile = NULL;
	
	int sizeOfKey = 0;
	
	
	// loop until a good key file is opened
	while( keyFile == NULL && !quit ) {
		printf("\nEnter name of key file: ");
		scanf("%98s", keyFileName);
		
		if( (keyFileName[0] == 'q' || keyFileName[0] == 'Q') && keyFileName[1] == '\0' ) {
			quit = 1;
			break;
			}
		
		keyFile = fopen((const char*)keyFileName, "wb");
		if( keyFile == NULL ) {
			printf("\nERROR:  can't open key file %s\n", keyFileName);
			}
		}
	
	
	// loop until a good seed file is opened
	while( seedFile == NULL && !quit ) {
		printf("\nEnter name of seed file:  ");
		scanf("%98s", seedFileName);
		
		if( (seedFileName[0] == 'q' || seedFileName[0] == 'Q') && seedFileName[1] == '\0' ) {
			quit = 1;
			break;
			}
		
		seedFile = fopen((const char*)seedFileName, "rb");
		if( seedFile == NULL ) {
			printf("\nERROR:  can't open seed file %s\n", seedFileName);
			}
		
		}
	
	
	
	
	
	if( !quit ) {
		
		int numSuccessfulRead = 0;		// number of integers read from user console input
		
		// loop until a proper size of key file entered
		while( numSuccessfulRead == 0 ) {
		
			printf("\nEnter size of key file (in bytes): ");
			numSuccessfulRead = scanf("%d", &sizeOfKey);
			
			if( numSuccessfulRead == 0) {
				scanf("%98s", &badInputBuffer);
				printf("\nERROR:  must input a whole, positive number\n");
				}
			else if(sizeOfKey <= 0) {
				printf("\nERROR:  must input a whole, positive number\n");
				numSuccessfulRead = 0;
				}
			}
		

		int sizeBuff = 5000;
	
		int halfSizeBuff = sizeBuff/2;
		
		int numKeyBytesWritten = 0;
		int numSeedBytesRead = sizeBuff;
		

		unsigned char *keyFileBuffer = new unsigned char[sizeBuff];		// store written key file bytes
		unsigned char *seedFileBuffer = new unsigned char[sizeBuff];	// store read seed file bytes
		char *seedByteUsedBuffer = new char[sizeBuff];					// store used seed byte flags

		// check for failed memory alocation
		if( keyFileBuffer == NULL || seedFileBuffer == NULL || seedByteUsedBuffer == NULL) {
			printf("\nERROR:  not enough memory to allocate the file read-write buffers.\n");
			printf("Free up memory or increase GenKeyFile's partition and try again.\n");
			}
		else {
		
			// write out random key
		
			char seedFileGoodSoFar = true;		// does seed file seem to contain random, well-distributed data?
		
			long totalBytesWritten = 0;
			long totalBytesRead = 0;
		
			int sizeLastRead = 0;
		
			unsigned long startTime = (unsigned)time( NULL );
			unsigned long netTime;
		
		
			int currentSeedBuffIndex = 0;

			int numUnsuccessfulRandJumps = 0;
			int maxUnsuccessfulRandJumps = sizeBuff;	// walk linearly after how many unsuccessful rand jumps?
		
		
			for(int i=0; i<=sizeOfKey; i++) {
			
				if( numSeedBytesRead < sizeBuff ) {			// read next byte from seed file buffer
					// jump pseudo-randomly until an not-yet used spot found
					while (seedByteUsedBuffer[currentSeedBuffIndex] == true) {
						if( numUnsuccessfulRandJumps < maxUnsuccessfulRandJumps ) {
					
							currentSeedBuffIndex += rand();
							currentSeedBuffIndex = currentSeedBuffIndex % sizeLastRead;
					
							numUnsuccessfulRandJumps ++;
							}
						
						else {			// too many bad rand jumps
							// walk linearly until a good seed byte is found
							while (seedByteUsedBuffer[currentSeedBuffIndex] == true) {
								currentSeedBuffIndex++;
								currentSeedBuffIndex = currentSeedBuffIndex % sizeLastRead;
								}
							numUnsuccessfulRandJumps = 0;
							}
		
						}
					numUnsuccessfulRandJumps = 0;
					keyFileBuffer[numKeyBytesWritten] = seedFileBuffer[currentSeedBuffIndex];
			
					seedByteUsedBuffer[currentSeedBuffIndex] = true;	// set dirty flag of seed byte
		
					numKeyBytesWritten++;
					numSeedBytesRead++;
					}
			

		
				if( numKeyBytesWritten ==  sizeBuff) {	// buffer is ready to go out to keyfile
				
					// pad buffer with pseudo-random values to "get rid of" bad sections
					for( int k=0; k<sizeBuff; k++) {
						keyFileBuffer[k] = XOR( keyFileBuffer[k], (255*rand())/RAND_MAX );
						}
				
					int sizeWrite = fwrite( (void*)keyFileBuffer, sizeof(char), numKeyBytesWritten, keyFile); 
					if( sizeWrite != numKeyBytesWritten ) {
						printf("\nERROR:  key file failed to be written.\n");
						printf("Key file is incomplete\n");
						i = sizeOfKey;			// jump out of while loop
						}
				
					totalBytesWritten += sizeWrite;
				
						
					// seed the rand generator with a key file value
					//  (concatonated value of 4 key file values)
					short tempSeedIndex = rand() % numKeyBytesWritten;
					short tempSeedIndex2 = rand() % numKeyBytesWritten;
					short tempSeedIndex3 = rand() % numKeyBytesWritten;
					short tempSeedIndex4 = rand() % numKeyBytesWritten;
					unsigned long tempSeed = keyFileBuffer[ tempSeedIndex ] 
											| keyFileBuffer[tempSeedIndex2] <<8
											| keyFileBuffer[tempSeedIndex2] <<16
											| keyFileBuffer[tempSeedIndex2] <<24;
					srand( tempSeed );
					numKeyBytesWritten = 0;
					}
						
		
				if( numSeedBytesRead == sizeBuff ) {	// time to read in a new seed buffer
			
					numSeedBytesRead = 0;
					sizeLastRead = fread( (void*)seedFileBuffer, sizeof(char), sizeBuff, seedFile); 
				
					if( sizeLastRead < sizeBuff ) {
						if( sizeLastRead < sizeOfKey - i) {		// not enough seed bytes remaining
							printf("\nERROR:  seed file must be at least as large as the desired key file.\n");
							printf("Key file is incomplete\n");
							i = sizeOfKey;			// jump out of while loop
							}
						}

					totalBytesRead += sizeLastRead;
				
					// set dirty flag buffer to false
					for(int k=0; k<sizeBuff; k++) {
						seedByteUsedBuffer[k] = false;
						}
				
					if( seedFileGoodSoFar ) {	
						// check for an entire block of the same byte
						// warn user if such a block exists	
						unsigned char repeatedByte;
						char byteIsRepeated = true;
						if( sizeLastRead > 0) {
							repeatedByte = seedFileBuffer[0];
							}
						for(int j=0; j<sizeLastRead; j++) {
							// check if the byte is repeated
							byteIsRepeated = byteIsRepeated && (seedFileBuffer[j] == repeatedByte);
							}
						if( byteIsRepeated ) {		// print warning message
							printf("\nWARNING:  this seed file contains one (or more) 5kB block(s) of the same, repeated byte.\n");
							printf("The key file will not be completely secure.\n");
							printf("Try using a more random seed file.\n");
							seedFileGoodSoFar = false;
							}
						}
					
					
					// reset the jump point in the seed buffer
					currentSeedBuffIndex = (rand() * sizeLastRead)/RAND_MAX;
					}
			
				}
			
		
			// in each iteration of the above for loop, one byte was written into the keyFileBuffer
			// and after each set of sizeBuff bytes, the buffer was written to file
			// now need to dump the last buffer to file	
		
			// pad buffer with pseudo-random values to "get rid of" bad sections
			for( int k=0; k<sizeBuff; k++) {		
				keyFileBuffer[k] = XOR( keyFileBuffer[k], rand() );	
				}
		
			int sizeWrite = fwrite( (void*)keyFileBuffer, sizeof(char), numKeyBytesWritten, keyFile); 
			if( sizeWrite != numKeyBytesWritten ) {
				printf("\nERROR:  key file failed to be written.\n");
				printf("Key file is incomplete\n");
				}	
			totalBytesWritten += sizeWrite;

		
		
			// print closing status messages
			printf("\n%d bytes read from the seed file.\n", totalBytesRead);
			printf("\n%d bytes written to the key file.\n", totalBytesWritten);
		
			netTime = (unsigned)time( NULL ) - startTime;
			printf("\n%d seconds elapsed.\n", netTime);
		
		
			delete [] keyFileBuffer;
			delete [] seedFileBuffer;
			delete [] seedByteUsedBuffer;
		
			printf("\nDone writing key file.\n");
			}
		
		
		}
	
	if(keyFile != NULL )  fclose(keyFile);		// close files
	if(seedFile != NULL ) fclose(seedFile);
	
	
	delete [] keyFileName;
	delete [] seedFileName;
	delete [] badInputBuffer;
	
	}	
		
		


inline long XOR( long A, long B) {
	return (~(A & B)) & (A | B);
	}
			