/**
*	Jason Rohrer
*	7-5-99
*	Key generation piece of HardEncrypt package
*
*	mods:
*		7-15-99:  Jason Rohrer
*					added failed allocation detection
*		8-22-99:  Jason Rohrer
*					removed precompiler directives (#if, #endif) to
*					improve multiplatform compilability
*		8-23-99:  Jason Rohrer
*					added support for outputting multiple key files
*					in one session.  (i.e., "Enter number of key files to output:")
*		8-27-99:  Jason Rohrer
*					Fixed portability problem with rand() usage.
*					255*rand() causes overflow on platforms with a 32-bit RAND_MAX
*
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>






// prototypes
inline long XOR( long A, long B);



int main() {
//void main () {
	
	printf(".oO()   HardenedCriminal Software (TM)   ()Oo.\n\n");
	printf("HardEncrypt Package   (c)1999 Little  (open source, end to tyranny)\n");
	printf("GenKeyFile:  hardcore seeded keyfile generator\n");
	printf("Version 1.1\n");
	
	
	srand((unsigned)time( NULL ));		// seed the pseudo-random number generator

	int quit = 0;
	
	unsigned char *keyFileName = new unsigned char[99];
	unsigned char *seedFileName = new unsigned char[99];
	unsigned char *badInputBuffer = new unsigned char[99];
	
	FILE *keyFile = NULL;
	FILE *seedFile = NULL;
	
	int numberOfKeys = 0;
	int sizeOfKey = 0;
	
	int numSuccessfulRead = 0;		// number of integers read from user console input
	
	// loop until a proper number of key files are entered
	while( numSuccessfulRead == 0 ) {
		
		printf("\nEnter number of key files to make: ");
		numSuccessfulRead = scanf("%d", &numberOfKeys);
			
		if( numSuccessfulRead == 0) {
			scanf("%98s", &badInputBuffer);
			printf("\nERROR:  must input a whole, positive number\n");
			}
		else if(numberOfKeys <= 0) {
			printf("\nERROR:  must input a whole, positive number\n");
			numSuccessfulRead = 0;
			}
		}
	
	// loop until good key postfix is entered
	char keyFileOpened = false;
	while( !keyFileOpened && !quit ) {
		printf("\nEnter postfix name for key files (i.e. myKeyFile): ");
		scanf("%98s", keyFileName);
		
		if( (keyFileName[0] == 'q' || keyFileName[0] == 'Q') && keyFileName[1] == '\0' ) {
			quit = 1;
			break;
			}
		else if( keyFileName[0] != '\0') {		// make sure user enters something
			keyFileOpened = true;
			}
		}
	
	
	// loop until a good seed file is opened
	while( seedFile == NULL && !quit ) {
		printf("\nEnter name of seed file:  ");
		scanf("%98s", seedFileName);
		
		if( (seedFileName[0] == 'q' || seedFileName[0] == 'Q') && seedFileName[1] == '\0' ) {
			quit = 1;
			break;
			}
		
		seedFile = fopen((const char*)seedFileName, "rb");
		if( seedFile == NULL ) {
			printf("\nERROR:  can't open seed file %s\n", seedFileName);
			}
		
		}
	
	
	
	
	
	if( !quit ) {
		
		numSuccessfulRead = 0;		// number of integers read from user console input
		
		// loop until a proper size of key file entered
		while( numSuccessfulRead == 0 ) {
		
			printf("\nEnter size of each key file (in bytes): ");
			numSuccessfulRead = scanf("%d", &sizeOfKey);
			
			if( numSuccessfulRead == 0) {
				scanf("%98s", &badInputBuffer);
				printf("\nERROR:  must input a whole, positive number\n");
				}
			else if(sizeOfKey <= 0) {
				printf("\nERROR:  must input a whole, positive number\n");
				numSuccessfulRead = 0;
				}
			}
		

		int sizeBuff = 5000;
	
		int halfSizeBuff = sizeBuff/2;
		
		int numKeyBytesWritten = 0;
		int numSeedBytesRead = sizeBuff;
		

		unsigned char *keyFileBuffer = new unsigned char[sizeBuff];		// store written key file bytes
		unsigned char *seedFileBuffer = new unsigned char[sizeBuff];	// store read seed file bytes
		char *seedByteUsedBuffer = new char[sizeBuff];					// store used seed byte flags

		// check for failed memory alocation
		if( keyFileBuffer == NULL || seedFileBuffer == NULL || seedByteUsedBuffer == NULL) {
			printf("\nERROR:  not enough memory to allocate the file read-write buffers.\n");
			printf("Free up memory or increase GenKeyFile's partition and try again.\n");
			}
		else {
		
			// write out random key
		
			char seedFileGoodSoFar = true;		// does seed file seem to contain random, well-distributed data?
		
			long totalBytesWritten = 0;
			long totalBytesRead = 0;
		
			int sizeLastRead = 0;
		
			unsigned long startTime = (unsigned)time( NULL );
			unsigned long netTime;
		
		
			int currentSeedBuffIndex = 0;

			int numUnsuccessfulRandJumps = 0;
			int maxUnsuccessfulRandJumps = sizeBuff;	// walk linearly after how many unsuccessful rand jumps?
		
			for(int n=0; n<numberOfKeys; n++) {			// for each key file
				numKeyBytesWritten = 0;				// number of bytes written into the current key file buffer
				int currentKeyBytesWritten = 0;		// number of bytes written for the current key file
				
				// open the file
				keyFile = NULL;
				char *eachFileName = new char[120];			// array to hold numbered file name
				sprintf(eachFileName, "%d%s", n, keyFileName);
				keyFile = fopen((const char*)eachFileName, "wb");
				if( keyFile == NULL ) {
					printf("\nERROR:  can't open key file %s\n", eachFileName);
					keyFileOpened = false;			
					currentKeyBytesWritten = sizeOfKey;		// skip this file
					}
				delete [] eachFileName;
				
				// now write this key file
				while( currentKeyBytesWritten < sizeOfKey ) {
				
					if( numSeedBytesRead < sizeBuff ) {			// read next byte from seed file buffer
						// jump pseudo-randomly until an not-yet used spot found
						while (seedByteUsedBuffer[currentSeedBuffIndex] == true) {
							if( numUnsuccessfulRandJumps < maxUnsuccessfulRandJumps ) {
						
								currentSeedBuffIndex += rand();
								currentSeedBuffIndex = currentSeedBuffIndex % sizeLastRead;
						
								numUnsuccessfulRandJumps ++;
								}
							
							else {			// too many bad rand jumps
								// walk linearly until a good seed byte is found
								while (seedByteUsedBuffer[currentSeedBuffIndex] == true) {
									currentSeedBuffIndex++;
									currentSeedBuffIndex = currentSeedBuffIndex % sizeLastRead;
									}
								numUnsuccessfulRandJumps = 0;
								}
			
							}
						numUnsuccessfulRandJumps = 0;
						keyFileBuffer[numKeyBytesWritten] = seedFileBuffer[currentSeedBuffIndex];
				
						seedByteUsedBuffer[currentSeedBuffIndex] = true;	// set dirty flag of seed byte
			
						numKeyBytesWritten++;
						currentKeyBytesWritten++;
						numSeedBytesRead++;
						}
				
	
			
					if( numKeyBytesWritten ==  sizeBuff) {	// buffer is ready to go out to keyfile
						// pad buffer with pseudo-random values to "get rid of" bad sections
						for( int k=0; k<sizeBuff; k++) {
							keyFileBuffer[k] = XOR( keyFileBuffer[k], (int)((255*(float)rand())/RAND_MAX) );
							}
					
						int sizeWrite = fwrite( (void*)keyFileBuffer, sizeof(char), numKeyBytesWritten, keyFile); 
						if( sizeWrite != numKeyBytesWritten ) {
							printf("\nERROR:  key file %d failed to be written.\n", n);
							printf("Key file %d is incomplete\n", n);
							currentKeyBytesWritten = sizeOfKey;			// skip this file
							}
				
						totalBytesWritten += sizeWrite;
					
							
						// seed the rand generator with a key file value
						//  (concatonated value of 4 key file values)
						short tempSeedIndex = rand() % numKeyBytesWritten;
						short tempSeedIndex2 = rand() % numKeyBytesWritten;
						short tempSeedIndex3 = rand() % numKeyBytesWritten;
						short tempSeedIndex4 = rand() % numKeyBytesWritten;
						unsigned long tempSeed = keyFileBuffer[ tempSeedIndex ] 
												| keyFileBuffer[tempSeedIndex2] <<8
												| keyFileBuffer[tempSeedIndex2] <<16
												| keyFileBuffer[tempSeedIndex2] <<24;
						srand( tempSeed );
						numKeyBytesWritten = 0;
						}
							
			
					if( numSeedBytesRead == sizeBuff ) {	// time to read in a new seed buffer
						numSeedBytesRead = 0;
						sizeLastRead = fread( (void*)seedFileBuffer, sizeof(char), sizeBuff, seedFile); 
					
						if( sizeLastRead < sizeBuff ) {
							if( sizeLastRead < sizeOfKey - numKeyBytesWritten) {		// not enough seed bytes remaining
								printf("\nERROR:  seed file must be at least as large as the sum of all desired key files.\n");
								printf("Key files are incomplete\n");
								currentKeyBytesWritten = sizeOfKey;			// end both loops
								n = numberOfKeys;
								quit = true;
								}
							}	
						
						totalBytesRead += sizeLastRead;
					
						// set dirty flag buffer to false
						for(int k=0; k<sizeBuff; k++) {
							seedByteUsedBuffer[k] = false;
							}
						
						if( !quit ) {
							if( seedFileGoodSoFar ) {	
								// check for an entire block of the same byte
								// warn user if such a block exists	
								unsigned char repeatedByte;
								char byteIsRepeated = true;
								if( sizeLastRead > 0) {
									repeatedByte = seedFileBuffer[0];
									}
								for(int j=0; j<sizeLastRead; j++) {
									// check if the byte is repeated
									byteIsRepeated = byteIsRepeated && (seedFileBuffer[j] == repeatedByte);
									}
								if( byteIsRepeated ) {		// print warning message
									printf("\nWARNING:  this seed file contains large blocks of the same, repeated byte.\n");
									printf("The key file will not be completely secure.\n");
									printf("Try using a more random seed file.\n");
									seedFileGoodSoFar = false;
									}
								}
							}
					
						
						// reset the jump point in the seed buffer
						currentSeedBuffIndex = (int)(((float)rand() * sizeLastRead)/RAND_MAX);
						}
				
					}
					
					
				// in each iteration of the above for loop, one byte was written into the keyFileBuffer
				// and after each set of sizeBuff bytes, the buffer was written to file
				// now need to dump the last buffer to file	
			
				if( !quit ) {
					// pad buffer with pseudo-random values to "get rid of" bad sections
					for( int k=0; k<sizeBuff; k++) {		
						keyFileBuffer[k] = XOR( keyFileBuffer[k], (int)((255*(float)rand())/RAND_MAX) );	
						}
			
					int sizeWrite = fwrite( (void*)keyFileBuffer, sizeof(char), numKeyBytesWritten, keyFile); 
					if( sizeWrite != numKeyBytesWritten ) {
						printf("\nERROR:  key file %d failed to be written.\n", n);
						printf("Key file %d is incomplete\n", n);
						}	
					totalBytesWritten += sizeWrite;	
					
					printf("Done with key file %d\n", n);
					}
				if(keyFile != NULL ) fclose(keyFile);		// close this key file		

				}			// end for loop over each key file
		
		
			// print closing status messages
			printf("\n%d bytes read from the seed file.\n", totalBytesRead);
			printf("\n%d bytes written to the key files.\n", totalBytesWritten);
		
			netTime = (unsigned)time( NULL ) - startTime;
			printf("\n%d seconds elapsed.\n", netTime);
		
		
			delete [] keyFileBuffer;
			delete [] seedFileBuffer;
			delete [] seedByteUsedBuffer;
		
			printf("\nDone writing key files.\n");
			}
		
		
		}
		
	
	// close seed file
	if(seedFile != NULL ) fclose(seedFile);
	
	
	delete [] keyFileName;
	delete [] seedFileName;
	delete [] badInputBuffer;
	
	return(0);
	}	
		
		


inline long XOR( long A, long B) {
	return (~(A & B)) & (A | B);
	}