#!/usr/local/bin/perl -w

#
#  Print out arp requests on the local network.
#

use strict;
use Net::PcapUtils;
use NetPacket::Ethernet qw(:ALL);
use NetPacket::ARP;

sub process_pkt {

   my ($arg, $hdr, $pkt) = @_;
   my $eth_obj = NetPacket::Ethernet->decode($pkt);

   if ($eth_obj->{type} == ETH_TYPE_ARP) {

      my $arp_obj = NetPacket::ARP->decode($eth_obj->{data}, $eth_obj);
      print("source hw addr=$arp_obj->{sha}, " .
            "dest hw addr=$arp_obj->{tha}\n");
   }
}


my $result = Net::PcapUtils::loop(\&process_pkt);

if (!$result eq "") {
    print("$result\n");
}

