/**
*	Jason Rohrer
*	7-5-99
*	Encryption piece of HardEncrypt package
*
*	mods:
*		7-15-99:  Jason Rohrer
*					added failed allocation detection
*		8-22-99:  Jason Rohrer
*					removed precompiler directives (#if, #endif) to
*					improve multiplatform compilability
*/


#include <stdio.h>
#include <stdlib.h>
#include <time.h>




// prototypes
inline long XOR( long A, long B);





int main() {
//void main () {
	
	printf(".oO()   HardenedCriminal Software (TM)   ()Oo.\n\n");
	printf("HardEncrypt Package   (c)1999 Little  (open source, end to tyranny)\n");
	printf("HardEncrypt:  uncrackable one-time pad encryption\n");
	
	int quit = 0;
	
	unsigned char *inFileName;
	unsigned char *keyFileName;
	unsigned char *outFileName;

	// allocate space for file names
	inFileName = new unsigned char[99];
	keyFileName = new unsigned char[99];
	outFileName = new unsigned char[99];

	FILE *inFile = NULL;
	FILE *keyFile = NULL;
	FILE *outFile = NULL;
	
	// loop until a good input file is opened
	while( inFile == NULL && !quit ) {
		printf("\nEnter name of file to encrypt:  ");
		scanf("%98s", inFileName);
		
		if( (inFileName[0] == 'q' || inFileName[0] == 'Q') && inFileName[1] == '\0' ) {
			quit = 1;
			break;
			}
		
		inFile = fopen((const char*)inFileName, "rb");
		if( inFile == NULL ) {
			printf("\nERROR:  can't open input file %s\n", inFileName);
			}
		
		}
	
	// loop until a good key file is opened
	while( keyFile == NULL && !quit ) {
		printf("\nEnter name of key file: ");
		scanf("%98s", keyFileName);
		
		if( (keyFileName[0] == 'q' || keyFileName[0] == 'Q') && keyFileName[1] == '\0' ) {
			quit = 1;
			break;
			}
		
		keyFile = fopen((const char*)keyFileName, "rb");
		if( keyFile == NULL ) {
			printf("\nERROR:  can't open key file %s\n", keyFileName);
			}
		}
	
	
	// loop until a good output file is opened
	while( outFile == NULL && !quit ) {
		printf("\nEnter name of output file: ");
		scanf("%98s", outFileName);
		
		if( (outFileName[0] == 'q' || outFileName[0] == 'Q') && outFileName[1] == '\0' ) {
			quit = 1;
			break;
			}
		
		outFile = fopen((const char*)outFileName, "wb");
		if( outFile == NULL ) {
			printf("\nERROR:  can't open output file %s\n", outFileName);
			}
		}
	
	if( !quit ) {
		
		int sizeBuff = 5000;
		int numInBytesRead = sizeBuff;
		int numKeyBytesRead = sizeBuff;
		int numOutBytesWritten = 0;
		
		unsigned char *inFileBuffer = new unsigned char[sizeBuff];
		unsigned char *outFileBuffer = new unsigned char[sizeBuff];
		unsigned char *keyFileBuffer = new unsigned char[sizeBuff];
	
		// check for failed memory alocation
		if( inFileBuffer == NULL || outFileBuffer == NULL || keyFileBuffer == NULL) {
			printf("\nERROR:  not enough memory to allocate the file read-write buffers.\n");
			printf("Free up memory or increase HardEncrypt's partition and try again.\n");
			}
		else {
	
			long totalBytesWritten = 0;
			long totalBytesRead = 0;
	
			unsigned long startTime = (unsigned)time( NULL );
			unsigned long netTime;
	
			while(numInBytesRead == sizeBuff) {		// while not done reading file

				numInBytesRead = fread( (void*)inFileBuffer, sizeof(char), sizeBuff, inFile);
				numKeyBytesRead = fread( (void*)keyFileBuffer, sizeof(char), sizeBuff, keyFile);
			
				totalBytesRead += numInBytesRead;		// track total bytes read
			
				if(numKeyBytesRead < numInBytesRead) {	// check for a small key
					printf("\nERROR:  keyfile must be at least as large as input file.\n");
					printf("Output file is incomplete\n");
					numInBytesRead = 0;			// jump out of while loop
					}
				else {
			
					//XOR the files into the output
					for(int k=0; k<numInBytesRead; k++) {
						outFileBuffer[k] = (~(inFileBuffer[k] & keyFileBuffer[k])) & (inFileBuffer[k] | keyFileBuffer[k]);
						}
					// write the output buffer
				
					numOutBytesWritten = fwrite( (void*)outFileBuffer, sizeof(char), numInBytesRead, outFile);
				
					totalBytesWritten += numOutBytesWritten;		// track total bytes written
				
					if( numOutBytesWritten < numInBytesRead ) {			// check for bad output
						printf("\nERROR:  output file failed to be written.\n");
						printf("Output file is incomplete\n");
						numInBytesRead = 0;			// jump out of while loop
						}
					}
				}
			// print closing status messages
			printf("\n%d bytes read from the input file.\n", totalBytesRead);
			printf("%d bytes written to the output file.\n", totalBytesWritten);
		
			netTime = (unsigned)time( NULL ) - startTime;
			printf("\n%d seconds elapsed.\n", netTime);
		
		
			delete [] inFileBuffer;
			delete [] outFileBuffer;
			delete [] keyFileBuffer;
		
			printf("\nDone encrypting.\n");
			}
		

			
		}
		
	if(outFile != NULL )  fclose(outFile);
	if(inFile != NULL )  fclose(inFile);
	if(keyFile != NULL )  fclose(keyFile);
		
	delete [] keyFileName;
	delete [] inFileName;	
	delete [] outFileName;	
	
	return(0);	
	}
	
	
inline long XOR( long A, long B) {
	return (~(A & B)) & (A | B);
	}
	
