#include <linux/kernel.h>
#include <linux/version.h>
#include <linux/kerneld.h>
#include <linux/module.h>
#include <linux/malloc.h>
#include <linux/tcfs/tcfsapi.h>

#include "rc5.h"

static void *init_key (char *key)
{
	rc5_key_schedule *ks=NULL;

	ks=(rc5_key_schedule *)kmalloc (sizeof (rc5_key_schedule), GFP_KERNEL);
	if (!ks) {
		printk ("TCFS: unable to get a free page\n");
		return NULL;
	}

	rc5_setup (key, (WORD *)*ks);

	return (void *)ks;
}

static void rc5_encrypt_if(char *block, int nb, void *key)
{
	unsigned long *xi;
	int i;
	char *tmp;
	char ct[8];
	rc5_key_schedule *ks=(rc5_key_schedule *)key;

	xi=(long *)block;
	tmp=block;
	rc5_encrypt ((WORD *)tmp, (WORD *)ct, (WORD *)*ks);
	memcpy (tmp, ct, 8L);
	tmp+=8;

	for (i=1;i<nb/8;i++) {
		*(xi+2)^=*xi;
		*(xi+3)^=*(xi+1);
		rc5_encrypt ((WORD *)tmp, (WORD *)ct, (WORD *)*ks);
		memcpy (tmp, ct, 8L);
		tmp+=8;
		xi+=2;
	}
}

static void rc5_decrypt_if(char *block, int nb, void *key)
{
	unsigned long * xi,xo[2],xa[2];
	int i;
	char *tmp;
	char ct[8];
	rc5_key_schedule *ks=(rc5_key_schedule *)key;

	xi=(long *)block;
	tmp=block;
	xo[0]=*xi; xo[1]=*(xi+1);

	if ((xo[0]|xo[1])!=0L) {
		rc5_decrypt((WORD *)tmp,(WORD *)ct,(WORD *)*ks);
		memcpy(tmp,ct,8L);
	}
	tmp+=8;
	xi=(long *)tmp;

	for (i=1;i<nb/8;i++) {
		xa[0]=*xi; xa[1]=*(xi+1);
		if ((xa[0]|xa[1])!=0L) {
			rc5_decrypt((WORD *)tmp,(WORD *)ct,(WORD *)*ks);
			memcpy(tmp,ct,8L);
		}
		*(xi)^=xo[0];
		*(xi+1)^=xo[1];
		xo[0]=xa[0];  
		xo[1]=xa[1];
		tmp+=8;
		xi+=2;
	}
}

static struct tcfs_cipher_operations tcfs_default_ops = {
	init_key,
	NULL,
	rc5_encrypt_if,
	rc5_decrypt_if
};

int
init_module (void)
{
	tcfs_register_cipher ("default", &tcfs_default_ops);

	return 0;
}

void
cleanup_module (void)
{

	tcfs_unregister_cipher ("default");

	return ;
}
