
#pragma module GETSYII "X-3"
/*
 * Copyright (C) 1997 by
 * Digital Equipment Corporation, Maynard, Massachusetts.
 * All rights reserved.
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  of  the  terms  of  such  license  and with the
 * inclusion of the above copyright notice. This software or  any  other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and  ownership of the  software is  hereby
 * transferred.
 *
 * The information in this software is  subject to change without notice
 * and  should  not  be  construed  as a commitment by Digital Equipment
 * Corporation.
 *
 * Digital assumes no responsibility for the use  or  reliability of its
 * software on equipment which is not supplied by Digital.
 *
 * Abstract:
 *
 * This user program tests each of the new environmental GETSYI item
 *      codes.  This test program also verifies the existance of the SRM FRU

 * table.
 *
 * Authors:
 *
 * Paul A. Jacobi, October 1996
 *
 * Modified by:
 *
 *    X-3 PAJ0944   Paul A. Jacobi     13-Jun-1997
 *  Checkin correct version of file.
 *
 *    X-2 PAJ0939   Paul A. Jacobi     29-May-1997
 *  Fix bug in display_fru_revision().  Add standard comments.
 *
 */

#include <stdio>
#include <stdlib>

#include <hwrpbdef>
#include <iledef>
#include <ssdef>
#include <syidef>
#include <vms_macros>

/* External routines */

extern int sys$getsyiw();
extern void sys$exit();

/* External global data */

typedef struct _fru_table {
    uint64 checksum;
    uint32 fru_lenght;
    short unsigned major_revision;
    short unsigned minor_revision;
} FRU_TABLE;

extern FRU_TABLE *exe$gpq_fru_table;

/* forward routines */

void display_fru_revision();
void display_power();
void display_fan();
void display_temperature();
void display_thermal();


/*++
 * main - main routine
 *
 * FUNCTIONAL DESCRIPTION:
 *
 * This routine is the main test routine.  I calls a routine to test each
 * of the new environmental GETSYI item codes.  It also calls a routine
 * to verify the existance of the SRM FRU table.
 *
 * INPUTS:
 * Standard C command line arguments - ignored
 *
 * OUTPUTS:
 * None
 *
 *--
 */

int main(int argc, char **argv)
{

    display_fru_revision();

    display_power();

    display_fan();

    display_temperature();

    display_thermal();

}


/*++
 * display_fru_revision - Display FRU revision if available
 *
 * FUNCTIONAL DESCRIPTION:
 *
 * This routine displays the FRU Table revision.  If the FRU Table is not
 *      available, this routine display an error message.
 *
 * INPUTS:
 * None
 *
 * OUTPUTS:
 * None
 *
 *--
 */
void display_fru_revision()
{
    short minor_revision,major_revision;

    if (exe$gpq_fru_table == 0) {
        printf("ERROR! SRM FRU table is not available!\n");
    }
    else {
        minor_revision = exe$gpq_fru_table->minor_revision;
        major_revision = exe$gpq_fru_table->major_revision;

        printf("SRM FRU revision =   V%d.%d\n",
                   major_revision,minor_revision);
    }

    return;

}


/*++
 * display_power - Display power vector
 *
 * FUNCTIONAL DESCRIPTION:
 *
 * This routine displays power vector.  If $GETSYI returns an error, this
 * routines display the decimal error code.
 *
 * INPUTS:
 * None
 *
 * OUTPUTS:
 * None
 *
 *--
 */
void display_power()
{
    unsigned char getsyi_buffer[16];
    int i;
    unsigned short retlen;
    unsigned char *bp;
    ILE3 item_list[2];
    int status;

    item_list[0].ile3$w_code = SYI$_POWER_VECTOR;
    item_list[0].ile3$w_length = sizeof(getsyi_buffer);
    item_list[0].ile3$ps_bufaddr = getsyi_buffer;
    item_list[0].ile3$ps_retlen_addr = &retlen;
    item_list[1].ile3$w_code = 0;
    item_list[1].ile3$w_length = 0;


    status = sys$getsyiw(0, 0, 0, item_list, 0, 0, 0);

    if good_status(status) {
        printf("SYI_POWER_VECTOR =   ");

        bp = getsyi_buffer;
        for (i=0; i < retlen; i++)
                printf("%02X",*bp++);
        printf("\n");
    }
    else {
        printf("ERROR: SYI_POWER_VECTOR returned status of %d\n", status);
    }

    return;
}


/*++
 * display_fan - Display fan vector
 *
 * FUNCTIONAL DESCRIPTION:
 *
 * This routine displays fan vector.  If $GETSYI returns an error, this
 * routines display the decimal error code.
 *
 * INPUTS:
 * None
 *
 * OUTPUTS:
 * None
 *
 *--
 */
void display_fan()
{
    unsigned char getsyi_buffer[16];
    int i;
    unsigned short retlen;
    unsigned char *bp;
    ILE3 item_list[2];
    int status;

    item_list[0].ile3$w_code = SYI$_FAN_VECTOR;
    item_list[0].ile3$w_length = sizeof(getsyi_buffer);
    item_list[0].ile3$ps_bufaddr = getsyi_buffer;
    item_list[0].ile3$ps_retlen_addr = &retlen;
    item_list[1].ile3$w_code = 0;
    item_list[1].ile3$w_length = 0;


    status = sys$getsyiw(0, 0, 0, item_list, 0, 0, 0);
    if good_status(status) {
        printf("SYI_FAN_VECTOR =   ");

        bp = getsyi_buffer;
        for (i=0; i < retlen; i++)
                printf("%02X",*bp++);
        printf("\n");
    }
    else {
        printf("ERROR: SYI_FAN_VECTOR returned status of %d\n", status);
    }

    return;
}


/*++
 * display_temperature - Display temperature vector
 *
 * FUNCTIONAL DESCRIPTION:
 *
 * This routine displays temperature vector.  If $GETSYI returns an error,
 *      this routines display the decimal error code.
 *
 * INPUTS:
 * None
 *
 * OUTPUTS:
 * None
 *
 *--
 */
void display_temperature()
{
    unsigned char getsyi_buffer[16];
    int i;
    unsigned short retlen;
    unsigned char *bp;
    ILE3 item_list[2];
    int status;

    item_list[0].ile3$w_code = SYI$_TEMPERATURE_VECTOR;
    item_list[0].ile3$w_length = sizeof(getsyi_buffer);
    item_list[0].ile3$ps_bufaddr = getsyi_buffer;
    item_list[0].ile3$ps_retlen_addr = &retlen;
    item_list[1].ile3$w_code = 0;
    item_list[1].ile3$w_length = 0;


    status = sys$getsyiw(0, 0, 0, item_list, 0, 0, 0);
    if good_status(status) {
        printf("SYI_TEMPERATURE_VECTOR =  ");

        bp = getsyi_buffer;
        for (i=0; i < retlen; i++)
                printf("%02X",*bp++);
        printf("\n");
    }
    else {
        printf("ERROR: SYI_TEMPERATURE_VECTOR returned status of %d\n",
status);
    }

    return;
}


/*++
 * display_thermal - Display thermal vector
 *
 * FUNCTIONAL DESCRIPTION:
 *
 * This routine displays thermal vector.  If $GETSYI returns an error, this
 * routines display the decimal error code.
 *
 * INPUTS:
 * None
 *
 * OUTPUTS:
 * None
 *
 *--
 */
void display_thermal()
{
    unsigned char getsyi_buffer[16];
    int i;
    unsigned short retlen;
    unsigned char *bp;
    ILE3 item_list[2];
    int status;

    item_list[0].ile3$w_code = SYI$_THERMAL_VECTOR;
    item_list[0].ile3$w_length = sizeof(getsyi_buffer);
    item_list[0].ile3$ps_bufaddr = getsyi_buffer;
    item_list[0].ile3$ps_retlen_addr = &retlen;
    item_list[1].ile3$w_code = 0;
    item_list[1].ile3$w_length = 0;


    status = sys$getsyiw(0, 0, 0, item_list, 0, 0, 0);
    if good_status(status) {
        printf("SYI_THERMAL_VECTOR =   ");

        bp = getsyi_buffer;
        for (i=0; i < retlen; i++)
                printf("%02X",*bp++);
        printf("\n");

    }
    else {
        printf("ERROR: SYI_THERMAL_VECTOR returned status of %d\n", status);

    }

    return;
}

