c  Program Name            : TAPEANAL.FOR
c    Original Author       : See below
c  References
c    Files open for Input  : Unit 5
c    Files open for Output : Unit 6
c  Revision History follows  Added a file by file block dump
c
c  ----------------------- : 
c    Date of Revision      : 15-APR-1998 
c    Change Author         : JLAURET
c    Purpose of Revision   :  Added number of files info.
c                          : 
c------------------------------------------------------------------------
c
c say $ mount mt:/for
c and run the TAPEANAL --> gives statistics of blocks and their sizes.
c
c  Ejo Schrama                 Contact list (use item 1 as priority first)
c  Dep. of Geodesy             1) gdfgejo@hdetud51.bitnet   earn/bitnet
c  Thijsseweg 11               2) gdfgejo@hdetud1.bitnet    earn/bitnet
c  TU Delft                    3) schrama@hdetud5.bitnet    earn/bitnet
c  2629 JA Delft               4) tudgv1::schrama           surfnet
c  The Netherlands             5) Country=31 015 784975     voice
c
c------------------------------------------------------------------------
      PROGRAM tape_analysis
      implicit none

      parameter userin = 5 ! terminal of user
      parameter userout= 6 ! output

      external io$_readvblk,io$m_datacheck,io$_rewind

      include '($ssdef)'

      integer*4 i,j,irc
      integer*4 chan
      integer*4 status,sys$assign,amount

      integer*2 func1,func2,iosb(4),error,words(10)
      integer*2	fdump/1/,fcont/0/

      byte buff(65535)
      
C     - Get rid of : device will be a MKB+ 3 numbers (SCSI)
	character*6	devnam	
	character*1	ans
	integer*4	bblock,filcnt

	common /wordset/ words,amount
	common /setting/ fdump,fcont
	common/fileinfo/bblock,filcnt

      amount=0

      write(userout,*)
      write(userout,*)  '       -    Tape analysis program V2.5   -           '
      write(userout,*)  ' (c) E. Schrama - Last modified by J.Lauret 26-Dec-96'
      write(userout,*)
      write(userout,*)
 100  write(userout,'(''+'',a,$)')'Device to read from                  : '
      read(userin,'(a)')devnam
      if (devnam.eq.' ') goto 100

      write(userout,'(''+'',a,$)')'Do you want to have a block dump     : '
      read(userin,'(a)')ans
      call str$upcase(ans,ans)
      if (ans.eq.'N')then
	fdump = 0
      	write(userout,'(''+'',a,$)')'Do the all tape without confirmation : '
      	read(userin,'(a)')ans
      	call str$upcase(ans,ans)
      	if (ans.eq.'Y')fcont = 1
      endif
      write(userout,*)
      

c-----------------------------------------------------------------------
      status=sys$assign(devnam,chan,,,)  ! assign devnam to channel chan
      if (status.ne.ss$_normal) stop 'program failed to assign devnam'
c-----------------------------------------------------------------------
      write(userout,*) 'Rewind tape to starting position.'
      func1=%loc(io$_rewind)
      call sys$qiow(,%val(chan),%val(func1),iosb,,,,,,,,)
      irc=-1
      call tsrh(i,iosb,irc)
      if (irc.eq.-2) stop 'Did you mount the tape anyway?'
c-----------------------------------------------------------------------
      write(userout,*) 'Scanning for the first tape label.'
      write(userout,*)
      func1=%loc(io$_readvblk)		! read virtual block
      func2=%loc(io$m_datacheck)	! perform a data check
      i=0				! block counter
 10   continue
        call sys$qiow(,%val(chan),%val(func1+func2),iosb,,,
     -                buff,%val(65535),,,,)
        irc=0
        call tsrh(i,iosb,irc)
      if (irc.ne.-2) goto 10
c-----------------------------------------------------------------------
	write(userout,*)' Number of files on this tape ',filcnt
	write(userout,*) 'Rewind tape to starting position.'

	func1=%loc(io$_rewind)
	call sys$qiow(,%val(chan),%val(func1),iosb,,,,,,,,)
	irc=-1
	call tsrh(i,iosb,irc)

      stop 'Tape analysis done.'
      END




c-----------------------------------------------------------------------
c
c   tape status return handler qiow for tapes
c
c   block == block number which will be updated
c   iosb  == io status block
c   irc   == (0-->read action); (-1-->rewind action) (-2-->stop pgm)
c
c-----------------------------------------------------------------------
	Subroutine tsrh(block,iosb,irc)
	implicit none

	include '($ssdef)'

	parameter prefix='message received ---> '

	parameter userin=5
	parameter userout=6

	integer*4 block,bblock,i,irc,prcdtblk/0/
	integer*2 code,iosb(1),error
	integer*4 filcnt
	character*30 mess
	byte iochar

	integer*2	fdump,fcont,try/0/
	common /setting/ fdump,fcont
	common/fileinfo/bblock,filcnt

c-----------------------------------------------------------------------
      code=iosb(1)
c-----------------------------------------------------------------------
      if (code.ne.ss$_normal) then
        call display
        write(userout,*)
        write(userout,*)' Number of blocks read up to now :',block
	if (prcdtblk.ne.block)
     & 	write(userout,*)' Last file number of blocks      :',bblock
        error=iand(code,7)

        if (error.eq.0) mess='  (warning)'
        if (error.eq.1) mess='  (success)'
        if (error.eq.2) mess='  (error)'
        if (error.eq.3) mess='  (informational (nonstandard) success)'
        if (error.eq.4) mess='  (severe error)'
        if ((error.ge.5) .and. (error.le.7)) mess='  (reserved error)'

        if (code.eq.ss$_abort) then
          write(userout,*) prefix//'ss$_abort trap'//mess

        elseif (code.eq.ss$_datacheck) then
          write(userout,*) prefix//'ss$_datacheck trap'//mess

        elseif (code.eq.ss$_drverr) then
          write(userout,*) prefix//'ss$_drverr trap'//mess

        elseif (code.eq.ss$_endofvolume) then
          write(userout,*) prefix//'ss$_endofvolume trap'//mess

        elseif (code.eq.ss$_medofl) then
          write(userout,*) prefix//'ss$_medofl trap'//mess

        elseif (code.eq.ss$_opincompl) then
          write(userout,*) prefix//'ss$_opincompl trap'//mess

        elseif (code.eq.ss$_cancel) then
          write(userout,*) prefix//'ss$_cancel trap'//mess

        elseif (code.eq.ss$_dataoverun) then
          write(userout,*) prefix//'ss$_dataoverun trap'//mess

        elseif (code.eq.ss$_endoffile) then
c          write(userout,*) prefix//'ss$_endoffile trap'//mess
	  filcnt = filcnt + 1
	  write(userout,*)' EOF detected. End of File #',filcnt

        elseif (code.eq.ss$_format) then
          write(userout,*) prefix//'ss$_format trap'//mess

        elseif (code.eq.ss$_nonexdrv) then
          write(userout,*) prefix//'ss$_nonexdrv trap'//mess

        elseif (code.eq.ss$_parity) then
          write(userout,*) prefix//'ss$_parity trap'//mess

        elseif (code.eq.ss$_volinv) then
          write(userout,*) prefix//'ss$_volinv trap'//mess

        elseif (code.eq.ss$_ctrlerr) then
          write(userout,*) prefix//'ss$_ctrlerr trap'//mess

        elseif (code.eq.ss$_devoffline) then
          write(userout,*) prefix//'ss$_devoffline trap'//mess

        elseif (code.eq.ss$_endoftape) then
          write(userout,*) prefix//'ss$_endoftape trap'//mess

        elseif (code.eq.ss$_illiofunc) then
          write(userout,*) prefix//'ss$_illiofunc trap'//mess

        elseif (code.eq.ss$_timeout) then
          write(userout,*) prefix//'ss$_timeout trap'//mess

        elseif (code.eq.ss$_writlck) then
          write(userout,*) prefix//'ss$_writlck trap'//mess

        else
          write(userout,*) prefix//'undocumented message'//mess
        endif
	bblock = 0

	if (prcdtblk.eq.block)then
		if (try.ne.1)then
			write(userout,*)'May have problem at block -> ',block+1
			write(userout,*)'Trying to determine if error -- Pass2'
			try = 1
		else	
			irc = -2
			write(userout,*)'Unable to continue - Stop'
			return
		endif
	else
c  		- Problem solved
		if (try.eq.1) try = 0
		prcdtblk = block
	endif

	if (fcont.eq.0)then
 10       continue
           write(userout,'(/'' (C)ontinue (Q)uit ? '',$)')
           read(userin,'(a1)') iochar
           if ((iochar.eq.'C') .or. (iochar.eq.'c')) return
           if ((iochar.eq.'Q') .or. (iochar.eq.'q')) then
             irc=-2 ! stop and rewind tape
             return
           endif
          goto 10
	else
	  return
	endif
      else
        if (irc.ne.-1) then
          call putnum(iosb(2))
          block	= block + 1
	  bblock= bblock+ 1
        endif
      endif
      RETURN
      END

c-----------------------------------------------------------------------
c
c subroutine putnum
c
c-----------------------------------------------------------------------
      subroutine putnum(word)
      implicit none

      parameter userout=6

      integer*2 words(10),word
      integer*4 i,amount
      integer*2	fdump,fcont

      
      common /wordset/ words,amount
      common /setting/ fdump,fcont

      amount=amount+1
      if (amount.le.10) then
        words(amount)=word
      else
        if(fdump.eq.1)write(userout,10) (words(i),i=1,10)
 10     format(' ',10i7)
        amount=1
        words(1)=word
      endif

      RETURN
      END

c-----------------------------------------------------------------------
c
c subroutine display
c
c-----------------------------------------------------------------------
      subroutine display
      implicit none

      parameter userout=6

      integer*2 words(10)
      integer*4 i,amount
      integer*2 fdump,fcont
      common /wordset/ words,amount
      common /setting/ fdump,fcont

      if(fdump.eq.0)return
      write(userout,10) (words(i),i=1,amount)
 10   format(' ',<amount>i7)
      amount=0

      RETURN
      END
