c-----------------------------------------------------------------------
c
c Tape handling routines
c ----------------------
c
c  Ejo Schrama                 Contact list (use item 1 as priority first)
c  Dep. of Geodesy             1) gdfgejo@hdetud51.bitnet   earn/bitnet
c  Thijsseweg 11               2) gdfgejo@hdetud1.bitnet    earn/bitnet
c  TU Delft                    3) schrama@hdetud5.bitnet    earn/bitnet
c  2629 JA Delft               4) tudgv1::schrama           surfnet
c  The Netherlands             5) Country=31 015 784975     voice
c
c-----------------------------------------------------------------------
c
c TAPELIB.FOR contains routines for tape handling. Use is made of qiow
c routines (see opsys manuals) which perform direct access to tapes.
c
c In this subroutine library the following routines are defined:
c
c  -1 tape_getblk <-- gets a block regardless size from tape
c  -2 tape_putblk <-- puts a block regardless size to tape
c  -3 tape_assign <-- assigns the tapeunit to an channel (always needed)
c  -4 tape_rewind <-- rewinds the tape to a starting position
c  -5 tape_putmrk <-- writes an end of file marker on tape
c
c The blocksize must be in the range of 14 to 65,535 bytes since
c this is the acceptable boundary for the tape controller. Blocks
c smaller than 14 bytes will be seen as "noise blocks" and are there-
c fore ignored by the controller. Blocks larger than 65,535 cause
c a data overrun message in the error handling. It is advisable to
c use a blocksize of some 8k.
c
c The initializing routine tape_assign has to be used. The tape must be
c mounted as a foreign tape by means of the DCL command MOUNT/FOR MT:
c
c All routines use common block /tape_info/ internally. Please do not
c affect or use the common block.
c----------------------------------------------------------------------
c Error handling, most routines return the variables:
c
c     -1 status (i*4) ... This variable indicates whether the system
c                         service utility was succesfully. It might be
c                         tested as a variable (if it is 1 the routine
c                         was called succesfully). If it is not 1 it can
c                         be tested with the rtl routine lib$signal as
c                         call lib$signal(%val(status)) which causes an
c                         echo on the screen.
c
c     -2 code (i*2) ..... This code can be tested on the condition that
c                         it should be equal to ss$_normal. If not, you
c                         can check it by trying other ss$_ checks. (the
c                         ss$_ macros are inported by the include stmnt.)
c
c Variable status should be used as a first level check, variable code
c as a second level check. The following program is worthwhile to con-
c sider as a typical example:
c
c
c    include '($ssdef)'
c          .
c          .
c    len=65535
c    call tape_getblk(block,len,status,code)
c
c    if (status.ne.1) then          ! routine not serviced properly?
c      call lib%signal(%val(status))! check what went wrong
c      stop                         ! prevent further continuation.
c    endif
c
c    if (code.ne.ss$_normal) then   ! the system request was fulfilled
c                                   ! however something unusual occurred
c      if (code.eq.ss$_parity) then
c                 .
c                 .
c                 .
c      else if (code.eq.ss$_endoffile) then
c                 .
c                 .
c                 .
c      else etc.
c
c-----------------------------------------------------------------------
      subroutine tape_assign(status)
      implicit none
      include '($ssdef)'
      integer*4 channel,status,sys$assign
      common /tape_info/ channel
      status = sys$assign('mta0',channel,,,)
      return
      end
c------------------------------------------------------------------------
c
c rewinds a tape in fast reverse mode
c
c------------------------------------------------------------------------
      subroutine tape_rewind(status,code)
      implicit none
      external io$_rewind
      include '($ssdef)'
      integer*4 channel,status,sys$qiow
      integer*2 func1,iosb(4),code
      common /tape_info/ channel
      func1=%loc(io$_rewind)
      status=sys$qiow(,%val(channel),%val(func1),iosb,,,,,,,,)
      code=iosb(1)
      return
      end
c------------------------------------------------------------------------
c
c subroutine tape_getblk(block,len,status,code)
c
c this routine reads variable length blocks from the tape with is
c assigned by tape_assign in this library
c
c "Block" is an byte array. In order to prevent that data overflow
c occures during reading the tape declare it as "byte block(65535)"
c
c len is an output parameter for the amount of bytes transferred at
c the read operation. (integer*4)
c
c------------------------------------------------------------------------
      subroutine tape_getblk(block,len,status,code)
      implicit none
      external io$_readvblk,io$m_datacheck
      include '($ssdef)'
      integer*4 channel,status,len,sys$qiow
      integer*2 func1,func2,iosb(4),code
      byte block(1)
      common /tape_info/ channel
      func1=%loc(io$_readvblk)
      func2=%loc(io$m_datacheck)
      status=sys$qiow(,%val(channel),%val(func1+func2),iosb,,,
     -                block,%val(65535),,,,)
      code = iosb(1) ! compare code with the ss$ macros
      len  = iosb(2) ! length of variable block read
      return
      end
c------------------------------------------------------------------------
c subroutine tape_putblk(block,len,status,code)
c
c this routine writes variable blocks on the tape with is assigned
c using routine tape_assign of this library
c
c "block" is an byte array, the size of it must be eq to at least "len"
c
c "len" is an input parameter for the amount of bytes to transferred
c during the write operation. (integer*4)
c
c after calling this routine it is set to the amount of bytes trans-
c ferred.
c------------------------------------------------------------------------
      subroutine tape_putblk(block,len,status,code)
      implicit none
      external io$_writevblk,io$m_datacheck
      include '($ssdef)'
      integer*4 channel,status,len,sys$qiow
      integer*2 func1,func2,iosb(4),code
      byte block(1)
      common /tape_info/ channel
      func1=%loc(io$_writevblk)
      func2=%loc(io$m_datacheck)
      status = sys$qiow(,%val(channel),%val(func1+func2),iosb,,,
     -                  block,%val(len),,,,)
      code  =iosb(1) ! status word
      len   =iosb(2) ! length of variable block written
      return
      end
c------------------------------------------------------------------------
c
c Write a tapemark at the current tape position (file separation is
c usually 1 mark, end of tape = 2 marks)
c
c------------------------------------------------------------------------
      subroutine tape_putmrk(status,code)
      implicit none
      external io$_writeof
      include '($ssdef)'
      integer*4 channel,status,sys$qiow
      integer*2 func1,iosb(4),code
      common /tape_info/ channel
      func1=%loc(io$_writeof)
      status = sys$qiow(,%val(channel),%val(func1),iosb,,,,,,,,)
      code   = iosb(1)
      return
      end
