//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.cms.v1;

import java.util.HashSet;
import java.util.Set;
import java.util.Iterator;
import java.util.Vector;
import java.security.cert.X509CRL;
import java.security.cert.CRLException;
import com.dstc.security.x509.X509CRLImpl;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.SetOf;
import com.dstc.security.asn1.Asn1Exception;

/**
 * <p>Implements the PKCS7 ASN.1 structure CRLSet
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class CRLSet extends SetOf
{
  private Set crls;

  /**
   * Constructs a CRLSet from a Set of X509CRL
   */
  public CRLSet(Set crls) throws Asn1Exception, CRLException
  {
    this.crls = crls;

    Iterator it = this.crls.iterator();
    while (it.hasNext())
    {
      Asn1 der = Asn1.decode(((X509CRL)it.next()).getEncoded());
      addComponent(der);
    }
  }

  /**
   * Constructs a CRLSet from a DER encoding
   */
  public CRLSet(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);

    crls = new HashSet();
    for (int i=0; i<components.size(); i++)
    {
      crls.add(new X509CRLImpl(((Asn1)components.elementAt(i)).encode()));
    }
  }

  /**
   * Returns the Set of X509CRL for this CRLSet
   */
  public Set getCRLs()
  {
    return crls;
  }
}

