//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.cms.v1;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.SetOf;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.x509.Attribute;

/**
 * <p> Representation of the ASN.1 structure SignedAttributes
 *
 *     SignedAttributes ::= SET SIZE (1..MAX) OF Attribute
 */
public final class SignedAttributes extends SetOf
{
  private Set atts;
  
  /**
   * Constructs a SignedAttributes from a Set of Attributes
   */
  public SignedAttributes(Set atts)
  {
    this.atts = atts;
    Iterator it = atts.iterator();
    while (it.hasNext())
    {
      addComponent((Asn1)it.next());
    }
  }
  
  /**
   * Constructs a SignedAttributes from a DER encoding
   */
  public SignedAttributes(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);
  
    this.atts = new HashSet();
    for (int i=0; i<components.size(); i++)
    {
      this.atts.add(new Attribute(((Asn1)components.elementAt(i)).encode()));
    }
  }

  /**
   * Returns the Set of Attributes for this SignedAttributes
   */
  public Set getAttributes()
  {
    return this.atts;
  }
}
