//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos;

import java.util.Vector;
import java.util.StringTokenizer;

import com.dstc.security.kerberos.crypto.*;
import com.dstc.security.kerberos.crypto.KeyMaterial;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.v5.*;
import com.dstc.security.kerberos.v5.base.*;
import com.dstc.security.kerberos.v5.crypto.Checksum;
import com.dstc.security.kerberos.v5.crypto.EncryptionType;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import com.dstc.security.kerberos.v5.creds.Ticket;
import com.dstc.security.kerberos.v5.creds.Authenticator;

/**
 * Representation of an Authentication Service request message, used by
 * the KDC and its clients.
 *
 * @author Ming Yung
 */
public class ASRequest extends KerberosMessage
{
  private RequestOptions reqOptions = null;
  private String cRealm = null;
  private PrincipalName cName = null;
  private PrincipalName sName = null;
  private KrbASReq req = null;
  private int cksumType;
  private KerberosCipher cipher = null;
  private int nonce;
  private Vector adds;
  private EncryptionType etype = null;
  private KerberosTime from = null;
  private KerberosTime till = null;
  private KerberosTime rtime = null;
  private ApplicationRequest appReq = null;

  public ASRequest(KeyMaterial cred, RequestOptions opts)
  {
    try
    {
      this.cksumType = cred.getKeyType();

      int type = cred.getKeyType(); 
      Vector etypes = new Vector();
      if (type != 1)
        etypes.addElement(new java.lang.Integer(type));
      etypes.addElement(new java.lang.Integer(1));
      this.etype = new EncryptionType(etypes);
  
      this.reqOptions = opts;
  
      adds = new Vector();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  public void setClientRealm(String realm)
  {
    this.cRealm = realm;
  }

  public void setClientName(String client)
  {
    Vector user = new Vector();
    StringTokenizer tknz = new StringTokenizer(client, "/");
    while (tknz.hasMoreTokens())
      user.addElement(tknz.nextToken());

    this.cName = new PrincipalName(PrincipalName.NT_PRINCIPAL, user);
  }

  public void setServerName(String server)
  {
    Vector sname = new Vector();
    StringTokenizer tknz = new StringTokenizer(server, "/");
    while (tknz.hasMoreTokens())
      sname.addElement(tknz.nextToken());

    this.sName = new PrincipalName(PrincipalName.NT_SRV_INST, sname);
  }

  public void setNonce(int nonce)
  {
    this.nonce = nonce;
  }

  /**
   * Adds an address to the request
   */
  public void addAddress(String address)
  {
    adds.addElement(address);
  }

  public void setTicketValidity(int hours)
  {
    this.till = new KerberosTime(hours);
  }

  public byte[] getEncoded()
  {
    KDCReqBody reqBody 
      = new KDCReqBody(reqOptions.getOptions(), cName, new Realm(cRealm), 
                       sName, from, till, rtime, nonce, etype, 
                       new HostAddresses(adds), null, null);

    this.req = new KrbASReq(reqBody, null);
    return this.req.encode();
  }
}
