////////////////////////////////////////////////////////////////////////////
//
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
//
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC
// file. If your distribution of this software does not contain
// a LICENSE.DOC file then you have no rights to use this
// software in any manner and should contact DSTC at the address
// below to determine an appropriate licensing arrangement.
//
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
//
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
//
////////////////////////////////////////////////////////////////////////////

package com.dstc.security.kerberos;

import com.dstc.security.kerberos.crypto.KerberosCipher;
import com.dstc.security.kerberos.crypto.CryptoException;
import com.dstc.security.kerberos.v5.base.*;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import com.dstc.security.kerberos.v5.APRep;
import com.dstc.security.kerberos.v5.EncAPRepPart;
import com.dstc.security.kerberos.v5.BadMessageTypeException;
import com.dstc.security.kerberos.v5.BadVersionException;

public abstract class KerberosMessage
{
  // Add constants for protocol message types.
  // nt 1999/05/24
  /**
   * Message type for AS request.
   */
  public static final int KRB_AS_REQ = 10;

  /**
   * Message type for AS reply.
   */
  public static final int KRB_AS_REP = 11;

  /**
   * Message type for TGS request.
   */
  public static final int KRB_TGS_REQ = 12;

  /**
   * Message type for TGS reply.
   */
  public static final int KRB_TGS_REP = 13;

  /**
   * Message type for AP request.
   */
  public static final int KRB_AP_REQ = 14;

  /**
   * Message type for AP reply.
   */
  public static final int KRB_AP_REP = 15;

  /**
   * Message type for KRB_SAFE message.
   */
  public static final int KRB_SAFE = 20;

  /**
   * Message type for KRB_PRIV message.
   */
  public static final int KRB_PRIV = 21;

  /**
   * Message type for KRB_CRED message.
   */
  public static final int KRB_CRED = 22;

  /**
   * Message type for error messages from the KDC.
   */
  //public static final int KRB_PRIV = 30;

  public abstract byte[] getEncoded();
}
