////////////////////////////////////////////////////////////////////////////
//
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
//
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC
// file. If your distribution of this software does not contain
// a LICENSE.DOC file then you have no rights to use this
// software in any manner and should contact DSTC at the address
// below to determine an appropriate licensing arrangement.
//
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
//
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
//
////////////////////////////////////////////////////////////////////////////

package com.dstc.security.kerberos;

import com.dstc.security.kerberos.v5.base.KDCOptions;

/**
 * <p>A class wrapping KDCOptions.
 *
 * @version 0.98, 98/07/01
 * @author Nam Tran
 */
public class RequestOptions {
  private KDCOptions kdcOpts;

  /**
   * Constructs a RequestOptions from a string containing option names.
   * Those options named will be turned on. The string is normally the value
   * of an appropriate property. For example:
   *    <p> krb5.requester.kdcoptions=renewable, forwardable
   * Acceptable option names are: forwardable, forwarded, proxiable, proxy,
   * allow-postdate, postdated, renewable, disable-transited-check,
   * renewable-ok, enc-tkt-in-skey, renew, validate. Option names are not
   * case-sensitive.
   *
   * @param opts A string containing a list of comma separated option names.
   */
  public RequestOptions(String opts)
  {
    kdcOpts = new KDCOptions(opts);
  }

  /**
   * Checks if an option is turned on. Returns true for yes, false otherwise.
   *
   * @param opt Name of the option to check for.
   */
  public boolean isOn(String opt)
  {
    return kdcOpts.isOn(opt);
  }

  /**
   * Turn ons an option.
   *
   * @param opt Name of the option to turn on.
   */
  public void setOn(String opt)
  {
    kdcOpts.setOn(opt);
  }

  /**
   * Returns the KDCOptions equivalent of this set of options.
   */
  public KDCOptions getOptions()
  {
    return kdcOpts;
  }
}
