//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.creds;

import java.io.OutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

/**
 * A FilterOutputStream for the credential cache
 *
 * @version 0.98, 98/11/01
 * @author Ming Yung
 */
final class CCOutputStream extends FilterOutputStream
{
  public CCOutputStream(OutputStream os)
  {
    super(os);
  }

  public void writeByte(byte b) throws IOException
  {
    byte temp[] = {b};

    write(temp);
  }

  public void writeShort(int s) throws IOException
  {
    byte[] temp = new byte[2];
    temp[0] = (byte)((s >> 8) & 0xff);
    temp[1] = (byte)(s & 0xff);

    write(temp);
  }

  public void writeInt(int i) throws IOException
  {
    byte[] temp = new byte[4];
    temp[0] = (byte)((i >> 24) & 0xff);
    temp[1] = (byte)((i >> 16) & 0xff);
    temp[2] = (byte)((i >> 8) & 0xff);
    temp[3] = (byte)(i & 0xff);

    write(temp);
  }

  public void writeBytes(byte in[]) throws IOException
  {
    write(in);
  }

  public void writeBinaryString(byte[] bs) throws IOException
  {
    writeInt(bs.length);
    write(bs);
  }

  public void writeBinaryString(String str) throws IOException
  {
    writeBinaryString(str.getBytes());
  }
}
