//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.creds;

import com.dstc.security.kerberos.v5.base.*;
import com.dstc.security.kerberos.v5.crypto.EncryptionKey;
import com.dstc.security.kerberos.v5.KrbCredInfo;
import com.dstc.security.asn1.Asn1Exception;

/**
 * A representation of the set of essential information of a Kerberos credential
 *
 * @author Nam Tran
 */
public class CredentialInfo 
{
  private EncryptionKey sessionKey;
  private Realm crealm, srealm;
  private PrincipalName cname, sname;
  private KerberosTime authTime;
  private KerberosTime startTime;
  private KerberosTime endTime;
  private KerberosTime renewTill;
  private TicketFlags flags;
  private HostAddresses caddr;

  private KrbCredInfo krbCredInfo = null;

  /**
   * Constructs a CredentialInfo. All the parameters except the first one are
   * optional, i.e. could be null.
   */
  public CredentialInfo(EncryptionKey key, Realm crealm, PrincipalName cname,
TicketFlags flags, KerberosTime authTime, 
KerberosTime startTime, KerberosTime endTime,
KerberosTime renewTill, Realm srealm,
PrincipalName sname, HostAddresses caddr) {
    sessionKey = key;
    this.crealm = crealm;
    this.cname = cname;
    this.flags = flags;
    this.authTime = authTime;
    this.startTime = startTime;
    this.endTime = endTime;
    this.renewTill = renewTill;
    this.srealm = srealm;
    this.sname = sname;
    this.caddr = caddr;

    this.krbCredInfo = new KrbCredInfo(key, crealm, cname, flags, authTime,
      startTime, endTime, renewTill, srealm, sname, caddr);
  }

  public CredentialInfo(byte[] encoded) throws Asn1Exception
  {
    this.krbCredInfo = new KrbCredInfo(encoded);
  }

  public byte[] getEncoded()
  {
    return krbCredInfo.encode();
  }

  /**
   * Returns the session key 
   */
  public EncryptionKey getSessionKey()
  {
    return this.sessionKey;
  }

  /**
   * Returns the client realm
   */
  public Realm getClientRealm() {
    return crealm;
  }

  /**
   * Returns the client name
   */
  public PrincipalName getClientName() {
    return cname;
  }

  /**
   * Sets the client realm
   */
  public void setClientRealm(Realm crealm) {
    this.crealm = crealm;
  }

  /**
   * Sets the client name
   */
  public void setClientName(PrincipalName cname) {
    this.cname = cname;
  }
 
  /**
   * Returns the ticket flags
   */
  public TicketFlags getTicketFlags() {
    return flags;
  }

  /**
   * Returns the authentication time
   */
  public KerberosTime getAuthTime() {
    return authTime;
  }

  /**
   * Returns the start time
   */
  public KerberosTime getStartTime() {
    return startTime;
  }

  /**
   * Returns the end time
   */
  public KerberosTime getEndTime() {
    return endTime;
  }

  /**
   * Returns the renew-till time
   */
  public KerberosTime getRenewTill() {
    return renewTill;
  }

  /**
   * Returns the server realm
   */
  public Realm getServerRealm() {
    return srealm;
  }

  /**
   * Returns the server name
   */
  public PrincipalName getServerName() {
    return sname;
  }

  /**
   * Returns the client addresses
   */
  public HostAddresses getClientAddress() {
    return caddr;
  }

  private String toHexString(byte bytes[])
  {
    StringBuffer sb = new StringBuffer();
    for (int i=0; i<bytes.length; i++)
    {
      sb.append(java.lang.Integer.toHexString(bytes[i] & 0xff));
      sb.append("  ");
    }
    return sb.toString();
  }
}
