//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.creds;

import java.io.*;
import java.util.Date;
import java.util.Vector;
import java.util.Enumeration;
import java.util.StringTokenizer;
 
/**
 * A representation of the name of a credential entry 
 * 
 * @version 0.98, 98/11/01
 * @author Ming Yung
 */
public class CredentialName
{
  private int nameType;
  private String realm;
  private Vector nameComponents;

  public CredentialName()
  {
    this.nameComponents = new Vector();
  }

  public CredentialName(int nameType, String realm, Vector comps)
  {
    this.nameType = nameType;
    this.realm = realm;
    this.nameComponents = comps;
  }

  public CredentialName(String simpleName)
  {
    this.nameType = 1;

    StringTokenizer tknz = new StringTokenizer(simpleName, "@", false);
    this.nameComponents = new Vector();
    this.nameComponents.addElement(tknz.nextToken());
    this.realm = tknz.nextToken();
  }

  /**
   * Constructs a Name from the InputStream
   */
  public CredentialName(CCInputStream cis) throws IOException
  {
    this();
    this.nameType = cis.readInt();
    int numComps = cis.readInt();
    this.realm = new String(cis.readBinaryString());

    for (int i=0; i<numComps; i++)
    {
      this.nameComponents.addElement(new String(cis.readBinaryString()));
    }
  }

  /**
   * Returns the name type of this name
   */
  public int getNameType() 
  {
    return nameType;
  }

  /**
   * Returns the Vector of name components for this name
   */
  public Vector getNameComponents() 
  {
    return nameComponents;
  }

  /**
   * Return the realm string for this name
   */
  public String getRealm() 
  {
    return realm;
  }

  /**
   * Writes this Name out to the OutputStream
   */
  public void write(CCOutputStream cc) throws IOException
  {
    cc.writeInt(this.nameType);
    cc.writeInt(this.nameComponents.size());
    cc.writeBinaryString(this.realm);
    for (int i=0; i<this.nameComponents.size(); i++)
    {
      cc.writeBinaryString((String)this.nameComponents.elementAt(i));
    }
  }

  public String toString()
  {
    StringBuffer sb = new StringBuffer();

    int i = 0;
    while (true)
    {
       sb.append((String)nameComponents.elementAt(i++)); 
       if (i == nameComponents.size()) break; 
       sb.append("/");
    }
    sb.append("@" + this.realm);
    return sb.toString();
  }
}

