//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.creds;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.Kerberos;
import com.dstc.security.kerberos.KerberosContext;

/**
 * An abstract class representing a store for Credentials.
 *
 * <p>Current concrete implementations are MemoryCredentialStore and
 * FileCredentialStore
 *
 * @author Ming Yung
 */
public abstract class CredentialStore
{
  private static CredentialStore instance = null;
  protected static KerberosContext ctx = null;

  static
  {
    if (instance == null)
    {
      try
      {
        ctx = Kerberos.getDefault().getKerberosContext();

        instance 
          = new FileCredentialStore(ctx.getCCName());
      }
      catch (FileNotFoundException e)
      {
        System.out.println("CredentialStore exception:");
        System.out.println("  Check System property jcsi.kerberos.ccache");
        e.printStackTrace();
      }
      catch (IOException e)
      {
        e.printStackTrace();
      }
    }
  }

  public static CredentialStore getDefault()
  {
    return instance;
  }
 
  public static CredentialStore getInstance(String type)
  {
    if (type.equalsIgnoreCase("File"))
      return instance;
    else if (type.equalsIgnoreCase("Memory"))
      return new MemoryCredentialStore();
    else
      return null;
  }
 
  public abstract void put(Credential creds);

  public abstract Credential getCredential(String name);
 
  public abstract Iterator getCredentials();
 
  public abstract String getStoreType();
 
  //public abstract void update();

  public abstract String getDefaultUser();
}
