//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.creds;

import java.util.Vector;
import java.util.Iterator;
import java.util.Hashtable;
import java.util.Enumeration;
import java.io.*;

/**
 * An implementation of CredentialStore for MIT v5 credential caches.
 *
 * @author Ming Yung
 */
final class FileCredentialStore extends MemoryCredentialStore
{
  private File file = null;

  FileCredentialStore(String fileName) throws IOException
  {
    super();
    this.file = new File(fileName);
    if (file.exists())
      load(file);
    else
    {
      file.createNewFile();
      this.client 
        = new CredentialName(ctx.getUsername() + "@" + ctx.getRealm());
    }
  }

  public String getStoreType()
  {
    return "File";
  }

  public void put(Credential cred)
  {
    super.put(cred);

    try
    {
      FileOutputStream os = new FileOutputStream(file);
      write(os);
      os.close();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  synchronized void load(File file) throws IOException
  {
    FileInputStream is = new FileInputStream(file);

    CCInputStream cis 
      = new CCInputStream(new DataInputStream(new BufferedInputStream(is)));

    //Check version: FCC_VNO_3
    int first =  is.read();
    int second =  is.read();

    if (((byte)(first & 0xff) != (byte)0x05)
        || ((byte)(second & 0xff) != (byte)0x03))
    {
      throw new IOException("Not an acceptable credential file");
    }

    // Client
    client = new CredentialName(cis);

    while (true)
    {
      if (cis.available() == 0)
        break;

      Credential cred = new Credential(cis);
      creds.put(cred.getServiceName(), cred);
    }

    is.close();
  }

  /**
   * Writes this CredentialCache out to the OutputStream
   */
  synchronized void write(OutputStream os) throws IOException
  {
    CCOutputStream cc = new CCOutputStream(os);

    //FCC_VNO_3
    cc.writeByte((byte)0x05);
    cc.writeByte((byte)0x03);

    //Client
    this.client.write(cc);

    Enumeration enum = this.creds.elements();
    while (enum.hasMoreElements())
    {
      ((Credential)enum.nextElement()).write(cc);
    }
  }
}
