//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.creds;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.crypto.CryptoException;
import com.dstc.security.kerberos.crypto.KerberosCipher;
import com.dstc.security.kerberos.crypto.KeyMaterial;
import com.dstc.security.kerberos.crypto.KerberosKey;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import com.dstc.security.kerberos.v5.creds.Ticket;
import com.dstc.security.kerberos.v5.creds.EncTicketPart;
import com.dstc.security.kerberos.v5.*;
import com.dstc.security.kerberos.v5.base.*;

/**
 * Representation of a Kerberos ticket
 *
 * @author Ming Yung
 */
public class KerberosTicket
{
  private Ticket ticket = null;
  private EncryptedData encData = null;
  private EncTicketPart encTicketPart = null;
  private KerberosCipher cipher = null;

  public KerberosTicket(Ticket ticket)
  {
    this.ticket = ticket;
    this.encData = this.ticket.getEncrypted();
  }

  public KerberosTicket(byte[] encoded)
    throws Asn1Exception, BadVersionException,
           BadMessageTypeException
  {
    this.ticket = new Ticket(encoded);
    this.encData = this.ticket.getEncrypted();
  }

  public void initDecrypt(KeyMaterial cred) throws CryptoException
  {
    KerberosCipher cipher = new KerberosCipher(cred, null, null);
    cipher.initDecrypt();

    this.cipher = cipher;
  }

  public void decrypt()
    throws Asn1Exception, CryptoException, KerberosException,
           BadMessageTypeException
  {
    if (this.cipher == null)
      throw new KerberosException("Cipher not yet set");

    this.encTicketPart
      = new EncTicketPart(this.cipher.decrypt(encData));
  }

  public byte[] getKeyBytes()
  {
    return this.encTicketPart.getKey().getKeyBytes();
  }

  public int getKeyType()
  {
    return this.encTicketPart.getKey().getKeyType();
  }

  public byte[] getEncoded()
  {
    return this.ticket.encode();
  }

  public KerberosKey getContextKey()
  {
    return new KerberosKey(getKeyType(), getKeyBytes());
  }

  /**
   * Returns the Realm for this Ticket
   */
  public String getRealm()
  {
    return this.ticket.getRealm().getName();
  }

  /**
   * Returns the server name for this Ticket
   */
  public String getServerName()
  {
    return this.ticket.getServerName().toString();
  }
}
